/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.ntlm;

import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Server;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class NTLMServer
implements SaslServer {
    private static final String NTLM_VERSION = "com.sun.security.sasl.ntlm.version";
    private static final String NTLM_DOMAIN = "com.sun.security.sasl.ntlm.domain";
    private static final String NTLM_HOSTNAME = "com.sun.security.sasl.ntlm.hostname";
    private static final String NTLM_RANDOM = "com.sun.security.sasl.ntlm.random";
    private final Random random;
    private final Server server;
    private byte[] nonce;
    private int step = 0;
    private String authzId;
    private final String mech;
    private String hostname;
    private String target;

    NTLMServer(String mech, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        this.mech = mech;
        String version = null;
        String domain = null;
        Random rtmp = null;
        if (props != null) {
            domain = (String)props.get(NTLM_DOMAIN);
            version = (String)props.get(NTLM_VERSION);
            rtmp = (Random)props.get(NTLM_RANDOM);
        }
        Random random = this.random = rtmp != null ? rtmp : new Random();
        if (version == null) {
            version = System.getProperty("ntlm.version");
        }
        if (domain == null) {
            domain = serverName;
        }
        if (domain == null) {
            throw new SaslException("Domain must be provided as the serverName argument or in props");
        }
        try {
            this.server = new Server(version, domain){

                @Override
                public char[] getPassword(String ntdomain, String username) {
                    try {
                        RealmCallback rcb = ntdomain == null || ntdomain.isEmpty() ? new RealmCallback("Domain: ") : new RealmCallback("Domain: ", ntdomain);
                        NameCallback ncb = new NameCallback("Name: ", username);
                        PasswordCallback pcb = new PasswordCallback("Password: ", false);
                        cbh.handle(new Callback[]{rcb, ncb, pcb});
                        char[] passwd = pcb.getPassword();
                        pcb.clearPassword();
                        return passwd;
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    catch (UnsupportedCallbackException uce) {
                        return null;
                    }
                }
            };
        }
        catch (NTLMException ne) {
            throw new SaslException("NTLM: server creation failure", ne);
        }
        this.nonce = new byte[8];
    }

    @Override
    public String getMechanismName() {
        return this.mech;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            ++this.step;
            if (this.step == 1) {
                this.random.nextBytes(this.nonce);
                return this.server.type2(response, this.nonce);
            }
            String[] out = this.server.verify(response, this.nonce);
            this.authzId = out[0];
            this.hostname = out[1];
            this.target = out[2];
            return null;
        }
        catch (NTLMException ex) {
            throw new SaslException("NTLM: generate response failure", ex);
        }
    }

    @Override
    public boolean isComplete() {
        return this.step >= 2;
    }

    @Override
    public String getAuthorizationID() {
        if (!this.isComplete()) {
            throw new IllegalStateException("authentication not complete");
        }
        return this.authzId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("Not supported yet.");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("Not supported yet.");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("authentication not complete");
        }
        switch (propName) {
            case "javax.security.sasl.qop": {
                return "auth";
            }
            case "javax.security.sasl.bound.server.name": {
                return this.target;
            }
            case "com.sun.security.sasl.ntlm.hostname": {
                return this.hostname;
            }
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

