/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(X509SKIResolver.class);

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineLookupResolveX509Certificate(element, baseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        LOG.debug("Can I resolve {}?", element.getTagName());
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            LOG.debug("I can't");
            return null;
        }
        XMLX509SKI[] x509childObject = null;
        Element[] x509childNodes = null;
        x509childNodes = XMLUtils.selectDsNodes(element.getFirstChild(), "X509SKI");
        if (x509childNodes == null || x509childNodes.length <= 0) {
            LOG.debug("I can't");
            return null;
        }
        try {
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SKI"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                LOG.debug("", ex);
                throw ex;
            }
            x509childObject = new XMLX509SKI[x509childNodes.length];
            for (int i = 0; i < x509childNodes.length; ++i) {
                x509childObject[i] = new XMLX509SKI(x509childNodes[i], baseURI);
            }
            Iterator<Certificate> storageIterator = storage.getIterator();
            while (storageIterator.hasNext()) {
                X509Certificate cert = (X509Certificate)storageIterator.next();
                XMLX509SKI certSKI = new XMLX509SKI(element.getOwnerDocument(), cert);
                for (int i = 0; i < x509childObject.length; ++i) {
                    if (!certSKI.equals(x509childObject[i])) continue;
                    LOG.debug("Return PublicKey from {}", cert.getSubjectX500Principal().getName());
                    return cert;
                }
            }
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException(ex);
        }
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String baseURI, StorageResolver storage) {
        return null;
    }
}

