/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.Connections;
import com.sun.jndi.ldap.pool.ConnectionsRef;
import com.sun.jndi.ldap.pool.ConnectionsWeakRef;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;

public final class Pool {
    static final boolean debug = LdapPoolManager.debug;
    private static final ReferenceQueue<ConnectionsRef> queue = new ReferenceQueue();
    private static final Collection<Reference<ConnectionsRef>> weakRefs = Collections.synchronizedList(new LinkedList());
    private final int maxSize;
    private final int prefSize;
    private final int initSize;
    private final Map<Object, ConnectionsRef> map = new WeakHashMap<Object, ConnectionsRef>();

    public Pool(int initSize, int prefSize, int maxSize) {
        this.prefSize = prefSize;
        this.maxSize = maxSize;
        this.initSize = initSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(Object id, long timeout, PooledConnectionFactory factory) throws NamingException {
        Connections conns;
        this.d("get(): ", id);
        if (debug) {
            Map<Object, ConnectionsRef> map = this.map;
            synchronized (map) {
                this.d("size: ", this.map.size());
            }
        }
        Pool.expungeStaleConnections();
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            conns = this.getConnections(id);
            if (conns == null) {
                this.d("get(): creating new connections list for ", id);
                conns = new Connections(id, this.initSize, this.prefSize, this.maxSize, factory);
                ConnectionsRef connsRef = new ConnectionsRef(conns);
                this.map.put(id, connsRef);
                ConnectionsWeakRef weakRef = new ConnectionsWeakRef(connsRef, queue);
                weakRefs.add(weakRef);
            }
            this.d("get(): size after: ", this.map.size());
        }
        return conns.get(timeout, factory);
    }

    private Connections getConnections(Object id) {
        ConnectionsRef ref = this.map.get(id);
        return ref != null ? ref.getConnections() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(long threshold) {
        ArrayList<ConnectionsRef> copy;
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            copy = new ArrayList<ConnectionsRef>(this.map.values());
        }
        ArrayList<ConnectionsRef> removed = new ArrayList<ConnectionsRef>();
        for (ConnectionsRef ref : copy) {
            Connections conns = ref.getConnections();
            if (!conns.expire(threshold)) continue;
            this.d("expire(): removing ", conns);
            removed.add(ref);
        }
        Map<Object, ConnectionsRef> map2 = this.map;
        synchronized (map2) {
            this.map.values().removeAll(removed);
        }
        Pool.expungeStaleConnections();
    }

    private static void expungeStaleConnections() {
        ConnectionsWeakRef releaseRef = null;
        while ((releaseRef = (ConnectionsWeakRef)queue.poll()) != null) {
            Connections conns = releaseRef.getConnections();
            if (debug) {
                System.err.println("weak reference cleanup: Closing Connections:" + conns);
            }
            conns.close();
            weakRefs.remove(releaseRef);
            releaseRef.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showStats(PrintStream out) {
        out.println("===== Pool start ======================");
        out.println("maximum pool size: " + this.maxSize);
        out.println("preferred pool size: " + this.prefSize);
        out.println("initial pool size: " + this.initSize);
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            out.println("current pool size: " + this.map.size());
            for (Map.Entry<Object, ConnectionsRef> entry : this.map.entrySet()) {
                Object id = entry.getKey();
                Connections conns = entry.getValue().getConnections();
                out.println("   " + id + ":" + conns.getStats());
            }
        }
        out.println("====== Pool end =====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<Object, ConnectionsRef> map = this.map;
        synchronized (map) {
            return super.toString() + " " + this.map.toString();
        }
    }

    private void d(String msg, int i) {
        if (debug) {
            System.err.println(this + "." + msg + i);
        }
    }

    private void d(String msg, Object obj) {
        if (debug) {
            System.err.println(this + "." + msg + obj);
        }
    }
}

