/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WindowsProgressBarUI
extends BasicProgressBarUI {
    private Rectangle previousFullBox;
    private Insets indeterminateInsets;

    public static ComponentUI createUI(JComponent x) {
        return new WindowsProgressBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.FALSE);
            this.progressBar.setBorder(null);
            this.indeterminateInsets = UIManager.getInsets("ProgressBar.indeterminateInsets");
        }
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        int baseline = super.getBaseline(c, width, height);
        if (XPStyle.getXP() != null && this.progressBar.isStringPainted() && this.progressBar.getOrientation() == 0) {
            FontMetrics metrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
            int y = this.progressBar.getInsets().top;
            if (this.progressBar.isIndeterminate()) {
                y = -1;
                --height;
            } else {
                y = 0;
                height -= 3;
            }
            baseline = y + (height + metrics.getAscent() - metrics.getLeading() - metrics.getDescent()) / 2;
        }
        return baseline;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            XPStyle.Skin skin = xp.getSkin(this.progressBar, TMSchema.Part.PP_BAR);
            return new Dimension((int)super.getPreferredInnerHorizontal().getWidth(), skin.getHeight());
        }
        return super.getPreferredInnerHorizontal();
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            XPStyle.Skin skin = xp.getSkin(this.progressBar, TMSchema.Part.PP_BARVERT);
            return new Dimension(skin.getWidth(), (int)super.getPreferredInnerVertical().getHeight());
        }
        return super.getPreferredInnerVertical();
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            boolean vertical = this.progressBar.getOrientation() == 1;
            boolean isLeftToRight = WindowsGraphicsUtils.isLeftToRight(c);
            int barRectWidth = this.progressBar.getWidth();
            int barRectHeight = this.progressBar.getHeight() - 1;
            int amountFull = this.getAmountFull(null, barRectWidth, barRectHeight);
            this.paintXPBackground(g, vertical, barRectWidth, barRectHeight);
            if (this.progressBar.isStringPainted()) {
                g.setColor(this.progressBar.getForeground());
                if ((barRectWidth -= 2) <= 0 || (barRectHeight -= 2) <= 0) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g;
                g2.setStroke(new BasicStroke(vertical ? barRectWidth : barRectHeight, 0, 2));
                if (!vertical) {
                    if (isLeftToRight) {
                        g2.drawLine(2, barRectHeight / 2 + 1, amountFull - 2, barRectHeight / 2 + 1);
                    } else {
                        g2.drawLine(2 + barRectWidth, barRectHeight / 2 + 1, 2 + barRectWidth - (amountFull - 2), barRectHeight / 2 + 1);
                    }
                    this.paintString(g, 0, 0, barRectWidth, barRectHeight, amountFull, null);
                } else {
                    g2.drawLine(barRectWidth / 2 + 1, barRectHeight + 1, barRectWidth / 2 + 1, barRectHeight + 1 - amountFull + 2);
                    this.paintString(g, 2, 2, barRectWidth, barRectHeight, amountFull, null);
                }
            } else {
                XPStyle.Skin skin = xp.getSkin(this.progressBar, vertical ? TMSchema.Part.PP_CHUNKVERT : TMSchema.Part.PP_CHUNK);
                int thickness = vertical ? barRectWidth - 5 : barRectHeight - 5;
                int chunkSize = xp.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSCHUNKSIZE, 2);
                int spaceSize = xp.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
                int nChunks = (amountFull - 4) / (chunkSize + spaceSize);
                if (spaceSize > 0 && nChunks * (chunkSize + spaceSize) + chunkSize < amountFull - 4) {
                    ++nChunks;
                }
                for (int i = 0; i < nChunks; ++i) {
                    if (vertical) {
                        skin.paintSkin(g, 3, barRectHeight - i * (chunkSize + spaceSize) - chunkSize - 2, thickness, chunkSize, null);
                        continue;
                    }
                    if (isLeftToRight) {
                        skin.paintSkin(g, 4 + i * (chunkSize + spaceSize), 2, chunkSize, thickness, null);
                        continue;
                    }
                    skin.paintSkin(g, barRectWidth - (2 + (i + 1) * (chunkSize + spaceSize)), 2, chunkSize, thickness, null);
                }
            }
        } else {
            super.paintDeterminate(g, c);
        }
    }

    @Override
    protected void setAnimationIndex(int newValue) {
        super.setAnimationIndex(newValue);
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            if (this.boxRect != null) {
                Rectangle chunk = this.getFullChunkBounds(this.boxRect);
                if (this.previousFullBox != null) {
                    chunk.add(this.previousFullBox);
                }
                this.progressBar.repaint(chunk);
            } else {
                this.progressBar.repaint();
            }
        }
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            return 6;
        }
        return super.getBoxLength(availableLength, otherDimension);
    }

    @Override
    protected Rectangle getBox(Rectangle r) {
        Rectangle rect = super.getBox(r);
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            boolean vertical = this.progressBar.getOrientation() == 1;
            TMSchema.Part part = vertical ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
            Insets ins = this.indeterminateInsets;
            int currentFrame = this.getAnimationIndex();
            int framecount = this.getFrameCount() / 2;
            int gap = xp.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
            currentFrame %= framecount;
            if (!vertical) {
                rect.y += ins.top;
                rect.height = this.progressBar.getHeight() - ins.top - ins.bottom;
                int len = this.progressBar.getWidth() - ins.left - ins.right;
                double delta = (double)(len += (rect.width + gap) * 2) / (double)framecount;
                rect.x = (int)(delta * (double)currentFrame) + ins.left;
            } else {
                rect.x += ins.left;
                rect.width = this.progressBar.getWidth() - ins.left - ins.right;
                int len = this.progressBar.getHeight() - ins.top - ins.bottom;
                double delta = (double)(len += (rect.height + gap) * 2) / (double)framecount;
                rect.y = (int)(delta * (double)currentFrame) + ins.top;
            }
        }
        return rect;
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        XPStyle xp = XPStyle.getXP();
        if (xp != null) {
            boolean vertical = this.progressBar.getOrientation() == 1;
            int barRectWidth = this.progressBar.getWidth();
            int barRectHeight = this.progressBar.getHeight();
            this.paintXPBackground(g, vertical, barRectWidth, barRectHeight);
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                g.setColor(this.progressBar.getForeground());
                if (!(g instanceof Graphics2D)) {
                    return;
                }
                this.paintIndeterminateFrame(this.boxRect, (Graphics2D)g, vertical, barRectWidth, barRectHeight);
                if (this.progressBar.isStringPainted()) {
                    if (!vertical) {
                        this.paintString(g, -1, -1, barRectWidth, barRectHeight, 0, null);
                    } else {
                        this.paintString(g, 1, 1, barRectWidth, barRectHeight, 0, null);
                    }
                }
            }
        } else {
            super.paintIndeterminate(g, c);
        }
    }

    private Rectangle getFullChunkBounds(Rectangle box) {
        int gap;
        boolean vertical = this.progressBar.getOrientation() == 1;
        XPStyle xp = XPStyle.getXP();
        int n = gap = xp != null ? xp.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0) : 0;
        if (!vertical) {
            int chunksize = box.width + gap;
            return new Rectangle(box.x - chunksize * 2, box.y, chunksize * 3, box.height);
        }
        int chunksize = box.height + gap;
        return new Rectangle(box.x, box.y - chunksize * 2, box.width, chunksize * 3);
    }

    private void paintIndeterminateFrame(Rectangle box, Graphics2D g, boolean vertical, int bgwidth, int bgheight) {
        Rectangle fullBox;
        XPStyle xp = XPStyle.getXP();
        if (xp == null) {
            return;
        }
        Graphics2D gfx = (Graphics2D)g.create();
        TMSchema.Part part = vertical ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
        TMSchema.Part chunk = vertical ? TMSchema.Part.PP_CHUNKVERT : TMSchema.Part.PP_CHUNK;
        int gap = xp.getInt(this.progressBar, TMSchema.Part.PP_PROGRESS, null, TMSchema.Prop.PROGRESSSPACESIZE, 0);
        int deltax = 0;
        int deltay = 0;
        if (!vertical) {
            deltax = -box.width - gap;
            deltay = 0;
        } else {
            deltax = 0;
            deltay = -box.height - gap;
        }
        this.previousFullBox = fullBox = this.getFullChunkBounds(box);
        Insets ins = this.indeterminateInsets;
        Rectangle progbarExtents = new Rectangle(ins.left, ins.top, bgwidth - ins.left - ins.right, bgheight - ins.top - ins.bottom);
        Rectangle repaintArea = progbarExtents.intersection(fullBox);
        gfx.clip(repaintArea);
        XPStyle.Skin skin = xp.getSkin(this.progressBar, chunk);
        gfx.setComposite(AlphaComposite.getInstance(3, 0.8f));
        skin.paintSkin(gfx, box.x, box.y, box.width, box.height, null);
        box.translate(deltax, deltay);
        gfx.setComposite(AlphaComposite.getInstance(3, 0.5f));
        skin.paintSkin(gfx, box.x, box.y, box.width, box.height, null);
        box.translate(deltax, deltay);
        gfx.setComposite(AlphaComposite.getInstance(3, 0.2f));
        skin.paintSkin(gfx, box.x, box.y, box.width, box.height, null);
        gfx.dispose();
    }

    private void paintXPBackground(Graphics g, boolean vertical, int barRectWidth, int barRectHeight) {
        XPStyle xp = XPStyle.getXP();
        if (xp == null) {
            return;
        }
        TMSchema.Part part = vertical ? TMSchema.Part.PP_BARVERT : TMSchema.Part.PP_BAR;
        XPStyle.Skin skin = xp.getSkin(this.progressBar, part);
        skin.paintSkin(g, 0, 0, barRectWidth, barRectHeight, null);
    }
}

