/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import jdk.management.jfr.Stream;
import jdk.management.jfr.StreamCleanupTask;

final class StreamManager {
    public static final long TIME_OUT = TimeUnit.MINUTES.toMillis(2L);
    public static final int DEFAULT_BLOCK_SIZE = 50000;
    private static long idCounter = 0L;
    private final Map<Long, Stream> streams = new HashMap<Long, Stream>();
    private Timer timer;

    StreamManager() {
    }

    public synchronized Stream getStream(long streamIdentifer) {
        Stream stream = this.streams.get(streamIdentifer);
        if (stream == null) {
            throw new IllegalArgumentException("Unknown stream identifier " + streamIdentifer);
        }
        return stream;
    }

    public synchronized Stream create(InputStream is, int blockSize) {
        Stream stream = new Stream(is, ++idCounter, blockSize);
        this.streams.put(stream.getId(), stream);
        this.scheduleAbort(stream, System.currentTimeMillis() + TIME_OUT);
        return stream;
    }

    public synchronized void destroy(Stream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.streams.remove(stream.getId());
        if (this.streams.isEmpty()) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized void scheduleAbort(Stream s, long when) {
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        this.timer.schedule((TimerTask)new StreamCleanupTask(this, s), new Date(when + TIME_OUT));
    }
}

