/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

final class Stream
implements Closeable {
    private final long identifier;
    private final BufferedInputStream inputStream;
    private final byte[] buffer;
    private volatile long time;

    Stream(InputStream is, long identifier, int blockSize) {
        this.inputStream = new BufferedInputStream(is, 50000);
        this.identifier = identifier;
        this.buffer = new byte[blockSize];
    }

    private void touch() {
        this.time = System.currentTimeMillis();
    }

    public long getLastTouched() {
        return this.time;
    }

    public byte[] read() throws IOException {
        this.touch();
        int read = this.inputStream.read(this.buffer);
        if (read == -1) {
            return null;
        }
        if (read != this.buffer.length) {
            byte[] smallerBuffer = new byte[read];
            System.arraycopy(this.buffer, 0, smallerBuffer, 0, read);
            return smallerBuffer;
        }
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getId() {
        return this.identifier;
    }
}

