/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.jfc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.jfr.Configuration;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.jfc.JFCParser;

public final class JFC {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAXIMUM_FILE_SIZE = 0x100000;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static volatile List<KnownConfiguration> knownConfigurations;

    private JFC() {
    }

    public static Configuration create(String name, Reader reader) throws IOException, ParseException {
        return JFCParser.createConfiguration(name, reader);
    }

    private static String nullSafeFileName(Path file) throws IOException {
        Path filename = file.getFileName();
        if (filename == null) {
            throw new IOException("Path has no file name");
        }
        return filename.toString();
    }

    public static String nameFromPath(Path file) throws IOException {
        String f = JFC.nullSafeFileName(file);
        if (f.endsWith(".jfc")) {
            return f.substring(0, f.length() - ".jfc".length());
        }
        return f;
    }

    public static Configuration createKnown(String name) throws IOException, ParseException {
        for (KnownConfiguration knownConfiguration : JFC.getKnownConfigurations()) {
            if (!knownConfiguration.isNamed(name)) continue;
            return knownConfiguration.getConfigurationFile();
        }
        SecuritySupport.SafePath path = SecuritySupport.JFC_DIRECTORY;
        if (path != null && SecuritySupport.exists(path)) {
            for (String extension : Arrays.asList("", ".jfc")) {
                SecuritySupport.SafePath file = new SecuritySupport.SafePath(path.toPath().resolveSibling(name + extension));
                if (!SecuritySupport.exists(file) || SecuritySupport.isDirectory(file)) continue;
                try (Reader r = SecuritySupport.newFileReader(file);){
                    String jfcName = JFC.nameFromPath(file.toPath());
                    Configuration configuration = JFCParser.createConfiguration(jfcName, r);
                    return configuration;
                }
            }
        }
        Path path2 = Paths.get(name, new String[0]);
        String jfcName = JFC.nameFromPath(path2);
        try (BufferedReader r = Files.newBufferedReader(path2);){
            Configuration configuration = JFCParser.createConfiguration(jfcName, r);
            return configuration;
        }
    }

    private static String readContent(InputStream source) throws IOException {
        byte[] bytes = JFC.read(source, 8192);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] read(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 8192);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public static List<Configuration> getConfigurations() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        for (KnownConfiguration knownConfig : JFC.getKnownConfigurations()) {
            try {
                configs.add(knownConfig.getConfigurationFile());
            }
            catch (IOException e) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not load configuration " + knownConfig.getName() + ". " + e.getMessage());
            }
            catch (ParseException e) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not parse configuration " + knownConfig.getName() + ". " + e.getMessage());
            }
        }
        return configs;
    }

    private static List<KnownConfiguration> getKnownConfigurations() {
        if (knownConfigurations == null) {
            ArrayList<KnownConfiguration> configProxies = new ArrayList<KnownConfiguration>();
            for (SecuritySupport.SafePath p : SecuritySupport.getPredefinedJFCFiles()) {
                try {
                    configProxies.add(new KnownConfiguration(p));
                }
                catch (IOException iOException) {}
            }
            knownConfigurations = configProxies;
        }
        return knownConfigurations;
    }

    public static Configuration getPredefined(String name) throws IOException, ParseException {
        for (KnownConfiguration knownConfig : JFC.getKnownConfigurations()) {
            if (!knownConfig.getName().equals(name)) continue;
            return knownConfig.getConfigurationFile();
        }
        throw new NoSuchFileException("Could not locate configuration with name " + name);
    }

    private static final class KnownConfiguration {
        private final String content;
        private final String filename;
        private final String name;
        private Configuration configuration;

        public KnownConfiguration(SecuritySupport.SafePath knownPath) throws IOException {
            this.content = KnownConfiguration.readContent(knownPath);
            this.name = JFC.nameFromPath(knownPath.toPath());
            this.filename = JFC.nullSafeFileName(knownPath.toPath());
        }

        public boolean isNamed(String name) {
            return this.filename.equals(name) || this.name.equals(name);
        }

        public Configuration getConfigurationFile() throws IOException, ParseException {
            if (this.configuration == null) {
                this.configuration = JFCParser.createConfiguration(this.name, this.content);
            }
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        private static String readContent(SecuritySupport.SafePath knownPath) throws IOException {
            if (SecuritySupport.getFileSize(knownPath) > 0x100000L) {
                throw new IOException("Configuration with more than 1048576 characters can't be read.");
            }
            try (InputStream r = SecuritySupport.newFileInputStream(knownPath);){
                String string = JFC.readContent(r);
                return string;
            }
        }
    }
}

