/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import jdk.jfr.Timespan;
import jdk.jfr.Timestamp;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedClass;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedThread;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.tool.PrettyWriter;

public class RecordedObject {
    private final Object[] objects;
    private final List<ValueDescriptor> descriptors;
    private final TimeConverter timeConverter;

    RecordedObject(List<ValueDescriptor> descriptors, Object[] objects, TimeConverter timeConverter) {
        this.descriptors = descriptors;
        this.objects = objects;
        this.timeConverter = timeConverter;
    }

    final <T> T getTyped(String name, Class<T> clazz, T defaultValue) {
        if (!this.hasField(name)) {
            return defaultValue;
        }
        T object = this.getValue(name);
        if (object == null || object.getClass().isAssignableFrom(clazz)) {
            return object;
        }
        return defaultValue;
    }

    public boolean hasField(String name) {
        Objects.requireNonNull(name);
        for (ValueDescriptor v : this.descriptors) {
            if (!v.getName().equals(name)) continue;
            return true;
        }
        int dotIndex = name.indexOf(".");
        if (dotIndex > 0) {
            String structName = name.substring(0, dotIndex);
            for (ValueDescriptor v : this.descriptors) {
                RecordedObject child;
                if (v.getFields().isEmpty() || !v.getName().equals(structName) || (child = (RecordedObject)this.getValue(structName)) == null) continue;
                return child.hasField(name.substring(dotIndex + 1));
            }
        }
        return false;
    }

    public final <T> T getValue(String name) {
        Object t = this.getValue(name, false);
        return (T)t;
    }

    private Object getValue(String name, boolean allowUnsigned) {
        Objects.requireNonNull(name);
        int index = 0;
        for (ValueDescriptor v : this.descriptors) {
            if (name.equals(v.getName())) {
                Object object = this.objects[index];
                if (object == null) {
                    return null;
                }
                if (v.getFields().isEmpty()) {
                    if (allowUnsigned && PrivateAccess.getInstance().isUnsigned(v)) {
                        if (object instanceof Character || object instanceof Long) {
                            return object;
                        }
                        return new UnsignedValue(object);
                    }
                    return object;
                }
                if (object instanceof RecordedObject) {
                    return object;
                }
                Object[] array = (Object[])object;
                if (v.isArray()) {
                    return this.structifyArray(v, array, 0);
                }
                return new RecordedObject(v.getFields(), (Object[])object, this.timeConverter);
            }
            ++index;
        }
        int dotIndex = name.indexOf(".");
        if (dotIndex > 0) {
            String structName = name.substring(0, dotIndex);
            for (ValueDescriptor v : this.descriptors) {
                if (v.getFields().isEmpty() || !v.getName().equals(structName)) continue;
                RecordedObject child = (RecordedObject)this.getValue(structName);
                String subName = name.substring(dotIndex + 1);
                if (child != null) {
                    return child.getValue(subName, allowUnsigned);
                }
                this.getValueDescriptor(v.getFields(), subName, null);
                throw new NullPointerException("Field value for \"" + structName + "\" was null. Can't access nested field \"" + subName + "\"");
            }
        }
        throw new IllegalArgumentException("Could not find field with name " + name);
    }

    private ValueDescriptor getValueDescriptor(List<ValueDescriptor> descriptors, String name, String leafType) {
        int dotIndex = name.indexOf(".");
        if (dotIndex > 0) {
            String first = name.substring(0, dotIndex);
            String second = name.substring(dotIndex + 1);
            for (ValueDescriptor v : descriptors) {
                List<ValueDescriptor> fields;
                if (!v.getName().equals(first) || (fields = v.getFields()).isEmpty()) continue;
                return this.getValueDescriptor(v.getFields(), second, leafType);
            }
            throw new IllegalArgumentException("Attempt to get unknown field \"" + first + "\"");
        }
        for (ValueDescriptor v : descriptors) {
            if (!v.getName().equals(name)) continue;
            if (leafType != null && !v.getTypeName().equals(leafType)) {
                throw new IllegalArgumentException("Attempt to get " + v.getTypeName() + " field \"" + name + "\" with illegal data type conversion " + leafType);
            }
            return v;
        }
        throw new IllegalArgumentException("\"Attempt to get unknown field \"" + name + "\"");
    }

    private <T> T getTypedValue(String name, String typeName) {
        Objects.requireNonNull(name);
        this.getValueDescriptor(this.descriptors, name, typeName);
        return this.getValue(name);
    }

    private Object[] structifyArray(ValueDescriptor v, Object[] array, int dimension) {
        if (array == null) {
            return null;
        }
        Object[] structArray = new Object[array.length];
        for (int i = 0; i < structArray.length; ++i) {
            Object arrayElement = array[i];
            if (dimension == 0) {
                if (this.isStackFrameType(v.getTypeName())) {
                    structArray[i] = new RecordedFrame(v.getFields(), (Object[])arrayElement, this.timeConverter);
                    continue;
                }
                structArray[i] = new RecordedObject(v.getFields(), (Object[])arrayElement, this.timeConverter);
                continue;
            }
            structArray[i] = this.structifyArray(v, (Object[])arrayElement, dimension - 1);
        }
        return structArray;
    }

    private boolean isStackFrameType(String typeName) {
        if ("com.oracle.jfr.types.StackFrame".equals(typeName)) {
            return true;
        }
        return "jdk.types.StackFrame".equals(typeName);
    }

    public List<ValueDescriptor> getFields() {
        return this.descriptors;
    }

    public final boolean getBoolean(String name) {
        Object o = this.getValue(name);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw RecordedObject.newIllegalArgumentException(name, "boolean");
    }

    public final byte getByte(String name) {
        Object o = this.getValue(name);
        if (o instanceof Byte) {
            return (Byte)o;
        }
        throw RecordedObject.newIllegalArgumentException(name, "byte");
    }

    public final char getChar(String name) {
        Object o = this.getValue(name);
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(name, "char");
    }

    public final short getShort(String name) {
        Object o = this.getValue(name, true);
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof UnsignedValue) {
            Object u = ((UnsignedValue)o).value();
            if (u instanceof Short) {
                return (Short)u;
            }
            if (u instanceof Byte) {
                return (short)Byte.toUnsignedInt((Byte)u);
            }
        }
        throw RecordedObject.newIllegalArgumentException(name, "short");
    }

    public final int getInt(String name) {
        Object o = this.getValue(name, true);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Short) {
            return ((Short)o).intValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).intValue();
        }
        if (o instanceof UnsignedValue) {
            Object u = ((UnsignedValue)o).value();
            if (u instanceof Integer) {
                return (Integer)u;
            }
            if (u instanceof Short) {
                return Short.toUnsignedInt((Short)u);
            }
            if (u instanceof Byte) {
                return Byte.toUnsignedInt((Byte)u);
            }
        }
        throw RecordedObject.newIllegalArgumentException(name, "int");
    }

    public final float getFloat(String name) {
        Object o = this.getValue(name);
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return ((Long)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).floatValue();
        }
        if (o instanceof Short) {
            return ((Short)o).floatValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(name, "float");
    }

    public final long getLong(String name) {
        Object o = this.getValue(name, true);
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Short) {
            return ((Short)o).longValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).longValue();
        }
        if (o instanceof UnsignedValue) {
            Object u = ((UnsignedValue)o).value();
            if (u instanceof Integer) {
                return Integer.toUnsignedLong((Integer)u);
            }
            if (u instanceof Short) {
                return Short.toUnsignedLong((Short)u);
            }
            if (u instanceof Byte) {
                return Byte.toUnsignedLong((Byte)u);
            }
        }
        throw RecordedObject.newIllegalArgumentException(name, "long");
    }

    public final double getDouble(String name) {
        Object o = this.getValue(name);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Long) {
            return ((Long)o).doubleValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        throw RecordedObject.newIllegalArgumentException(name, "double");
    }

    public final String getString(String name) {
        return (String)this.getTypedValue(name, "java.lang.String");
    }

    public final Duration getDuration(String name) {
        Object o = this.getValue(name);
        if (o instanceof Long) {
            return this.getDuration((Long)o, name);
        }
        if (o instanceof Integer) {
            return this.getDuration(((Integer)o).longValue(), name);
        }
        if (o instanceof Short) {
            return this.getDuration(((Short)o).longValue(), name);
        }
        if (o instanceof Character) {
            return this.getDuration(((Character)o).charValue(), name);
        }
        if (o instanceof Byte) {
            return this.getDuration(((Byte)o).longValue(), name);
        }
        if (o instanceof UnsignedValue) {
            Object u = ((UnsignedValue)o).value();
            if (u instanceof Integer) {
                return this.getDuration(Integer.toUnsignedLong((Integer)u), name);
            }
            if (u instanceof Short) {
                return this.getDuration(Short.toUnsignedLong((Short)u), name);
            }
            if (u instanceof Byte) {
                return this.getDuration(Short.toUnsignedLong(((Byte)u).byteValue()), name);
            }
        }
        throw RecordedObject.newIllegalArgumentException(name, "java,time.Duration");
    }

    private Duration getDuration(long timespan, String name) throws InternalError {
        ValueDescriptor v = this.getValueDescriptor(this.descriptors, name, null);
        if (timespan == Long.MIN_VALUE) {
            return Duration.ofSeconds(Long.MIN_VALUE, 0L);
        }
        Timespan ts = v.getAnnotation(Timespan.class);
        if (ts != null) {
            switch (ts.value()) {
                case "MICROSECONDS": {
                    return Duration.ofNanos(1000L * timespan);
                }
                case "SECONDS": {
                    return Duration.ofSeconds(timespan);
                }
                case "MILLISECONDS": {
                    return Duration.ofMillis(timespan);
                }
                case "NANOSECONDS": {
                    return Duration.ofNanos(timespan);
                }
                case "TICKS": {
                    return Duration.ofNanos(this.timeConverter.convertTimespan(timespan));
                }
            }
            throw new IllegalArgumentException("Attempt to get " + v.getTypeName() + " field \"" + name + "\" with illegal timespan unit " + ts.value());
        }
        throw new IllegalArgumentException("Attempt to get " + v.getTypeName() + " field \"" + name + "\" with missing @Timespan");
    }

    public final Instant getInstant(String name) {
        Object o = this.getValue(name, true);
        if (o instanceof Long) {
            return this.getInstant((Long)o, name);
        }
        if (o instanceof Integer) {
            return this.getInstant(((Integer)o).longValue(), name);
        }
        if (o instanceof Short) {
            return this.getInstant(((Short)o).longValue(), name);
        }
        if (o instanceof Character) {
            return this.getInstant(((Character)o).charValue(), name);
        }
        if (o instanceof Byte) {
            return this.getInstant(((Byte)o).longValue(), name);
        }
        if (o instanceof UnsignedValue) {
            Object u = ((UnsignedValue)o).value();
            if (u instanceof Integer) {
                return this.getInstant(Integer.toUnsignedLong((Integer)u), name);
            }
            if (u instanceof Short) {
                return this.getInstant(Short.toUnsignedLong((Short)u), name);
            }
            if (u instanceof Byte) {
                return this.getInstant(Short.toUnsignedLong(((Byte)u).byteValue()), name);
            }
        }
        throw RecordedObject.newIllegalArgumentException(name, "java.time.Instant");
    }

    private Instant getInstant(long timestamp, String name) {
        ValueDescriptor v = this.getValueDescriptor(this.descriptors, name, null);
        Timestamp ts = v.getAnnotation(Timestamp.class);
        if (ts != null) {
            if (timestamp == Long.MIN_VALUE) {
                return Instant.MIN;
            }
            switch (ts.value()) {
                case "MILLISECONDS_SINCE_EPOCH": {
                    return Instant.ofEpochMilli(timestamp);
                }
                case "TICKS": {
                    return Instant.ofEpochSecond(0L, this.timeConverter.convertTimestamp(timestamp));
                }
            }
            throw new IllegalArgumentException("Attempt to get " + v.getTypeName() + " field \"" + name + "\" with illegal timestamp unit " + ts.value());
        }
        throw new IllegalArgumentException("Attempt to get " + v.getTypeName() + " field \"" + name + "\" with missing @Timestamp");
    }

    public final RecordedClass getClass(String name) {
        return (RecordedClass)this.getTypedValue(name, "java.lang.Class");
    }

    public final RecordedThread getThread(String name) {
        return (RecordedThread)this.getTypedValue(name, "java.lang.Thread");
    }

    public final String toString() {
        StringWriter s = new StringWriter();
        PrettyWriter p = new PrettyWriter(new PrintWriter(s));
        p.setStackDepth(5);
        if (this instanceof RecordedEvent) {
            p.print((RecordedEvent)this);
        } else {
            p.print(this, "");
        }
        p.flush(true);
        return s.toString();
    }

    OffsetDateTime getOffsetDateTime(String name) {
        Instant instant = this.getInstant(name);
        if (instant.equals(Instant.MIN)) {
            return OffsetDateTime.MIN;
        }
        return OffsetDateTime.ofInstant(this.getInstant(name), this.timeConverter.getZoneOffset());
    }

    private static IllegalArgumentException newIllegalArgumentException(String name, String typeName) {
        return new IllegalArgumentException("Attempt to get field \"" + name + "\" with illegal data type conversion " + typeName);
    }

    private static final class UnsignedValue {
        private final Object o;

        UnsignedValue(Object o) {
            this.o = o;
        }

        Object value() {
            return this.o;
        }
    }
}

