/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import jdk.internal.misc.TerminatingThreadLocal;
import sun.misc.Unsafe;
import sun.nio.fs.NativeBuffer;

class NativeBuffers {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal<NativeBuffer[]> threadLocal = new TerminatingThreadLocal<NativeBuffer[]>(){

        @Override
        protected void threadTerminated(NativeBuffer[] buffers) {
            if (buffers != null) {
                for (int i = 0; i < 3; ++i) {
                    NativeBuffer buffer = buffers[i];
                    if (buffer == null) continue;
                    buffer.cleaner().clean();
                    buffers[i] = null;
                }
            }
        }
    };

    private NativeBuffers() {
    }

    static NativeBuffer allocNativeBuffer(int size) {
        if (size < 2048) {
            size = 2048;
        }
        return new NativeBuffer(size);
    }

    static NativeBuffer getNativeBufferFromCache(int size) {
        NativeBuffer[] buffers = threadLocal.get();
        if (buffers != null) {
            for (int i = 0; i < 3; ++i) {
                NativeBuffer buffer = buffers[i];
                if (buffer == null || buffer.size() < size) continue;
                buffers[i] = null;
                return buffer;
            }
        }
        return null;
    }

    static NativeBuffer getNativeBuffer(int size) {
        NativeBuffer buffer = NativeBuffers.getNativeBufferFromCache(size);
        if (buffer != null) {
            buffer.setOwner(null);
            return buffer;
        }
        return NativeBuffers.allocNativeBuffer(size);
    }

    static void releaseNativeBuffer(NativeBuffer buffer) {
        int i;
        NativeBuffer[] buffers = threadLocal.get();
        if (buffers == null) {
            buffers = new NativeBuffer[3];
            buffers[0] = buffer;
            threadLocal.set(buffers);
            return;
        }
        for (i = 0; i < 3; ++i) {
            if (buffers[i] != null) continue;
            buffers[i] = buffer;
            return;
        }
        for (i = 0; i < 3; ++i) {
            NativeBuffer existing = buffers[i];
            if (existing.size() >= buffer.size()) continue;
            existing.cleaner().clean();
            buffers[i] = buffer;
            return;
        }
        buffer.cleaner().clean();
    }

    static void copyCStringToNativeBuffer(byte[] cstr, NativeBuffer buffer) {
        long offset = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        long len = cstr.length;
        assert ((long)buffer.size() >= len + 1L);
        unsafe.copyMemory(cstr, offset, null, buffer.address(), len);
        unsafe.putByte(buffer.address() + len, (byte)0);
    }

    static NativeBuffer asNativeBuffer(byte[] cstr) {
        NativeBuffer buffer = NativeBuffers.getNativeBuffer(cstr.length + 1);
        NativeBuffers.copyCStringToNativeBuffer(cstr, buffer);
        return buffer;
    }
}

