/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.Helpers;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.RendererContext;

final class Dasher
implements PathConsumer2D,
MarlinConst {
    static final int recLimit = 4;
    static final float ERR = 0.01f;
    static final float minTincrement = 0.0625f;
    private PathConsumer2D out;
    private float[] dash;
    private int dashLen;
    private float startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private float phase;
    private float sx;
    private float sy;
    private float x0;
    private float y0;
    private final float[] curCurvepts;
    final RendererContext rdrCtx;
    final float[] dashes_initial = new float[256];
    boolean recycleDashes;
    private final float[] firstSegmentsBuffer_initial = new float[257];
    private float[] firstSegmentsBuffer;
    private int firstSegidx;
    private final LengthIterator li = new LengthIterator();

    Dasher(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_initial;
        this.curCurvepts = new float[16];
    }

    Dasher init(PathConsumer2D out, float[] dash, int dashLen, float phase, boolean recycleDashes) {
        if (phase < 0.0f) {
            throw new IllegalArgumentException("phase < 0 !");
        }
        this.out = out;
        int idx = 0;
        this.dashOn = true;
        while (true) {
            float f;
            float d = dash[idx];
            if (!(phase >= f)) break;
            phase -= d;
            idx = (idx + 1) % dashLen;
            this.dashOn = !this.dashOn;
        }
        this.dash = dash;
        this.dashLen = dashLen;
        this.startPhase = this.phase = phase;
        this.startDashOn = this.dashOn;
        this.startIdx = idx;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = recycleDashes;
        return this;
    }

    void dispose() {
        if (this.recycleDashes && this.dash != this.dashes_initial) {
            this.rdrCtx.putDirtyFloatArray(this.dash);
            this.dash = null;
        }
        if (this.firstSegmentsBuffer != this.firstSegmentsBuffer_initial) {
            this.rdrCtx.putDirtyFloatArray(this.firstSegmentsBuffer);
            this.firstSegmentsBuffer = this.firstSegmentsBuffer_initial;
        }
    }

    @Override
    public void moveTo(float x0, float y0) {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.sx = this.x0 = x0;
        this.sy = this.y0 = y0;
        this.starting = true;
    }

    private void emitSeg(float[] buf, int off, int type) {
        switch (type) {
            case 8: {
                this.out.curveTo(buf[off + 0], buf[off + 1], buf[off + 2], buf[off + 3], buf[off + 4], buf[off + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(buf[off + 0], buf[off + 1], buf[off + 2], buf[off + 3]);
                return;
            }
            case 4: {
                this.out.lineTo(buf[off], buf[off + 1]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int type;
        float[] fSegBuf = this.firstSegmentsBuffer;
        for (int i = 0; i < this.firstSegidx; i += type - 1) {
            type = (int)fSegBuf[i];
            this.emitSeg(fSegBuf, i + 1, type);
        }
        this.firstSegidx = 0;
    }

    private void goTo(float[] pts, int off, int type) {
        float x = pts[off + type - 4];
        float y = pts[off + type - 3];
        if (this.dashOn) {
            if (this.starting) {
                int segIdx = this.firstSegidx;
                int len = type - 2 + 1;
                float[] buf = this.firstSegmentsBuffer;
                if (segIdx + len > buf.length) {
                    if (doStats) {
                        RendererContext.stats.stat_array_dasher_firstSegmentsBuffer.add(segIdx + len);
                    }
                    this.firstSegmentsBuffer = buf = this.rdrCtx.widenDirtyFloatArray(buf, segIdx, segIdx + len);
                }
                buf[segIdx++] = type;
                System.arraycopy(pts, off, buf, segIdx, --len);
                this.firstSegidx = segIdx += len;
            } else {
                if (this.needsMoveTo) {
                    this.out.moveTo(this.x0, this.y0);
                    this.needsMoveTo = false;
                }
                this.emitSeg(pts, off, type);
            }
        } else {
            this.starting = false;
            this.needsMoveTo = true;
        }
        this.x0 = x;
        this.y0 = y;
    }

    @Override
    public void lineTo(float x1, float y1) {
        float dx = x1 - this.x0;
        float dy = y1 - this.y0;
        float len = dx * dx + dy * dy;
        if (len == 0.0f) {
            return;
        }
        len = (float)Math.sqrt(len);
        float cx = dx / len;
        float cy = dy / len;
        float[] _curCurvepts = this.curCurvepts;
        float[] _dash = this.dash;
        while (true) {
            float leftInThisDashSegment;
            if (len <= (leftInThisDashSegment = _dash[this.idx] - this.phase)) {
                _curCurvepts[0] = x1;
                _curCurvepts[1] = y1;
                this.goTo(_curCurvepts, 0, 4);
                this.phase += len;
                if (len == leftInThisDashSegment) {
                    this.phase = 0.0f;
                    this.idx = (this.idx + 1) % this.dashLen;
                    this.dashOn = !this.dashOn;
                }
                return;
            }
            float dashdx = _dash[this.idx] * cx;
            float dashdy = _dash[this.idx] * cy;
            if (this.phase == 0.0f) {
                _curCurvepts[0] = this.x0 + dashdx;
                _curCurvepts[1] = this.y0 + dashdy;
            } else {
                float p = leftInThisDashSegment / _dash[this.idx];
                _curCurvepts[0] = this.x0 + p * dashdx;
                _curCurvepts[1] = this.y0 + p * dashdy;
            }
            this.goTo(_curCurvepts, 0, 4);
            len -= leftInThisDashSegment;
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
        }
    }

    private void somethingTo(int type) {
        if (Dasher.pointCurve(this.curCurvepts, type)) {
            return;
        }
        this.li.initializeIterationOnCurve(this.curCurvepts, type);
        int curCurveoff = 0;
        float lastSplitT = 0.0f;
        float leftInThisDashSegment = this.dash[this.idx] - this.phase;
        while (true) {
            float f;
            float t = this.li.next(leftInThisDashSegment);
            if (!(f < 1.0f)) break;
            if (t != 0.0f) {
                Helpers.subdivideAt((t - lastSplitT) / (1.0f - lastSplitT), this.curCurvepts, curCurveoff, this.curCurvepts, 0, this.curCurvepts, type, type);
                lastSplitT = t;
                this.goTo(this.curCurvepts, 2, type);
                curCurveoff = type;
            }
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
            this.phase = 0.0f;
            leftInThisDashSegment = this.dash[this.idx];
        }
        this.goTo(this.curCurvepts, curCurveoff + 2, type);
        this.phase += this.li.lastSegLen();
        if (this.phase >= this.dash[this.idx]) {
            this.phase = 0.0f;
            this.idx = (this.idx + 1) % this.dashLen;
            this.dashOn = !this.dashOn;
        }
        this.li.reset();
    }

    private static boolean pointCurve(float[] curve, int type) {
        for (int i = 2; i < type; ++i) {
            if (curve[i] == curve[i - 2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float[] _curCurvepts = this.curCurvepts;
        _curCurvepts[0] = this.x0;
        _curCurvepts[1] = this.y0;
        _curCurvepts[2] = x1;
        _curCurvepts[3] = y1;
        _curCurvepts[4] = x2;
        _curCurvepts[5] = y2;
        _curCurvepts[6] = x3;
        _curCurvepts[7] = y3;
        this.somethingTo(8);
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        float[] _curCurvepts = this.curCurvepts;
        _curCurvepts[0] = this.x0;
        _curCurvepts[1] = this.y0;
        _curCurvepts[2] = x1;
        _curCurvepts[3] = y1;
        _curCurvepts[4] = x2;
        _curCurvepts[5] = y2;
        this.somethingTo(6);
    }

    @Override
    public void closePath() {
        this.lineTo(this.sx, this.sy);
        if (this.firstSegidx > 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx, this.sy);
            }
            this.emitFirstSegments();
        }
        this.moveTo(this.sx, this.sy);
    }

    @Override
    public void pathDone() {
        if (this.firstSegidx > 0) {
            this.out.moveTo(this.sx, this.sy);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Dasher does not use a native consumer");
    }

    static final class LengthIterator {
        private final float[][] recCurveStack;
        private final Side[] sides;
        private int curveType;
        private float nextT;
        private float lenAtNextT;
        private float lastT;
        private float lenAtLastT;
        private float lenAtLastSplit;
        private float lastSegLen;
        private int recLevel;
        private boolean done = true;
        private final float[] curLeafCtrlPolyLengths = new float[3];
        private int cachedHaveLowAcceleration = -1;
        private final float[] nextRoots = new float[4];
        private final float[] flatLeafCoefCache = new float[]{0.0f, 0.0f, -1.0f, 0.0f};

        LengthIterator() {
            this.recCurveStack = new float[5][8];
            this.sides = new Side[4];
            this.nextT = Float.MAX_VALUE;
            this.lenAtNextT = Float.MAX_VALUE;
            this.lenAtLastSplit = Float.MIN_VALUE;
            this.recLevel = Integer.MIN_VALUE;
            this.lastSegLen = Float.MAX_VALUE;
        }

        void reset() {
        }

        void initializeIterationOnCurve(float[] pts, int type) {
            System.arraycopy(pts, 0, this.recCurveStack[0], 0, 8);
            this.curveType = type;
            this.recLevel = 0;
            this.lastT = 0.0f;
            this.lenAtLastT = 0.0f;
            this.nextT = 0.0f;
            this.lenAtNextT = 0.0f;
            this.goLeft();
            this.lenAtLastSplit = 0.0f;
            if (this.recLevel > 0) {
                this.sides[0] = Side.LEFT;
                this.done = false;
            } else {
                this.sides[0] = Side.RIGHT;
                this.done = true;
            }
            this.lastSegLen = 0.0f;
        }

        private boolean haveLowAcceleration(float err) {
            if (this.cachedHaveLowAcceleration == -1) {
                float errLen3;
                float len3;
                float len1 = this.curLeafCtrlPolyLengths[0];
                float len2 = this.curLeafCtrlPolyLengths[1];
                if (!Helpers.within(len1, len2, err * len2)) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                if (!(this.curveType != 8 || Helpers.within(len2, len3 = this.curLeafCtrlPolyLengths[2], errLen3 = err * len3) && Helpers.within(len1, len3, errLen3))) {
                    this.cachedHaveLowAcceleration = 0;
                    return false;
                }
                this.cachedHaveLowAcceleration = 1;
                return true;
            }
            return this.cachedHaveLowAcceleration == 1;
        }

        float next(float len) {
            float targetLength = this.lenAtLastSplit + len;
            while (this.lenAtNextT < targetLength) {
                if (this.done) {
                    this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                    return 1.0f;
                }
                this.goToNextLeaf();
            }
            this.lenAtLastSplit = targetLength;
            float leaflen = this.lenAtNextT - this.lenAtLastT;
            float t = (targetLength - this.lenAtLastT) / leaflen;
            if (!this.haveLowAcceleration(0.05f)) {
                float d;
                float c;
                float b;
                float a;
                int n;
                float[] _flatLeafCoefCache = this.flatLeafCoefCache;
                if (_flatLeafCoefCache[2] < 0.0f) {
                    float x = 0.0f + this.curLeafCtrlPolyLengths[0];
                    float y = x + this.curLeafCtrlPolyLengths[1];
                    if (this.curveType == 8) {
                        float z = y + this.curLeafCtrlPolyLengths[2];
                        _flatLeafCoefCache[0] = 3.0f * (x - y) + z;
                        _flatLeafCoefCache[1] = 3.0f * (y - 2.0f * x);
                        _flatLeafCoefCache[2] = 3.0f * x;
                        _flatLeafCoefCache[3] = -z;
                    } else if (this.curveType == 6) {
                        _flatLeafCoefCache[0] = 0.0f;
                        _flatLeafCoefCache[1] = y - 2.0f * x;
                        _flatLeafCoefCache[2] = 2.0f * x;
                        _flatLeafCoefCache[3] = -y;
                    }
                }
                if ((n = Helpers.cubicRootsInAB(a = _flatLeafCoefCache[0], b = _flatLeafCoefCache[1], c = _flatLeafCoefCache[2], d = t * _flatLeafCoefCache[3], this.nextRoots, 0, 0.0f, 1.0f)) == 1 && !Float.isNaN(this.nextRoots[0])) {
                    t = this.nextRoots[0];
                }
            }
            if ((t = t * (this.nextT - this.lastT) + this.lastT) >= 1.0f) {
                t = 1.0f;
                this.done = true;
            }
            this.lastSegLen = len;
            return t;
        }

        float lastSegLen() {
            return this.lastSegLen;
        }

        private void goToNextLeaf() {
            int _recLevel = this.recLevel;
            Side[] _sides = this.sides;
            --_recLevel;
            while (_sides[_recLevel] == Side.RIGHT) {
                if (_recLevel == 0) {
                    this.recLevel = 0;
                    this.done = true;
                    return;
                }
                --_recLevel;
            }
            _sides[_recLevel] = Side.RIGHT;
            System.arraycopy(this.recCurveStack[_recLevel], 0, this.recCurveStack[_recLevel + 1], 0, 8);
            this.recLevel = ++_recLevel;
            this.goLeft();
        }

        private void goLeft() {
            float len = this.onLeaf();
            if (len >= 0.0f) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (float)(1 << 4 - this.recLevel) * 0.0625f;
                this.lenAtNextT += len;
                this.flatLeafCoefCache[2] = -1.0f;
                this.cachedHaveLowAcceleration = -1;
            } else {
                Helpers.subdivide(this.recCurveStack[this.recLevel], 0, this.recCurveStack[this.recLevel + 1], 0, this.recCurveStack[this.recLevel], 0, this.curveType);
                this.sides[this.recLevel] = Side.LEFT;
                ++this.recLevel;
                this.goLeft();
            }
        }

        private float onLeaf() {
            float[] curve = this.recCurveStack[this.recLevel];
            float polyLen = 0.0f;
            float x0 = curve[0];
            float y0 = curve[1];
            for (int i = 2; i < this.curveType; i += 2) {
                float x1 = curve[i];
                float y1 = curve[i + 1];
                float len = Helpers.linelen(x0, y0, x1, y1);
                polyLen += len;
                this.curLeafCtrlPolyLengths[i / 2 - 1] = len;
                x0 = x1;
                y0 = y1;
            }
            float lineLen = Helpers.linelen(curve[0], curve[1], curve[this.curveType - 2], curve[this.curveType - 1]);
            if (polyLen - lineLen < 0.01f || this.recLevel == 4) {
                return (polyLen + lineLen) / 2.0f;
            }
            return -1.0f;
        }

        private static enum Side {
            LEFT,
            RIGHT;

        }
    }
}

