/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import sun.awt.image.AbstractMultiResolutionImage;

public class BaseMultiResolutionImage
extends AbstractMultiResolutionImage {
    private final int baseImageIndex;
    private final Image[] resolutionVariants;

    public BaseMultiResolutionImage(Image ... resolutionVariants) {
        this(0, resolutionVariants);
    }

    public BaseMultiResolutionImage(int baseImageIndex, Image ... resolutionVariants) {
        if (resolutionVariants == null || resolutionVariants.length == 0) {
            throw new IllegalArgumentException("Null or zero-length array is passed");
        }
        if (baseImageIndex < 0 || baseImageIndex >= resolutionVariants.length) {
            throw new IndexOutOfBoundsException("Invalid base image index: " + baseImageIndex);
        }
        this.baseImageIndex = baseImageIndex;
        for (Image resolutionVariant : this.resolutionVariants = Arrays.copyOf(resolutionVariants, resolutionVariants.length)) {
            Objects.requireNonNull(resolutionVariant, "Resolution variant can't be null");
        }
    }

    @Override
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        BaseMultiResolutionImage.checkSize(destImageWidth, destImageHeight);
        for (Image rvImage : this.resolutionVariants) {
            if (!(destImageWidth <= (double)rvImage.getWidth(null)) || !(destImageHeight <= (double)rvImage.getHeight(null))) continue;
            return rvImage;
        }
        return this.resolutionVariants[this.resolutionVariants.length - 1];
    }

    private static void checkSize(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) cannot be <= 0", width, height));
        }
        if (!Double.isFinite(width) || !Double.isFinite(height)) {
            throw new IllegalArgumentException(String.format("Width (%s) or height (%s) is not finite", width, height));
        }
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Collections.unmodifiableList(Arrays.asList(this.resolutionVariants));
    }

    @Override
    protected Image getBaseImage() {
        return this.resolutionVariants[this.baseImageIndex];
    }
}

