/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import sun.awt.SunToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.util.logging.PlatformLogger;

public class XEmbedClientHelper
extends XEmbedHelper
implements XEventDispatcher {
    private static final PlatformLogger xembedLog = PlatformLogger.getLogger("sun.awt.X11.xembed.XEmbedClientHelper");
    private XEmbeddedFramePeer embedded;
    private long server;
    private boolean active;
    private boolean applicationActive;

    XEmbedClientHelper() {
    }

    void setClient(XEmbeddedFramePeer client) {
        if (xembedLog.isLoggable(PlatformLogger.Level.FINE)) {
            xembedLog.fine("XEmbed client: " + client);
        }
        if (this.embedded != null) {
            XToolkit.removeEventDispatcher(this.embedded.getWindow(), this);
            this.active = false;
        }
        this.embedded = client;
        if (this.embedded != null) {
            XToolkit.addEventDispatcher(this.embedded.getWindow(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install() {
        if (xembedLog.isLoggable(PlatformLogger.Level.FINE)) {
            xembedLog.fine("Installing xembedder on " + this.embedded);
        }
        long[] info = new long[]{0L, 1L};
        long data = Native.card32ToData(info);
        try {
            XEmbedInfo.setAtomData(this.embedded.getWindow(), data, 2);
        }
        finally {
            unsafe.freeMemory(data);
        }
        long parentWindow = this.embedded.getParentWindowHandle();
        if (parentWindow != 0L) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.embedded.getWindow(), parentWindow, 0, 0);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    void handleClientMessage(XEvent xev) {
        XClientMessageEvent msg = xev.get_xclient();
        if (xembedLog.isLoggable(PlatformLogger.Level.FINE)) {
            xembedLog.fine(msg.toString());
        }
        if (msg.get_message_type() == XEmbed.getAtom()) {
            if (xembedLog.isLoggable(PlatformLogger.Level.FINE)) {
                xembedLog.fine("Embedded message: " + XEmbedClientHelper.msgidToString((int)msg.get_data(1)));
            }
            switch ((int)msg.get_data(1)) {
                case 0: {
                    this.active = true;
                    this.server = this.getEmbedder(this.embedded, msg);
                    if (!this.embedded.isReparented()) {
                        this.embedded.setReparented(true);
                        this.embedded.updateSizeHints();
                    }
                    this.embedded.notifyStarted();
                    break;
                }
                case 1: {
                    this.applicationActive = true;
                    break;
                }
                case 2: {
                    if (!this.applicationActive) break;
                    this.applicationActive = false;
                    this.handleWindowFocusOut();
                    break;
                }
                case 4: {
                    this.handleFocusIn((int)msg.get_data(2));
                    break;
                }
                case 5: {
                    if (!this.applicationActive) break;
                    this.handleWindowFocusOut();
                }
            }
        }
    }

    void handleFocusIn(int detail) {
        if (this.embedded.focusAllowedFor()) {
            this.embedded.handleWindowFocusIn(0L);
        }
        switch (detail) {
            case 0: {
                break;
            }
            case 1: {
                SunToolkit.executeOnEventHandlerThread(this.embedded.target, new Runnable(){

                    @Override
                    public void run() {
                        Component comp = ((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target).getFocusTraversalPolicy().getFirstComponent((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target);
                        if (comp != null) {
                            comp.requestFocusInWindow();
                        }
                    }
                });
                break;
            }
            case 2: {
                SunToolkit.executeOnEventHandlerThread(this.embedded.target, new Runnable(){

                    @Override
                    public void run() {
                        Component comp = ((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target).getFocusTraversalPolicy().getLastComponent((Container)((XEmbedClientHelper)XEmbedClientHelper.this).embedded.target);
                        if (comp != null) {
                            comp.requestFocusInWindow();
                        }
                    }
                });
            }
        }
    }

    @Override
    public void dispatchEvent(XEvent xev) {
        switch (xev.get_type()) {
            case 33: {
                this.handleClientMessage(xev);
                break;
            }
            case 21: {
                this.handleReparentNotify(xev);
            }
        }
    }

    public void handleReparentNotify(XEvent xev) {
        XReparentEvent re = xev.get_xreparent();
        long newParent = re.get_parent();
        if (this.active) {
            this.embedded.notifyStopped();
            X11GraphicsConfig gc = (X11GraphicsConfig)this.embedded.getGraphicsConfiguration();
            X11GraphicsDevice gd = gc.getDevice();
            if (newParent == XlibUtil.getRootWindow(gd.getScreen()) || newParent == XToolkit.getDefaultRootWindow()) {
                this.active = false;
            } else {
                this.server = newParent;
                this.embedded.notifyStarted();
            }
        }
    }

    boolean requestFocus() {
        if (this.active && this.embedded.focusAllowedFor()) {
            this.sendMessage(this.server, 3);
            return true;
        }
        return false;
    }

    void handleWindowFocusOut() {
        if (XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == this.embedded.target) {
            this.embedded.handleWindowFocusOut(null, 0L);
        }
    }

    long getEmbedder(XWindowPeer embedded, XClientMessageEvent info) {
        return XlibUtil.getParentWindow(embedded.getWindow());
    }

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    boolean isActive() {
        return this.active;
    }

    void traverseOutForward() {
        if (this.active) {
            this.sendMessage(this.server, 6);
        }
    }

    void traverseOutBackward() {
        if (this.active) {
            this.sendMessage(this.server, 7);
        }
    }

    void registerAccelerator(AWTKeyStroke stroke, int id) {
        if (this.active) {
            long sym2 = this.getX11KeySym(stroke);
            long mods = this.getX11Mods(stroke);
            this.sendMessage(this.server, 12, id, sym2, mods);
        }
    }

    void unregisterAccelerator(int id) {
        if (this.active) {
            this.sendMessage(this.server, 13, id, 0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getX11KeySym(AWTKeyStroke stroke) {
        XToolkit.awtLock();
        try {
            long l = XWindow.getKeySymForAWTKeyCode(stroke.getKeyCode());
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    long getX11Mods(AWTKeyStroke stroke) {
        return XWindow.getXModifiers(stroke);
    }
}

