/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class SourceVersion
extends Enum<SourceVersion> {
    public static final /* enum */ SourceVersion RELEASE_0;
    public static final /* enum */ SourceVersion RELEASE_1;
    public static final /* enum */ SourceVersion RELEASE_2;
    public static final /* enum */ SourceVersion RELEASE_3;
    public static final /* enum */ SourceVersion RELEASE_4;
    public static final /* enum */ SourceVersion RELEASE_5;
    public static final /* enum */ SourceVersion RELEASE_6;
    public static final /* enum */ SourceVersion RELEASE_7;
    public static final /* enum */ SourceVersion RELEASE_8;
    private static final SourceVersion latestSupported;
    private static final Set<String> keywords;
    private static final /* synthetic */ SourceVersion[] $VALUES;

    public static SourceVersion[] values() {
        return (SourceVersion[])$VALUES.clone();
    }

    public static SourceVersion valueOf(String name) {
        return Enum.valueOf(SourceVersion.class, name);
    }

    public static SourceVersion latest() {
        return RELEASE_8;
    }

    private static SourceVersion getLatestSupported() {
        try {
            String specVersion;
            switch (specVersion = System.getProperty("java.specification.version")) {
                case "1.8": {
                    return RELEASE_8;
                }
                case "1.7": {
                    return RELEASE_7;
                }
                case "1.6": {
                    return RELEASE_6;
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return RELEASE_5;
    }

    public static SourceVersion latestSupported() {
        return latestSupported;
    }

    public static boolean isIdentifier(CharSequence name) {
        String id = name.toString();
        if (id.length() == 0) {
            return false;
        }
        int cp = id.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < id.length(); i += Character.charCount(cp)) {
            cp = id.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    public static boolean isName(CharSequence name) {
        String id = name.toString();
        for (String s : id.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s) && !SourceVersion.isKeyword(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isKeyword(CharSequence s) {
        String keywordOrLiteral = s.toString();
        return keywords.contains(keywordOrLiteral);
    }

    static {
        String[] kws;
        RELEASE_0 = new SourceVersion();
        RELEASE_1 = new SourceVersion();
        RELEASE_2 = new SourceVersion();
        RELEASE_3 = new SourceVersion();
        RELEASE_4 = new SourceVersion();
        RELEASE_5 = new SourceVersion();
        RELEASE_6 = new SourceVersion();
        RELEASE_7 = new SourceVersion();
        RELEASE_8 = new SourceVersion();
        $VALUES = new SourceVersion[]{RELEASE_0, RELEASE_1, RELEASE_2, RELEASE_3, RELEASE_4, RELEASE_5, RELEASE_6, RELEASE_7, RELEASE_8};
        latestSupported = SourceVersion.getLatestSupported();
        HashSet<String> s = new HashSet<String>();
        for (String kw : kws = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null", "true", "false"}) {
            s.add(kw);
        }
        keywords = Collections.unmodifiableSet(s);
    }
}

