/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    private StrictMath() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static strictfp double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static strictfp double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double sqrt(double var0);

    public static native double cbrt(double var0);

    public static native double IEEEremainder(double var0, double var2);

    public static double ceil(double a) {
        return StrictMath.floorOrCeil(a, -0.0, 1.0, 1.0);
    }

    public static double floor(double a) {
        return StrictMath.floorOrCeil(a, -1.0, 0.0, -1.0);
    }

    private static double floorOrCeil(double a, double negativeBoundary, double positiveBoundary, double sign) {
        int exponent = Math.getExponent(a);
        if (exponent < 0) {
            return a == 0.0 ? a : (a < 0.0 ? negativeBoundary : positiveBoundary);
        }
        if (exponent >= 52) {
            return a;
        }
        assert (exponent >= 0 && exponent <= 51);
        long mask = 0xFFFFFFFFFFFFFL >> exponent;
        long doppel = Double.doubleToRawLongBits(a);
        if ((mask & doppel) == 0L) {
            return a;
        }
        double result = Double.longBitsToDouble(doppel & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        if (sign * a > 0.0) {
            result += sign;
        }
        return result;
    }

    public static double rint(double a) {
        double twoToThe52 = 4.503599627370496E15;
        double sign = Math.copySign(1.0, a);
        if ((a = Math.abs(a)) < twoToThe52) {
            a = twoToThe52 + a - twoToThe52;
        }
        return sign * a;
    }

    public static native double atan2(double var0, double var2);

    public static native double pow(double var0, double var2);

    public static int round(float a) {
        return Math.round(a);
    }

    public static long round(double a) {
        return Math.round(a);
    }

    public static double random() {
        return RandomNumberGeneratorHolder.randomNumberGenerator.nextDouble();
    }

    public static int addExact(int x, int y) {
        return Math.addExact(x, y);
    }

    public static long addExact(long x, long y) {
        return Math.addExact(x, y);
    }

    public static int subtractExact(int x, int y) {
        return Math.subtractExact(x, y);
    }

    public static long subtractExact(long x, long y) {
        return Math.subtractExact(x, y);
    }

    public static int multiplyExact(int x, int y) {
        return Math.multiplyExact(x, y);
    }

    public static long multiplyExact(long x, long y) {
        return Math.multiplyExact(x, y);
    }

    public static int toIntExact(long value) {
        return Math.toIntExact(value);
    }

    public static int floorDiv(int x, int y) {
        return Math.floorDiv(x, y);
    }

    public static long floorDiv(long x, long y) {
        return Math.floorDiv(x, y);
    }

    public static int floorMod(int x, int y) {
        return Math.floorMod(x, y);
    }

    public static long floorMod(long x, long y) {
        return Math.floorMod(x, y);
    }

    public static int abs(int a) {
        return Math.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static double ulp(double d) {
        return Math.ulp(d);
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }

    public static double signum(double d) {
        return Math.signum(d);
    }

    public static float signum(float f) {
        return Math.signum(f);
    }

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double tanh(double var0);

    public static native double hypot(double var0, double var2);

    public static native double expm1(double var0);

    public static native double log1p(double var0);

    public static double copySign(double magnitude, double sign) {
        return Math.copySign(magnitude, Double.isNaN(sign) ? 1.0 : sign);
    }

    public static float copySign(float magnitude, float sign) {
        return Math.copySign(magnitude, Float.isNaN(sign) ? 1.0f : sign);
    }

    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    public static double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static double nextUp(double d) {
        return Math.nextUp(d);
    }

    public static float nextUp(float f) {
        return Math.nextUp(f);
    }

    public static double nextDown(double d) {
        return Math.nextDown(d);
    }

    public static float nextDown(float f) {
        return Math.nextDown(f);
    }

    public static double scalb(double d, int scaleFactor) {
        return Math.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return Math.scalb(f, scaleFactor);
    }

    private static final class RandomNumberGeneratorHolder {
        static final Random randomNumberGenerator = new Random();

        private RandomNumberGeneratorHolder() {
        }
    }
}

