/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.jfr.EventType;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.EventPrintWriter;
import jdk.jfr.internal.tool.JSONWriter;
import jdk.jfr.internal.tool.PrettyWriter;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;
import jdk.jfr.internal.tool.XMLWriter;

final class Print
extends Command {
    Print() {
    }

    @Override
    public String getName() {
        return "print";
    }

    @Override
    public List<String> getOptionSyntax() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("[--xml|--json]");
        list.add("[--categories <filter>]");
        list.add("[--events <filter>]");
        list.add("[--stack-depth <depth>]");
        list.add("<file>");
        return list;
    }

    @Override
    protected String getTitle() {
        return "Print contents of a recording file";
    }

    @Override
    public String getDescription() {
        return this.getTitle() + ". See 'jfr help print' for details.";
    }

    @Override
    public void displayOptionUsage(PrintStream stream) {
        stream.println("  --xml                   Print recording in XML format");
        stream.println();
        stream.println("  --json                  Print recording in JSON format");
        stream.println();
        stream.println("  --categories <filter>   Select events matching a category name.");
        stream.println("                          The filter is a comma-separated list of names,");
        stream.println("                          simple and/or qualified, and/or quoted glob patterns");
        stream.println();
        stream.println("  --events <filter>       Select events matching an event name.");
        stream.println("                          The filter is a comma-separated list of names,");
        stream.println("                          simple and/or qualified, and/or quoted glob patterns");
        stream.println();
        stream.println("  --stack-depth <depth>   Number of frames in stack traces, by default 5");
        stream.println();
        stream.println("  <file>                  Location of the recording file (.jfr)");
        stream.println();
        stream.println();
        stream.println("Example usage:");
        stream.println();
        stream.println(" jfr print --events OldObjectSample recording.jfr");
        stream.println();
        stream.println(" jfr print --events CPULoad,GarbageCollection recording.jfr");
        stream.println();
        stream.println(" jfr print --categories \"GC,JVM,Java*\" recording.jfr");
        stream.println();
        stream.println(" jfr print --events \"jdk.*\" --stack-depth 64 recording.jfr");
        stream.println();
        stream.println(" jfr print --json --events CPULoad recording.jfr");
    }

    @Override
    public void execute(Deque<String> options) throws UserSyntaxException, UserDataException {
        Path file = this.getJFRInputFile(options);
        PrintWriter pw = new PrintWriter(System.out, false);
        Predicate<EventType> eventFilter = null;
        int stackDepth = 5;
        EventPrintWriter eventWriter = null;
        int optionCount = options.size();
        boolean foundEventFilter = false;
        boolean foundCategoryFilter = false;
        while (optionCount > 0) {
            String filter;
            if (this.acceptFilterOption(options, "--events")) {
                if (foundEventFilter) {
                    throw new UserSyntaxException("use --events event1,event2,event3 to include multiple events");
                }
                foundEventFilter = true;
                filter = options.remove();
                this.warnForWildcardExpansion("--events", filter);
                eventFilter = Print.addEventFilter(filter, eventFilter);
            }
            if (this.acceptFilterOption(options, "--categories")) {
                if (foundCategoryFilter) {
                    throw new UserSyntaxException("use --categories category1,category2 to include multiple categories");
                }
                foundCategoryFilter = true;
                filter = options.remove();
                this.warnForWildcardExpansion("--categories", filter);
                eventFilter = Print.addCategoryFilter(filter, eventFilter);
            }
            if (this.acceptOption(options, "--stack-depth")) {
                String value = options.pop();
                try {
                    stackDepth = Integer.parseInt(value);
                    if (stackDepth < 0) {
                        throw new UserSyntaxException("stack depth must be zero or a positive integer.");
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new UserSyntaxException("not a valid value for --stack-depth");
                }
            }
            if (Print.acceptFormatterOption(options, eventWriter, "--json")) {
                eventWriter = new JSONWriter(pw);
            }
            if (Print.acceptFormatterOption(options, eventWriter, "--xml")) {
                eventWriter = new XMLWriter(pw);
            }
            if (optionCount == options.size()) {
                this.checkCommonError(options, "--event", "--events");
                this.checkCommonError(options, "--category", "--categories");
                throw new UserSyntaxException("unknown option " + options.peek());
            }
            optionCount = options.size();
        }
        if (eventWriter == null) {
            eventWriter = new PrettyWriter(pw);
        }
        eventWriter.setStackDepth(stackDepth);
        if (eventFilter != null) {
            eventFilter = Print.addCache(eventFilter, eventType -> eventType.getId());
            eventWriter.setEventFilter(eventFilter);
        }
        try {
            eventWriter.print(file);
        }
        catch (IOException ioe) {
            this.couldNotReadError(file, ioe);
        }
        pw.flush();
    }

    private void checkCommonError(Deque<String> options, String typo, String correct) throws UserSyntaxException {
        if (typo.equals(options.peek())) {
            throw new UserSyntaxException("unknown option " + typo + ", did you mean " + correct + "?");
        }
    }

    private static boolean acceptFormatterOption(Deque<String> options, EventPrintWriter eventWriter, String expected) throws UserSyntaxException {
        if (expected.equals(options.peek())) {
            if (eventWriter != null) {
                throw new UserSyntaxException("only one format can be specified at a time");
            }
            options.remove();
            return true;
        }
        return false;
    }

    private static <T, X> Predicate<T> addCache(Predicate<T> filter, Function<T, X> cacheFunction) {
        HashMap cache = new HashMap();
        return t -> cache.computeIfAbsent(cacheFunction.apply(t), x -> filter.test(t));
    }

    private static <T> Predicate<T> recurseIfPossible(Predicate<T> filter) {
        return x -> filter != null && filter.test(x);
    }

    private static Predicate<EventType> addCategoryFilter(String filterText, Predicate<EventType> eventFilter) throws UserSyntaxException {
        List<String> filters = Print.explodeFilter(filterText);
        Predicate<EventType> newFilter = Print.recurseIfPossible(eventType -> {
            for (String category : eventType.getCategoryNames()) {
                for (String filter : filters) {
                    if (Print.match(category, filter)) {
                        return true;
                    }
                    if (!category.contains(" ") || !Print.acronomify(category).equals(filter)) continue;
                    return true;
                }
            }
            return false;
        });
        return eventFilter == null ? newFilter : eventFilter.or(newFilter);
    }

    private static String acronomify(String multipleWords) {
        boolean newWord = true;
        String acronym = "";
        for (char c : multipleWords.toCharArray()) {
            if (newWord && Character.isAlphabetic(c) && Character.isUpperCase(c)) {
                acronym = acronym + c;
            }
            newWord = Character.isWhitespace(c);
        }
        return acronym;
    }

    private static Predicate<EventType> addEventFilter(String filterText, Predicate<EventType> eventFilter) throws UserSyntaxException {
        List<String> filters = Print.explodeFilter(filterText);
        Predicate<EventType> newFilter = Print.recurseIfPossible(eventType -> {
            for (String filter : filters) {
                String fullEventName = eventType.getName();
                if (Print.match(fullEventName, filter)) {
                    return true;
                }
                String eventName = fullEventName.substring(fullEventName.lastIndexOf(".") + 1);
                if (!Print.match(eventName, filter)) continue;
                return true;
            }
            return false;
        });
        return eventFilter == null ? newFilter : eventFilter.or(newFilter);
    }

    private static boolean match(String text, String filter) {
        if (filter.length() == 0) {
            return text.length() == 0;
        }
        if (filter.charAt(0) == '*') {
            filter = filter.substring(1);
            for (int n = 0; n <= text.length(); ++n) {
                if (!Print.match(text.substring(n), filter)) continue;
                return true;
            }
        } else {
            if (text.length() == 0) {
                return false;
            }
            if (filter.charAt(0) == '?') {
                return Print.match(text.substring(1), filter.substring(1));
            }
            if (filter.charAt(0) == text.charAt(0)) {
                return Print.match(text.substring(1), filter.substring(1));
            }
        }
        return false;
    }

    private static List<String> explodeFilter(String filter) throws UserSyntaxException {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).isEmpty()) continue;
            list.add(s);
        }
        return list;
    }
}

