/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.internal.org.xml.sax.Attributes;
import jdk.internal.org.xml.sax.EntityResolver;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Enabled;
import jdk.jfr.Experimental;
import jdk.jfr.Label;
import jdk.jfr.Period;
import jdk.jfr.Relational;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.TransitionFrom;
import jdk.jfr.TransitionTo;
import jdk.jfr.Unsigned;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;

final class MetadataHandler
extends DefaultHandler
implements EntityResolver {
    final Map<String, TypeElement> types = new LinkedHashMap<String, TypeElement>(200);
    final Map<String, XmlType> xmlTypes = new HashMap<String, XmlType>(20);
    final Map<String, List<AnnotationElement>> xmlContentTypes = new HashMap<String, List<AnnotationElement>>(20);
    final List<String> relations = new ArrayList<String>();
    long eventTypeId = 255L;
    long structTypeId = 33L;
    FieldElement currentField;
    TypeElement currentType;

    MetadataHandler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (qName) {
            case "XmlType": {
                XmlType xmlType = new XmlType();
                xmlType.name = attributes.getValue("name");
                xmlType.javaType = attributes.getValue("javaType");
                xmlType.contentType = attributes.getValue("contentType");
                xmlType.unsigned = Boolean.valueOf(attributes.getValue("unsigned"));
                this.xmlTypes.put(xmlType.name, xmlType);
                break;
            }
            case "Type": 
            case "Event": {
                this.currentType = new TypeElement();
                this.currentType.name = attributes.getValue("name");
                this.currentType.label = attributes.getValue("label");
                this.currentType.description = attributes.getValue("description");
                this.currentType.category = attributes.getValue("category");
                this.currentType.thread = this.getBoolean(attributes, "thread", false);
                this.currentType.stackTrace = this.getBoolean(attributes, "stackTrace", false);
                this.currentType.startTime = this.getBoolean(attributes, "startTime", true);
                this.currentType.period = attributes.getValue("period");
                this.currentType.cutoff = this.getBoolean(attributes, "cutoff", false);
                this.currentType.experimental = this.getBoolean(attributes, "experimental", false);
                this.currentType.isEvent = qName.equals("Event");
                break;
            }
            case "Field": {
                this.currentField = new FieldElement();
                this.currentField.struct = this.getBoolean(attributes, "struct", false);
                this.currentField.array = this.getBoolean(attributes, "array", false);
                this.currentField.name = attributes.getValue("name");
                this.currentField.label = attributes.getValue("label");
                this.currentField.typeName = attributes.getValue("type");
                this.currentField.description = attributes.getValue("description");
                this.currentField.experimental = this.getBoolean(attributes, "experimental", false);
                this.currentField.contentType = attributes.getValue("contentType");
                this.currentField.relation = attributes.getValue("relation");
                this.currentField.transition = attributes.getValue("transition");
                break;
            }
            case "XmlContentType": {
                String name = attributes.getValue("name");
                String annotation = attributes.getValue("annotation");
                this.xmlContentTypes.put(name, this.createAnnotationElements(annotation));
                break;
            }
            case "Relation": {
                String n = attributes.getValue("name");
                this.relations.add(n);
            }
        }
    }

    private List<AnnotationElement> createAnnotationElements(String annotation) throws InternalError {
        String[] annotations = annotation.split(",");
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        for (String a : annotations) {
            int leftParenthesis = (a = a.trim()).indexOf("(");
            if (leftParenthesis == -1) {
                annotationElements.add(new AnnotationElement(this.createAnnotationClass(a)));
                continue;
            }
            int rightParenthesis = a.lastIndexOf(")");
            if (rightParenthesis == -1) {
                throw new InternalError("Expected closing parenthesis for 'XMLContentType'");
            }
            String value = a.substring(leftParenthesis + 1, rightParenthesis);
            String type = a.substring(0, leftParenthesis);
            annotationElements.add(new AnnotationElement(this.createAnnotationClass(type), value));
        }
        return annotationElements;
    }

    private Class<? extends Annotation> createAnnotationClass(String type) {
        try {
            if (!type.startsWith("jdk.jfr.")) {
                throw new IllegalStateException("Incorrect type " + type + ". Annotation class must be located in jdk.jfr package.");
            }
            Class<?> c = Class.forName(type, true, null);
            return c;
        }
        catch (ClassNotFoundException cne) {
            throw new IllegalStateException(cne);
        }
    }

    private boolean getBoolean(Attributes attributes, String name, boolean defaultValue) {
        String value = attributes.getValue(name);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        switch (qName) {
            case "Type": 
            case "Event": {
                this.types.put(this.currentType.name, this.currentType);
                this.currentType = null;
                break;
            }
            case "Field": {
                this.currentType.fields.add(this.currentField);
                this.currentField = null;
            }
        }
    }

    public static List<Type> createTypes() throws IOException {
        SAXParserImpl parser = new SAXParserImpl();
        MetadataHandler t = new MetadataHandler();
        Throwable throwable = null;
        try (BufferedInputStream is = new BufferedInputStream(SecuritySupport.getResourceAsStream("/jdk/jfr/internal/types/metadata.xml"));){
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Parsing metadata.xml");
            try {
                ((SAXParser)parser).parse(is, (DefaultHandler)t);
                List<Type> list = t.buildTypes();
                return list;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new IOException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private List<Type> buildTypes() {
        this.removeXMLConvenience();
        Map<String, Type> typeMap = this.buildTypeMap();
        Map<String, AnnotationElement> relationMap = this.buildRelationMap(typeMap);
        this.addFields(typeMap, relationMap);
        return this.trimTypes(typeMap);
    }

    private Map<String, AnnotationElement> buildRelationMap(Map<String, Type> typeMap) {
        HashMap<String, AnnotationElement> relationMap = new HashMap<String, AnnotationElement>();
        for (String relation : this.relations) {
            Type relationType = new Type("jdk.types." + relation, Type.SUPER_TYPE_ANNOTATION, this.eventTypeId++);
            relationType.setAnnotations(Collections.singletonList(new AnnotationElement(Relational.class)));
            AnnotationElement ae = PrivateAccess.getInstance().newAnnotation(relationType, Collections.emptyList(), true);
            relationMap.put(relation, ae);
            typeMap.put(relationType.getName(), relationType);
        }
        return relationMap;
    }

    private List<Type> trimTypes(Map<String, Type> lookup) {
        ArrayList<Type> trimmedTypes = new ArrayList<Type>(lookup.size());
        for (Type t : lookup.values()) {
            t.trimFields();
            trimmedTypes.add(t);
        }
        return trimmedTypes;
    }

    private void addFields(Map<String, Type> lookup, Map<String, AnnotationElement> relationMap) {
        for (TypeElement te : this.types.values()) {
            Type type = lookup.get(te.name);
            if (te.isEvent) {
                boolean periodic = te.period != null;
                TypeLibrary.addImplicitFields(type, periodic, te.startTime && !periodic, te.thread, te.stackTrace && !periodic, te.cutoff);
            }
            for (FieldElement f : te.fields) {
                Type fieldType = Type.getKnownType(f.typeName);
                if (fieldType == null) {
                    fieldType = Objects.requireNonNull(lookup.get(f.referenceType.name));
                }
                ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
                if (f.unsigned) {
                    aes.add(new AnnotationElement(Unsigned.class));
                }
                if (f.contentType != null) {
                    aes.addAll((Collection)Objects.requireNonNull(this.xmlContentTypes.get(f.contentType)));
                }
                if (f.relation != null) {
                    aes.add(Objects.requireNonNull(relationMap.get(f.relation)));
                }
                if (f.label != null) {
                    aes.add(new AnnotationElement(Label.class, f.label));
                }
                if (f.experimental) {
                    aes.add(new AnnotationElement(Experimental.class));
                }
                if (f.description != null) {
                    aes.add(new AnnotationElement(Description.class, f.description));
                }
                if ("from".equals(f.transition)) {
                    aes.add(new AnnotationElement(TransitionFrom.class));
                }
                if ("to".equals(f.transition)) {
                    aes.add(new AnnotationElement(TransitionTo.class));
                }
                boolean constantPool = !f.struct && f.referenceType != null;
                type.add(PrivateAccess.getInstance().newValueDescriptor(f.name, fieldType, aes, f.array ? 1 : 0, constantPool, null));
            }
        }
    }

    private Map<String, Type> buildTypeMap() {
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        for (Type type : Type.getKnownTypes()) {
            typeMap.put(type.getName(), type);
        }
        for (TypeElement t : this.types.values()) {
            Type type;
            ArrayList<AnnotationElement> aes = new ArrayList<AnnotationElement>();
            if (t.category != null) {
                aes.add(new AnnotationElement(Category.class, this.buildCategoryArray(t.category)));
            }
            if (t.label != null) {
                aes.add(new AnnotationElement(Label.class, t.label));
            }
            if (t.description != null) {
                aes.add(new AnnotationElement(Description.class, t.description));
            }
            if (t.isEvent) {
                if (t.period != null) {
                    aes.add(new AnnotationElement(Period.class, t.period));
                } else {
                    if (t.startTime) {
                        aes.add(new AnnotationElement(Threshold.class, "0 ns"));
                    }
                    if (t.stackTrace) {
                        aes.add(new AnnotationElement(StackTrace.class, true));
                    }
                }
                if (t.cutoff) {
                    aes.add(new AnnotationElement(Cutoff.class, "infinity"));
                }
            }
            if (t.experimental) {
                aes.add(new AnnotationElement(Experimental.class));
            }
            if (t.isEvent) {
                aes.add(new AnnotationElement(Enabled.class, false));
                type = new PlatformEventType(t.name, this.eventTypeId++, false, true);
            } else {
                long l;
                boolean valueType = t.name.endsWith("StackFrame") || t.valueType;
                String string = t.name;
                if (valueType) {
                    long l2 = this.eventTypeId;
                    l = l2;
                    this.eventTypeId = l2 + 1L;
                } else {
                    l = this.nextTypeId(t.name);
                }
                type = new Type(string, null, l, false);
            }
            type.setAnnotations(aes);
            typeMap.put(t.name, type);
        }
        return typeMap;
    }

    private long nextTypeId(String name) {
        if (Type.THREAD.getName().equals(name)) {
            return Type.THREAD.getId();
        }
        if (Type.STRING.getName().equals(name)) {
            return Type.STRING.getId();
        }
        if (Type.CLASS.getName().equals(name)) {
            return Type.CLASS.getId();
        }
        for (Type type : Type.getKnownTypes()) {
            if (!type.getName().equals(name)) continue;
            return type.getId();
        }
        return this.structTypeId++;
    }

    private String[] buildCategoryArray(String category) {
        ArrayList<String> categories = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (char c : category.toCharArray()) {
            if (c == ',') {
                categories.add(sb.toString().trim());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        categories.add(sb.toString().trim());
        return categories.toArray(new String[0]);
    }

    private void removeXMLConvenience() {
        for (TypeElement t : this.types.values()) {
            XmlType xmlType = this.xmlTypes.get(t.name);
            if (xmlType != null && xmlType.javaType != null) {
                t.name = xmlType.javaType;
                continue;
            }
            if (t.isEvent) {
                t.name = "jdk." + t.name;
                continue;
            }
            t.name = "jdk.types." + t.name;
        }
        for (TypeElement t : this.types.values()) {
            for (FieldElement f : t.fields) {
                f.referenceType = this.types.get(f.typeName);
                XmlType xmlType = this.xmlTypes.get(f.typeName);
                if (xmlType != null) {
                    if (xmlType.javaType != null) {
                        f.typeName = xmlType.javaType;
                    }
                    if (xmlType.contentType != null) {
                        f.contentType = xmlType.contentType;
                    }
                    if (xmlType.unsigned) {
                        f.unsigned = true;
                    }
                }
                if (!f.struct || f.referenceType == null) continue;
                f.referenceType.valueType = true;
            }
        }
    }

    static class XmlType {
        String name;
        String javaType;
        String contentType;
        boolean unsigned;

        XmlType() {
        }
    }

    static class FieldElement {
        TypeElement referenceType;
        String name;
        String label;
        String description;
        String contentType;
        String typeName;
        String transition;
        String relation;
        boolean struct;
        boolean array;
        boolean experimental;
        boolean unsigned;

        FieldElement() {
        }
    }

    static class TypeElement {
        List<FieldElement> fields = new ArrayList<FieldElement>();
        String name;
        String label;
        String description;
        String category;
        String superType;
        String period;
        boolean thread;
        boolean startTime;
        boolean stackTrace;
        boolean cutoff;
        boolean isEvent;
        boolean experimental;
        boolean valueType;

        TypeElement() {
        }
    }
}

