/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.Utils;

public final class FlightRecorder {
    private static volatile FlightRecorder platformRecorder;
    private static volatile boolean initialized;
    private final PlatformRecorder internal;

    private FlightRecorder(PlatformRecorder internal) {
        this.internal = internal;
    }

    public List<Recording> getRecordings() {
        ArrayList<Recording> recs = new ArrayList<Recording>();
        for (PlatformRecording r : this.internal.getRecordings()) {
            recs.add(r.getRecording());
        }
        return Collections.unmodifiableList(recs);
    }

    public Recording takeSnapshot() {
        Recording snapshot = new Recording();
        snapshot.setName("Snapshot");
        this.internal.fillWithRecordedData(snapshot.getInternal(), null);
        return snapshot;
    }

    public static void register(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(eventClass);
        MetadataRepository.getInstance().register(eventClass);
    }

    public static void unregister(Class<? extends Event> eventClass) {
        Objects.requireNonNull(eventClass);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(eventClass);
        MetadataRepository.getInstance().unregister(eventClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlightRecorder getFlightRecorder() throws IllegalStateException, SecurityException {
        Class<PlatformRecorder> clazz = PlatformRecorder.class;
        synchronized (PlatformRecorder.class) {
            Utils.checkAccessFlightRecorder();
            JVMSupport.ensureWithIllegalStateException();
            if (platformRecorder == null) {
                try {
                    platformRecorder = new FlightRecorder(new PlatformRecorder());
                }
                catch (IllegalStateException ise) {
                    throw ise;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't create Flight Recorder. " + e.getMessage(), e);
                }
                initialized = true;
                Logger.log(LogTag.JFR, LogLevel.INFO, "Flight Recorder initialized");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "maxchunksize: " + Options.getMaxChunkSize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "memorysize: " + Options.getMemorySize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "globalbuffersize: " + Options.getGlobalBufferSize() + " bytes");
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "globalbuffercount: " + Options.getGlobalBufferCount());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "dumppath: " + Options.getDumpPath());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "samplethreads: " + Options.getSampleThreads());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "stackdepth: " + Options.getStackDepth());
                Logger.log(LogTag.JFR, LogLevel.DEBUG, "threadbuffersize: " + Options.getThreadBufferSize());
                Logger.log(LogTag.JFR, LogLevel.INFO, "Created repository " + Repository.getRepository().getRepositoryPath().toString());
                PlatformRecorder.notifyRecorderInitialized(platformRecorder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return platformRecorder;
        }
    }

    public static void addPeriodicEvent(Class<? extends Event> eventClass, Runnable hook) throws SecurityException {
        Objects.requireNonNull(eventClass);
        Objects.requireNonNull(hook);
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        Utils.ensureValidEventSubclass(eventClass);
        Utils.checkRegisterPermission();
        AccessControlContext acc = AccessController.getContext();
        RequestEngine.addHook(acc, EventType.getEventType(eventClass).getPlatformEventType(), hook);
    }

    public static boolean removePeriodicEvent(Runnable hook) throws SecurityException {
        Objects.requireNonNull(hook);
        Utils.checkRegisterPermission();
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return RequestEngine.removeHook(hook);
    }

    public List<EventType> getEventTypes() {
        return Collections.unmodifiableList(MetadataRepository.getInstance().getRegisteredEventTypes());
    }

    public static void addListener(FlightRecorderListener changeListener) {
        Objects.requireNonNull(changeListener);
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return;
        }
        PlatformRecorder.addListener(changeListener);
    }

    public static boolean removeListener(FlightRecorderListener changeListener) {
        Objects.requireNonNull(changeListener);
        Utils.checkAccessFlightRecorder();
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return PlatformRecorder.removeListener(changeListener);
    }

    public static boolean isAvailable() {
        if (JVMSupport.isNotAvailable()) {
            return false;
        }
        return JVM.getJVM().isAvailable();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    PlatformRecorder getInternal() {
        return this.internal;
    }
}

