/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.Debug;
import com.ibm.jvm.FormatTimestamp;
import com.ibm.jvm.Indent;
import com.ibm.jvm.InputFile;
import com.ibm.jvm.MessageFile;
import com.ibm.jvm.OutputFile;
import com.ibm.jvm.ProgramOption;
import com.ibm.jvm.Statistics;
import com.ibm.jvm.Summary;
import com.ibm.jvm.Threads;
import com.ibm.jvm.Timezone;
import com.ibm.jvm.Verbose;
import com.ibm.jvm.trace.format.api.MissingDataException;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TraceFormat {
    Object[][] options = new Object[][]{{"timezoneoffset", -1, "An offset in hours to add to the time stamps", Boolean.FALSE, Boolean.FALSE}, {"tag", -1, "A string that's prepended to the formatted trace point string to help track and compare trace from multiple JVMs", Boolean.FALSE, Boolean.FALSE}};
    private static Map indentMap = new HashMap();

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        TraceContext traceContext;
        Object object3;
        ProgramOption.addOption(InputFile.class);
        ProgramOption.addOption(OutputFile.class);
        ProgramOption.addOption(MessageFile.class);
        ProgramOption.addOption(FormatTimestamp.class);
        ProgramOption.addOption(Indent.class);
        ProgramOption.addOption(Summary.class);
        ProgramOption.addOption(Threads.class);
        ProgramOption.addOption(Timezone.class);
        ProgramOption.addOption(Verbose.class);
        ProgramOption.addOption(Debug.class);
        ProgramOption.addOption(Statistics.class);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                ProgramOption.addArgument(stringArray[i]);
            }
            ProgramOption.applyDefaults();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            return;
        }
        List list = (List)ProgramOption.getValue("input_file");
        List list2 = (List)ProgramOption.getValue("datfile");
        List list3 = (List)ProgramOption.getValue("threads");
        Integer n = (Integer)ProgramOption.getValue("timezone");
        Boolean bl = (Boolean)ProgramOption.getValue("format_time");
        Boolean bl2 = (Boolean)ProgramOption.getValue("indent");
        Boolean bl3 = (Boolean)ProgramOption.getValue("summary");
        Boolean bl4 = (Boolean)ProgramOption.getValue("verbose");
        Integer n2 = (Integer)ProgramOption.getValue("debug");
        Boolean bl5 = (Boolean)ProgramOption.getValue("statistics");
        int n3 = 4000;
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        PrintStream printStream3 = null;
        if (n2 > 0) {
            printStream3 = System.err;
        }
        try {
            while (true) {
                try {
                    object3 = ((RandomAccessFile)list.get(0)).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, n3);
                    traceContext = TraceContext.getContext((ByteBuffer)object3, (File)list2.get(0), System.out, printStream2, printStream, printStream3);
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    n3 *= 2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            try {
                byte[] byArray;
                long l = ((RandomAccessFile)list.get(0)).length();
                if (l > 0L) {
                    byArray = new byte[(int)l];
                    ((RandomAccessFile)list.get(0)).seek(0L);
                    int n4 = ((RandomAccessFile)list.get(0)).read(byArray);
                    if ((long)n4 != l || l >= (long)n3) {
                        throw new Exception("received premature end of file: " + iOException.getMessage());
                    }
                } else {
                    throw new Exception("empty trace file");
                }
                traceContext = TraceContext.getContext(byArray, byArray.length, (File)list2.get(0), System.out, printStream2, printStream, printStream3);
            }
            catch (Exception exception) {
                System.err.println("Unable to read trace header from file: " + exception.getMessage());
                System.err.println("Please check that the input file is a binary trace file");
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Problem reading the trace file header: " + illegalArgumentException.getMessage());
            System.err.println("Please check that the input file is a binary trace file");
            return;
        }
        traceContext.setRecordThreadNames(true);
        if (bl4.booleanValue() || n2 > 0) {
            traceContext.setErrorStream(System.err);
            traceContext.setWarningStream(System.err);
        }
        traceContext.setDebugLevel(n2);
        for (Long l : list3) {
            traceContext.addThreadToFilter(l);
        }
        traceContext.setTimeZoneOffset(n);
        for (int i = 1; i < list2.size(); ++i) {
            File file = (File)list2.get(i);
            try {
                traceContext.addMessageData(file);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Unable to process trace format data file: " + file.getAbsolutePath() + " (" + iOException.getMessage() + ")");
                return;
            }
        }
        PrintWriter printWriter = (PrintWriter)ProgramOption.getValue("output_file");
        long l = 0L;
        long l2 = 0L;
        long l3 = System.nanoTime();
        long l4 = 0L;
        long l5 = l3;
        long l6 = 0L;
        long l7 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            long l8 = traceContext.getHeaderSize();
            long l9 = traceContext.getRecordSize();
            object2 = (RandomAccessFile)list.get(i);
            long l10 = ((RandomAccessFile)object2).length();
            if ((l10 - (long)traceContext.getHeaderSize()) % l9 != 0L) {
                traceContext.warning(traceContext, "The body of the trace file is not a multiple of the record size, file either truncated or corrupt");
            }
            while (l8 < l10) {
                try {
                    object = traceContext.addData((RandomAccessFile)object2, l8);
                    indentMap.put(object, "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    traceContext.error(traceContext, "Bad block of trace data in input file at offset " + l8 + ": " + illegalArgumentException.getMessage());
                }
                l8 += l9;
                l7 += l9;
                ++l;
            }
        }
        printWriter.println(traceContext.summary());
        if (bl3.booleanValue() && !bl5.booleanValue()) {
            printWriter.close();
            return;
        }
        if (!bl3.booleanValue()) {
            String string;
            printWriter.println("                Trace Formatted Data " + System.getProperty("line.separator"));
            if (n == 0) {
                string = "Time (UTC)          ";
            } else {
                string = n > 0 ? "Time (UTC +" : "Time (UTC -";
                string = string + Math.abs(n / 60) + ":" + Math.abs(n % 60) + ")    ";
            }
            string = traceContext.getPointerSize() == 4 ? string + "Thread ID " : string + "Thread ID         ";
            string = string + " Tracepoint ID       Type        Tracepoint Data";
            printWriter.println(string);
        }
        object3 = traceContext.getTracepoints();
        String string = (float)l7 / 1048576.0f + "Mb";
        traceContext.message(traceContext, "Processing " + string + " of binary trace data");
        TraceThread traceThread = null;
        String string2 = "";
        while (object3.hasNext()) {
            long l11;
            float f;
            TracePointImpl tracePointImpl;
            try {
                tracePointImpl = (TracePointImpl)object3.next();
            }
            catch (MissingDataException missingDataException) {
                l2 += missingDataException.getMissingBytes() / (long)traceContext.getRecordSize();
                continue;
            }
            if (!bl3.booleanValue()) {
                TraceThread traceThread2 = tracePointImpl.getThread();
                object2 = tracePointImpl.getComponentName();
                int n5 = tracePointImpl.getID();
                String string3 = tracePointImpl.getContainerComponent();
                object = "";
                try {
                    object = tracePointImpl.getFormattedParameters();
                    if (object == null || ((String)object).length() == 0) {
                        traceContext.error(traceContext, "null parameter data for trace point " + (String)object2 + "." + n5);
                    }
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    traceContext.error(traceContext, "Underflow accessing parameter data for trace point " + (String)object2 + "." + n5);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (bl.booleanValue()) {
                    stringBuilder.append(tracePointImpl.getFormattedTime());
                } else {
                    stringBuilder.append(tracePointImpl.getRawTime());
                }
                stringBuilder.append(" ").append(traceThread2 != traceThread ? "*" : " ");
                stringBuilder.append(traceContext.formatPointer(traceThread2.getThreadID()));
                stringBuilder.append(" ");
                String string4 = String.format(string3 != null ? "%s(%s).%d" : "%1$s.%3$d", object2, string3, n5);
                stringBuilder.append(String.format("%-19s ", string4));
                stringBuilder.append(tracePointImpl.getType());
                if (bl2.booleanValue()) {
                    string2 = indentMap.get(traceThread2).toString();
                    if (tracePointImpl.getTypeAsInt() == 4 || tracePointImpl.getTypeAsInt() == 5) {
                        try {
                            string2 = string2.substring(2);
                            indentMap.put(traceThread2, string2);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            string2 = "";
                            indentMap.put(traceThread2, "");
                        }
                    }
                    stringBuilder.append(string2);
                }
                stringBuilder.append(((String)object).length() > 0 ? (((String)object).charAt(0) == '*' ? " " : "") + (String)object : "");
                if (bl2.booleanValue() && (tracePointImpl.getTypeAsInt() == 2 || tracePointImpl.getTypeAsInt() == 3)) {
                    string2 = string2 + "  ";
                    indentMap.put(traceThread2, string2);
                }
                if (n2 > 0) {
                    stringBuilder.append(" [" + tracePointImpl.getDebugInfo() + "]");
                }
                traceThread = traceThread2;
                printWriter.println(stringBuilder.toString());
            }
            if (traceContext.getTotalRecords() == l6 || (f = (float)(l11 = (l6 = traceContext.getTotalRecords()) * (long)traceContext.getRecordSize()) / 1048576.0f) % 10.0f != 0.0f) continue;
            int n6 = (int)(100L * l11 / l7);
            if (bl4.booleanValue()) {
                l4 = System.nanoTime();
                float f2 = 1.0E10f / (float)(l4 - l5);
                float f3 = f * 1.0E9f / (float)(l4 - l3);
                l5 = System.nanoTime();
                traceContext.message(traceContext, "Processed " + f + "Mb (" + n6 + "%), burst speed: " + f2 + "Mb/s, average: " + f3 + "Mb/s");
                continue;
            }
            traceContext.message(traceContext, "Processed " + f + "Mb (" + n6 + "%)");
        }
        if (l2 > 0L) {
            traceContext.warning(traceContext, l2 + " records were discarded during trace generation");
        }
        printWriter.close();
        traceContext.message(traceContext, "Completed processing of " + traceContext.getTotalTracePoints() + " tracepoints with " + traceContext.getWarningCount() + " warnings and " + traceContext.getErrorCount() + " errors");
        if (bl4.booleanValue()) {
            l4 = System.nanoTime();
            float f = (float)(l * (long)traceContext.getRecordSize()) / (1048576.0f * (float)TimeUnit.NANOSECONDS.toSeconds(l4 - l3));
            traceContext.message(traceContext, "Total processing time " + TimeUnit.NANOSECONDS.toMillis(l4 - l3) + "ms (" + f + "Mb/s)");
        }
        if (bl5.booleanValue()) {
            traceContext.message(traceContext, traceContext.statistics());
        }
    }
}

