/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class SegmentTree {
    private J9MemorySegmentPointer[] cache;

    public SegmentTree(J9MemorySegmentListPointer j9MemorySegmentListPointer) {
        this.setSegmentList(j9MemorySegmentListPointer);
    }

    protected void setSegmentList(J9MemorySegmentListPointer j9MemorySegmentListPointer) {
        ArrayList<J9MemorySegmentPointer> arrayList = new ArrayList<J9MemorySegmentPointer>();
        try {
            GCSegmentIterator gCSegmentIterator = GCSegmentIterator.fromJ9MemorySegmentList(j9MemorySegmentListPointer, 0L);
            while (gCSegmentIterator.hasNext()) {
                arrayList.add(gCSegmentIterator.next());
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corrupted segment in list", corruptDataException, false);
            this.cache = new J9MemorySegmentPointer[0];
        }
        Collections.sort(arrayList, new Comparator<J9MemorySegmentPointer>(){

            @Override
            public int compare(J9MemorySegmentPointer j9MemorySegmentPointer, J9MemorySegmentPointer j9MemorySegmentPointer2) {
                try {
                    return j9MemorySegmentPointer.eq(j9MemorySegmentPointer2) ? 0 : (j9MemorySegmentPointer.heapBase().lt(j9MemorySegmentPointer2.heapBase()) ? -1 : 1);
                }
                catch (CorruptDataException corruptDataException) {
                    EventManager.raiseCorruptDataEvent("Corrupted segment in list", corruptDataException, false);
                    return -1;
                }
            }
        });
        this.cache = arrayList.toArray(new J9MemorySegmentPointer[arrayList.size()]);
    }

    public J9MemorySegmentPointer findSegment(AbstractPointer abstractPointer) {
        try {
            return this.findSegment(0, this.cache.length, abstractPointer);
        }
        catch (CorruptDataException corruptDataException) {
            return this.linearSearch(0, this.cache.length, abstractPointer);
        }
    }

    private J9MemorySegmentPointer findSegment(int n, int n2, AbstractPointer abstractPointer) throws CorruptDataException {
        if (n2 - n < 4) {
            return this.linearSearch(n, n2, abstractPointer);
        }
        int n3 = (n + n2) / 2;
        J9MemorySegmentPointer j9MemorySegmentPointer = this.cache[n3];
        if (abstractPointer.gte(j9MemorySegmentPointer.heapBase())) {
            if (abstractPointer.lt(j9MemorySegmentPointer.heapAlloc())) {
                return j9MemorySegmentPointer;
            }
            return this.findSegment(n3, n2, abstractPointer);
        }
        return this.findSegment(n, n3, abstractPointer);
    }

    private J9MemorySegmentPointer linearSearch(int n, int n2, AbstractPointer abstractPointer) {
        for (int i = n; i < n2; ++i) {
            if (this.cache[i] == null || !this.includesKey(this.cache[i], abstractPointer)) continue;
            return this.cache[i];
        }
        return null;
    }

    private boolean includesKey(J9MemorySegmentPointer j9MemorySegmentPointer, AbstractPointer abstractPointer) {
        try {
            return abstractPointer.gte(j9MemorySegmentPointer.heapBase()) && abstractPointer.lt(j9MemorySegmentPointer.heapAlloc());
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corrupted segment in list", corruptDataException, false);
            return false;
        }
    }
}

