/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.RasGlobalStoragePointer;
import com.ibm.j9ddr.vm29.pointer.generated.UtComponentDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.UtComponentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.UtGlobalDataPointer;
import com.ibm.j9ddr.vm29.pointer.generated.UtModuleInfoPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.RastraceInternalConstants;
import com.ibm.j9ddr.vm29.structure.UteModuleConstants;
import java.io.PrintStream;

public class TraceConfigCommand
extends Command {
    private final boolean verbose = false;

    public TraceConfigCommand() {
        this.addCommand("tpconfig", "[<component>|all]", "Lists trace components or tracepoints enabled for specified components");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, final PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            RasGlobalStoragePointer rasGlobalStoragePointer = RasGlobalStoragePointer.cast(j9JavaVMPointer.j9rasGlobalStorage());
            UtGlobalDataPointer utGlobalDataPointer = UtGlobalDataPointer.cast(rasGlobalStoragePointer.utGlobalData());
            UtComponentListPointer utComponentListPointer = utGlobalDataPointer.componentList();
            UtComponentDataPointer utComponentDataPointer = utComponentListPointer.head();
            if (stringArray.length == 0) {
                TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                    @Override
                    public void visit(UtModuleInfoPointer utModuleInfoPointer) throws CorruptDataException {
                        printStream.println(TraceConfigCommand.moduleName(utModuleInfoPointer));
                    }
                }, utComponentDataPointer, context, printStream);
            } else if ("all".equals(stringArray[0])) {
                TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                    @Override
                    public void visit(UtModuleInfoPointer utModuleInfoPointer) throws CorruptDataException {
                        TraceConfigCommand.this.printActiveTracePoints(utModuleInfoPointer, printStream);
                    }
                }, utComponentDataPointer, context, printStream);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    final String string2 = stringArray[i];
                    TraceConfigCommand.walkTraceComponents(new ModuleVisitor(){

                        @Override
                        public void visit(UtModuleInfoPointer utModuleInfoPointer) throws CorruptDataException {
                            if (string2.equals(TraceConfigCommand.moduleName(utModuleInfoPointer))) {
                                TraceConfigCommand.this.printActiveTracePoints(utModuleInfoPointer, printStream);
                            }
                        }
                    }, utComponentDataPointer, context, printStream);
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    private void printActiveTracePoints(UtModuleInfoPointer utModuleInfoPointer, PrintStream printStream) throws CorruptDataException {
        int n = utModuleInfoPointer.count().intValue();
        U8Pointer u8Pointer = utModuleInfoPointer.active();
        String string = TraceConfigCommand.moduleName(utModuleInfoPointer);
        for (int i = 0; i < n; ++i) {
            long l = u8Pointer.at(i).longValue();
            if (l == RastraceInternalConstants.UT_NONE) continue;
            String string2 = this.decodeTraceActivationState(l);
            printStream.println(string + "." + i + " =" + string2);
        }
    }

    private String decodeTraceActivationState(long l) {
        String string = "";
        if (l == RastraceInternalConstants.UT_NONE) {
            string = string + " NONE";
        }
        if ((l & RastraceInternalConstants.UT_MAXIMAL) != 0L) {
            string = string + " MAXIMAL";
        }
        if ((l & RastraceInternalConstants.UT_MINIMAL) != 0L) {
            string = string + " MINIMAL";
        }
        if ((l & RastraceInternalConstants.UT_COUNT) != 0L) {
            string = string + " COUNT";
        }
        if ((l & RastraceInternalConstants.UT_PRINT) != 0L) {
            string = string + " PRINT";
        }
        if ((l & RastraceInternalConstants.UT_PLATFORM) != 0L) {
            string = string + " PLATFORM";
        }
        if ((l & RastraceInternalConstants.UT_EXCEPTION) != 0L) {
            string = string + " EXCEPTION";
        }
        if ((l & RastraceInternalConstants.UT_TRIGGER) != 0L) {
            string = string + " TRIGGER";
        }
        if ((l & RastraceInternalConstants.UT_EXTERNAL) != 0L) {
            string = string + " EXTERNAL";
        }
        if ((l & RastraceInternalConstants.UT_NONE) != 0L) {
            string = string + " NONE";
        }
        if ((l & UteModuleConstants.UT_SPECIAL_ASSERTION) != 0L) {
            string = string + " ASSERTION";
        }
        if (string.equals("")) {
            string = " <error unknown state>";
        }
        return string;
    }

    private static String moduleName(UtModuleInfoPointer utModuleInfoPointer) throws CorruptDataException {
        UtModuleInfoPointer utModuleInfoPointer2 = utModuleInfoPointer.containerModule();
        String string = utModuleInfoPointer.name().getCStringAtOffset(0L, utModuleInfoPointer.namelength().intValue());
        if (utModuleInfoPointer2 != null && utModuleInfoPointer2.notNull()) {
            String string2 = utModuleInfoPointer2.name().getCStringAtOffset(0L, utModuleInfoPointer2.namelength().intValue());
            return string2 + "(" + string + ")";
        }
        return string;
    }

    private static void walkTraceComponents(ModuleVisitor moduleVisitor, UtComponentDataPointer utComponentDataPointer, Context context, PrintStream printStream) {
        try {
            for (UtComponentDataPointer utComponentDataPointer2 = utComponentDataPointer; utComponentDataPointer2 != null && utComponentDataPointer2.notNull(); utComponentDataPointer2 = utComponentDataPointer2.next()) {
                UtModuleInfoPointer utModuleInfoPointer = utComponentDataPointer2.moduleInfo();
                moduleVisitor.visit(utModuleInfoPointer);
            }
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    public static interface ModuleVisitor {
        public void visit(UtModuleInfoPointer var1) throws CorruptDataException;
    }
}

