/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMEntryLocalStoragePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class JitstackCommand
extends Command {
    public JitstackCommand() {
        this.addCommand("jitstack", "<thread>,<sp>,<pc>", "Dump jit stack");
        this.addCommand("jitstackslots", "<thread>,<sp>,<pc>", "Dump jit stack slots");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (!J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT) {
            CommandUtils.dbgPrint(printStream, "No JIT in this build\n");
            return;
        }
        try {
            String[] stringArray2 = null;
            if (stringArray.length != 0) {
                stringArray2 = stringArray[0].split(",");
            }
            if (stringArray.length == 0 || stringArray2.length != 3 && stringArray2.length != 4) {
                CommandUtils.dbgPrint(printStream, "Usage:\n");
                CommandUtils.dbgPrint(printStream, "\t!jitstack thread,sp,pc\n");
                CommandUtils.dbgPrint(printStream, "\t!jitstack thread,sp,pc,els\n");
                CommandUtils.dbgPrint(printStream, "\tUse !jitstackslots instead of !jitstack to see slot values\n");
                return;
            }
            long l = CommandUtils.parsePointer(stringArray2[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9VMThreadPointer j9VMThreadPointer = J9VMThreadPointer.cast(l);
            StackWalkerUtils.enableVerboseLogging(2, printStream);
            WalkState walkState = new WalkState();
            l = CommandUtils.parsePointer(stringArray2[1], J9BuildFlags.J9VM_ENV_DATA64);
            UDATAPointer uDATAPointer = UDATAPointer.cast(l);
            l = CommandUtils.parsePointer(stringArray2[2], J9BuildFlags.J9VM_ENV_DATA64);
            U8Pointer u8Pointer = U8Pointer.cast(l);
            UDATAPointer uDATAPointer2 = UDATAPointer.NULL;
            J9MethodPointer j9MethodPointer = J9MethodPointer.NULL;
            J9VMEntryLocalStoragePointer j9VMEntryLocalStoragePointer = J9VMEntryLocalStoragePointer.NULL;
            if (stringArray2.length == 4) {
                l = CommandUtils.parsePointer(stringArray2[3], J9BuildFlags.J9VM_ENV_DATA64);
                j9VMEntryLocalStoragePointer = J9VMEntryLocalStoragePointer.cast(l);
            } else {
                j9VMEntryLocalStoragePointer = j9VMThreadPointer.entryLocalStorage();
            }
            walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
            walkState.flags |= J9Consts.J9_STACKWALK_START_AT_JIT_FRAME;
            if (string.equalsIgnoreCase("!jitstackslots")) {
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
                StackWalkerUtils.enableVerboseLogging(100, printStream);
            }
            walkState.walkThread = j9VMThreadPointer;
            walkState.sp = uDATAPointer;
            walkState.arg0EA = uDATAPointer2;
            walkState.pc = u8Pointer;
            walkState.literals = j9MethodPointer;
            walkState.callBacks = new BaseStackWalkerCallbacks();
            walkState.frameFlags = new UDATA(0L);
            walkState.fillElsFields(j9VMEntryLocalStoragePointer);
            StackWalkResult stackWalkResult = StackWalker.walkStackFrames(walkState);
            if (stackWalkResult != StackWalkResult.NONE) {
                printStream.println("Stack walk result: " + (Object)((Object)stackWalkResult));
            }
            StackWalkerUtils.disableVerboseLogging();
            printStream.flush();
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

