/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9InitializerMethodsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMConstantDynamicRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMInterfaceMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStaticFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantDynamicRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMSingleSlotConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9DescriptionBits;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.structure.J9VmconstantpoolConstants;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashMap;

public class J9ConstantPoolCommand
extends Command {
    private static final HashMap<Long, String> cpTypeToString;
    private static final int J9_METHOD_INDEX_SHIFT;
    private static final int J9_METHOD_ARG_COUNT_MASK;
    private static final long J9VTABLE_INITIAL_VIRTUAL_OFFSET;

    public J9ConstantPoolCommand() {
        this.addCommand("constantpool", "<ramclass>", "dump constant pool for the given RAM class.");
    }

    public static boolean isSupported() {
        return 0L != J9VTABLE_INITIAL_VIRTUAL_OFFSET && 0L != J9Consts.J9_ITABLE_INDEX_METHOD_INDEX && 0L != J9Consts.J9_ITABLE_INDEX_OBJECT && 0L != J9Consts.J9_ITABLE_INDEX_SHIFT && 0L != J9Consts.J9_ITABLE_INDEX_TAG_BITS && 0L != J9Consts.J9_ITABLE_INDEX_UNRESOLVED && 0L != J9DescriptionBits.J9DescriptionCpBsmIndexMask && 0L != J9DescriptionBits.J9DescriptionCpTypeShift;
    }

    private static J9ClassPointer findClassByName(J9JavaVMPointer j9JavaVMPointer, String string) throws CorruptDataException {
        ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(j9JavaVMPointer.classMemorySegments());
        while (classSegmentIterator.hasNext()) {
            J9ClassPointer j9ClassPointer = (J9ClassPointer)classSegmentIterator.next();
            String string2 = J9ClassHelper.isArrayClass(j9ClassPointer) ? J9ClassHelper.getArrayName(j9ClassPointer) : J9ClassHelper.getName(j9ClassPointer);
            if (!string2.equals(string)) continue;
            return j9ClassPointer;
        }
        return null;
    }

    private static boolean sameNameAndSignature(J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer, J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer2) throws CorruptDataException {
        return J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()).equals(J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer2.name())) && J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()).equals(J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer2.signature()));
    }

    private static J9RAMClassRefPointer J9VMConstantPoolClassRefAt(J9JavaVMPointer j9JavaVMPointer, long l) throws CorruptDataException {
        J9RAMConstantPoolItemPointer j9RAMConstantPoolItemPointer = j9JavaVMPointer.jclConstantPoolEA();
        J9RAMClassRefPointer j9RAMClassRefPointer = J9RAMClassRefPointer.cast(j9RAMConstantPoolItemPointer.add(l));
        return j9RAMClassRefPointer;
    }

    private static PointerPointer getSpecialTable(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            String string = J9BuildFlags.J9VM_OPT_OPENJDK_METHODHANDLE ? "invokeCache" : "methodTypes";
            MethodHandle methodHandle = lookup.findVirtual(J9ClassPointer.class, string, MethodType.methodType(PointerPointer.class));
            return methodHandle.invoke(j9ClassPointer);
        }
        catch (CorruptDataException corruptDataException) {
            throw corruptDataException;
        }
        catch (Throwable throwable) {
            throw new CorruptDataException(throwable);
        }
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9InitializerMethodsPointer j9InitializerMethodsPointer = j9JavaVMPointer.initialMethods();
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.J9VM_ENV_DATA64);
            J9ClassPointer j9ClassPointer = J9ClassPointer.cast(l);
            J9ROMClassPointer j9ROMClassPointer = j9ClassPointer.romClass();
            int n = j9ROMClassPointer.romConstantPoolCount().intValue();
            int n2 = j9ROMClassPointer.ramConstantPoolCount().intValue();
            J9ConstantPoolPointer j9ConstantPoolPointer = J9ConstantPoolPointer.cast(j9ClassPointer.ramConstantPool());
            J9RAMConstantPoolItemPointer j9RAMConstantPoolItemPointer = J9RAMConstantPoolItemPointer.cast(j9ConstantPoolPointer);
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = j9ConstantPoolPointer.romConstantPool();
            J9RAMConstantPoolItemPointer j9RAMConstantPoolItemPointer2 = J9RAMConstantPoolItemPointer.cast(j9ConstantPoolPointer);
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer2 = j9ConstantPoolPointer.romConstantPool();
            U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
            CommandUtils.dbgPrint(printStream, String.format("%-8s%-50s%-50s%-20s%s%n", "Index", "ROM", "RAM", "Type", "Value"));
            for (int i = 1; i < n; ++i) {
                AbstractPointer abstractPointer;
                Object object;
                String string2;
                StructurePointer structurePointer;
                j9RAMConstantPoolItemPointer2 = j9RAMConstantPoolItemPointer2.add(1L);
                j9ROMConstantPoolItemPointer2 = j9ROMConstantPoolItemPointer2.add(1L);
                long l2 = ConstantPoolHelpers.J9_CP_TYPE(u32Pointer, i);
                String string3 = "";
                String string4 = "";
                if (l2 == J9ConstantPool.J9CPTYPE_CLASS) {
                    structurePointer = J9RAMClassRefPointer.cast(j9RAMConstantPoolItemPointer2).value();
                    String string5 = J9UTF8Helper.stringValue(J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer2).name());
                    if (structurePointer.notNull() && i < n2) {
                        if (J9ClassHelper.isArrayClass((J9ClassPointer)structurePointer)) {
                            string3 = "!j9arrayclass " + structurePointer.getHexAddress();
                            string4 = "!j9romarrayclass " + ((J9ClassPointer)structurePointer).romClass().getHexAddress();
                        } else {
                            string3 = "!j9class " + structurePointer.getHexAddress();
                            string4 = "!j9romclass " + ((J9ClassPointer)structurePointer).romClass().getHexAddress();
                        }
                    } else {
                        J9ClassPointer j9ClassPointer2;
                        if (i < n2 && structurePointer.isNull()) {
                            string3 = "(unresolved)";
                        }
                        string4 = (j9ClassPointer2 = J9ConstantPoolCommand.findClassByName(j9JavaVMPointer, string5)) == null ? "(unresolved)" : (J9ClassHelper.isArrayClass(j9ClassPointer2) ? "!j9romarrayclass " + j9ClassPointer2.romClass().getHexAddress() : "!j9romclass " + j9ClassPointer2.romClass().getHexAddress());
                    }
                    string2 = string5;
                } else if (l2 == J9ConstantPool.J9CPTYPE_STRING) {
                    string4 = "!j9utf8 " + J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2).utf8Data().getHexAddress();
                    if (i < n2) {
                        structurePointer = J9RAMStringRefPointer.cast(j9RAMConstantPoolItemPointer2).stringObject();
                        string3 = structurePointer.notNull() ? "!j9object " + structurePointer.getHexAddress() : "(unresolved)";
                    }
                    string2 = J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2).utf8Data());
                } else if (l2 == J9ConstantPool.J9CPTYPE_INT) {
                    structurePointer = J9ROMSingleSlotConstantRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    string4 = "!J9ROMSingleSlotConstantRef " + ((J9ROMSingleSlotConstantRefPointer)structurePointer).dataEA().getHexAddress();
                    if (i < n2) {
                        string3 = "!J9RAMSingleSlotConstantRef " + j9RAMConstantPoolItemPointer2.getHexAddress();
                    }
                    string2 = Long.toString(((J9ROMSingleSlotConstantRefPointer)structurePointer).data().longValue());
                } else if (l2 == J9ConstantPool.J9CPTYPE_FLOAT) {
                    structurePointer = J9ROMSingleSlotConstantRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    string4 = "!J9ROMSingleSlotConstantRef " + structurePointer.getHexAddress();
                    if (i < n2) {
                        string3 = "!J9RAMSingleSlotConstantRef " + j9RAMConstantPoolItemPointer2.getHexAddress();
                    }
                    string2 = Float.toString(Float.intBitsToFloat((int)((J9ROMSingleSlotConstantRefPointer)structurePointer).data().longValue()));
                } else if (l2 == J9ConstantPool.J9CPTYPE_LONG) {
                    string4 = "!j9romconstantref " + j9ROMConstantPoolItemPointer2.getHexAddress();
                    string2 = Long.toString(I64Pointer.cast(j9ROMConstantPoolItemPointer2).at(0L).longValue());
                } else if (l2 == J9ConstantPool.J9CPTYPE_DOUBLE) {
                    string4 = "!j9romconstantref " + j9ROMConstantPoolItemPointer2.getHexAddress();
                    string2 = Double.toString(Double.longBitsToDouble(I64Pointer.cast(j9ROMConstantPoolItemPointer2).at(0L).longValue()));
                } else if (l2 == J9ConstantPool.J9CPTYPE_FIELD) {
                    if (i < n2) {
                        structurePointer = J9RAMStaticFieldRefPointer.cast(j9RAMConstantPoolItemPointer2);
                        J9RAMFieldRefPointer j9RAMFieldRefPointer = J9RAMFieldRefPointer.cast(j9RAMConstantPoolItemPointer2);
                        string3 = ((J9RAMStaticFieldRefPointer)structurePointer).flagsAndClass().longValue() > 0L && !((J9RAMStaticFieldRefPointer)structurePointer).valueOffset().eq(UDATA.MAX) ? ((J9RAMStaticFieldRefPointer)structurePointer).valueOffset().getHexValue() + " (static offset)" : (j9RAMFieldRefPointer.flags().gt(j9RAMFieldRefPointer.valueOffset()) ? j9RAMFieldRefPointer.valueOffset().getHexValue() + " (instance offset)" : "(unresolved)");
                    }
                    structurePointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    string4 = "#" + Long.toString(((J9ROMFieldRefPointer)structurePointer).classRefCPIndex().longValue());
                    J9ROMClassRefPointer j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(((J9ROMFieldRefPointer)structurePointer).classRefCPIndex()));
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMFieldRefPointer)structurePointer).nameAndSignature();
                    string2 = String.format("%s.%s:%s #%d", J9UTF8Helper.stringValue(j9ROMClassRefPointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()), ((J9ROMFieldRefPointer)structurePointer).classRefCPIndex().intValue());
                } else if (l2 == J9ConstantPool.J9CPTYPE_STATIC_METHOD || l2 == J9ConstantPool.J9CPTYPE_INTERFACE_STATIC_METHOD || l2 == J9ConstantPool.J9CPTYPE_INTERFACE_INSTANCE_METHOD || l2 == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD) {
                    StructurePointer structurePointer2;
                    structurePointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    J9ROMClassRefPointer j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(((J9ROMMethodRefPointer)structurePointer).classRefCPIndex()));
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMMethodRefPointer)structurePointer).nameAndSignature();
                    object = J9UTF8Helper.stringValue(j9ROMClassRefPointer.name());
                    boolean bl = false;
                    if (i < n2) {
                        J9ClassPointer j9ClassPointer3;
                        abstractPointer = J9RAMMethodRefPointer.cast(j9RAMConstantPoolItemPointer2);
                        structurePointer2 = J9RAMMethodRefPointer.cast(j9RAMConstantPoolItemPointer2).method();
                        long l3 = ((J9RAMMethodRefPointer)abstractPointer).methodIndexAndArgCount().rightShift(J9_METHOD_INDEX_SHIFT).longValue();
                        boolean bl2 = true;
                        if (l2 == J9ConstantPool.J9CPTYPE_STATIC_METHOD || l2 == J9ConstantPool.J9CPTYPE_INTERFACE_STATIC_METHOD) {
                            if (l3 != J9VTABLE_INITIAL_VIRTUAL_OFFSET || structurePointer2.getAddress() != j9InitializerMethodsPointer.initialStaticMethod().getAddress()) {
                                bl2 = false;
                            }
                        } else if (structurePointer2.getAddress() != j9InitializerMethodsPointer.initialSpecialMethod().getAddress()) {
                            bl2 = false;
                        } else if (l3 != J9VTABLE_INITIAL_VIRTUAL_OFFSET && (j9ClassPointer3 = J9RAMClassRefPointer.cast(j9RAMConstantPoolItemPointer.add(((J9ROMMethodRefPointer)structurePointer).classRefCPIndex())).value()).notNull()) {
                            long l4 = PointerPointer.cast(j9ClassPointer3).addOffset(l3).at(0L).getAddress();
                            J9MethodPointer j9MethodPointer = J9MethodPointer.cast(l4);
                            string3 = "!j9method " + j9MethodPointer.getHexAddress();
                            string4 = "!j9rommethod " + ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer).getHexAddress();
                            bl = true;
                        }
                        if (!bl2) {
                            string3 = "!j9method " + structurePointer2.getHexAddress();
                            string4 = "!j9rommethod " + ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD((J9MethodPointer)structurePointer2).getHexAddress();
                            bl = true;
                        }
                    }
                    if (!bl) {
                        if (i < n2) {
                            string3 = "(unresolved)";
                        }
                        if ((abstractPointer = J9ConstantPoolCommand.findClassByName(j9JavaVMPointer, (String)object)) != null) {
                            structurePointer2 = ((J9ClassPointer)abstractPointer).romClass();
                            J9ROMMethodPointer j9ROMMethodPointer = ((J9ROMClassPointer)structurePointer2).romMethods();
                            for (int j = ((J9ROMClassPointer)structurePointer2).romMethodCount().intValue(); j > 0; --j) {
                                if (J9ConstantPoolCommand.sameNameAndSignature(j9ROMMethodPointer.nameAndSignature(), j9ROMNameAndSignaturePointer)) {
                                    string4 = "!j9rommethod " + j9ROMMethodPointer.getHexAddress();
                                    break;
                                }
                                j9ROMMethodPointer = ROMHelp.nextROMMethod(j9ROMMethodPointer);
                            }
                        }
                    }
                    string2 = String.format("%s.%s:%s #%d", object, J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()), ((J9ROMMethodRefPointer)structurePointer).classRefCPIndex().intValue());
                } else if (l2 == J9ConstantPool.J9CPTYPE_HANDLE_METHOD) {
                    structurePointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    if (i < n2) {
                        J9RAMMethodRefPointer j9RAMMethodRefPointer = J9RAMMethodRefPointer.cast(j9RAMConstantPoolItemPointer2);
                        long l5 = j9RAMMethodRefPointer.methodIndexAndArgCount().rightShift(J9_METHOD_INDEX_SHIFT).longValue();
                        PointerPointer pointerPointer = J9ConstantPoolCommand.getSpecialTable(j9ClassPointer).add(l5);
                        string3 = pointerPointer.isNull() ? "(unresolved)" : "!j9object " + pointerPointer.getHexValue();
                    }
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMMethodRefPointer)structurePointer).nameAndSignature();
                    string4 = "!j9romnameandsignature " + j9ROMNameAndSignaturePointer.getHexAddress();
                    string2 = J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()) + ":" + J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature());
                } else if (l2 == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD) {
                    structurePointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    J9ROMClassRefPointer j9ROMClassRefPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(((J9ROMMethodRefPointer)structurePointer).classRefCPIndex()));
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMMethodRefPointer)structurePointer).nameAndSignature();
                    object = J9UTF8Helper.stringValue(j9ROMClassRefPointer.name());
                    if (i < n2) {
                        J9RAMInterfaceMethodRefPointer j9RAMInterfaceMethodRefPointer = J9RAMInterfaceMethodRefPointer.cast(j9RAMConstantPoolItemPointer2);
                        abstractPointer = J9ClassPointer.cast(j9RAMInterfaceMethodRefPointer.interfaceClass());
                        UDATA uDATA = j9RAMInterfaceMethodRefPointer.methodIndexAndArgCount();
                        if (abstractPointer.notNull() && J9Consts.J9_ITABLE_INDEX_UNRESOLVED != uDATA.bitAnd(J9_METHOD_ARG_COUNT_MASK).longValue()) {
                            UDATA uDATA2 = uDATA.rightShift((int)J9Consts.J9_ITABLE_INDEX_SHIFT);
                            if (uDATA.anyBitsIn(J9Consts.J9_ITABLE_INDEX_TAG_BITS)) {
                                if (uDATA.anyBitsIn(J9Consts.J9_ITABLE_INDEX_METHOD_INDEX)) {
                                    AbstractPointer abstractPointer2 = uDATA.anyBitsIn(J9Consts.J9_ITABLE_INDEX_OBJECT) ? J9ConstantPoolCommand.J9VMConstantPoolClassRefAt(j9JavaVMPointer, J9VmconstantpoolConstants.J9VMCONSTANTPOOL_JAVALANGOBJECT).value() : abstractPointer;
                                    J9MethodPointer j9MethodPointer = ((J9ClassPointer)abstractPointer2).ramMethods().add(uDATA2);
                                    string3 = "!j9method " + j9MethodPointer.getHexAddress();
                                    string4 = "!j9rommethod " + ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(j9MethodPointer).getHexAddress();
                                } else {
                                    string3 = "VTableOffset: " + uDATA2.longValue();
                                }
                            } else {
                                string3 = "ITable Index: " + uDATA2.longValue();
                            }
                        } else {
                            string3 = "(unresolved)";
                        }
                    }
                    string2 = String.format("%s.%s:%s #%d", object, J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()), ((J9ROMMethodRefPointer)structurePointer).classRefCPIndex().intValue());
                } else if (l2 == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                    if (i < n2) {
                        string3 = "!j9object " + J9RAMMethodTypeRefPointer.cast(j9RAMConstantPoolItemPointer2).type().getHexAddress();
                    }
                    structurePointer = J9ROMMethodTypeRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    string4 = "!j9utf8 " + ((J9ROMMethodTypeRefPointer)structurePointer).signature().getHexAddress();
                    string2 = J9UTF8Helper.stringValue(((J9ROMMethodTypeRefPointer)structurePointer).signature());
                } else if (l2 == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                    if (i < n2) {
                        structurePointer = J9RAMMethodHandleRefPointer.cast(j9RAMConstantPoolItemPointer2).methodHandle();
                        string3 = structurePointer.notNull() ? "!j9object " + structurePointer.getHexAddress() : "(unresolved)";
                    }
                    structurePointer = J9ROMMethodHandleRefPointer.cast(j9ROMConstantPoolItemPointer2);
                    long l6 = ((J9ROMMethodHandleRefPointer)structurePointer).methodOrFieldRefIndex().longValue();
                    object = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(l6));
                    J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMMethodRefPointer)object).nameAndSignature();
                    string4 = ((AbstractPointer)object).getHexValue();
                    abstractPointer = J9ROMClassRefPointer.cast(j9ROMConstantPoolItemPointer.add(((J9ROMMethodRefPointer)object).classRefCPIndex()));
                    string2 = String.format("%s.%s:%s #%s", J9UTF8Helper.stringValue(((J9ROMClassRefPointer)abstractPointer).name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()), l6);
                } else if (l2 == J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8) {
                    string4 = "!j9utf8 " + J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2).utf8Data().getHexAddress();
                    if (i < n2) {
                        structurePointer = J9RAMStringRefPointer.cast(j9RAMConstantPoolItemPointer2).stringObject();
                        string3 = structurePointer.notNull() ? "!j9object " + structurePointer.getHexAddress() : "(unresolved)";
                    }
                    string2 = J9UTF8Helper.stringValue(J9ROMStringRefPointer.cast(j9ROMConstantPoolItemPointer2).utf8Data());
                } else if (l2 == J9ConstantPool.J9CPTYPE_CONSTANT_DYNAMIC) {
                    try {
                        long l7;
                        if (i < n2) {
                            structurePointer = J9RAMConstantDynamicRefPointer.cast(j9RAMConstantPoolItemPointer2);
                            if (((J9RAMConstantDynamicRefPointer)structurePointer).value().notNull()) {
                                string3 = "!j9object " + ((J9RAMConstantDynamicRefPointer)structurePointer).value().getHexAddress() + " (resolved)";
                            } else {
                                J9ObjectPointer j9ObjectPointer = ((J9RAMConstantDynamicRefPointer)structurePointer).exception();
                                if (j9ObjectPointer.notNull()) {
                                    J9ClassPointer j9ClassPointer4 = J9ObjectHelper.clazz(j9ObjectPointer);
                                    object = J9ConstantPoolCommand.J9VMConstantPoolClassRefAt(j9JavaVMPointer, J9VmconstantpoolConstants.J9VMCONSTANTPOOL_JAVALANGTHROWABLE).value();
                                    string3 = j9ObjectPointer.getAddress() == j9JavaVMPointer.voidReflectClass().classObject().getAddress() ? "NULL (resolved)" : (J9ClassHelper.isSameOrSuperClassOf((J9ClassPointer)object, j9ClassPointer4) ? "!j9object " + j9ObjectPointer.getHexAddress() + " (exception)" : "!j9object " + j9ObjectPointer.getHexAddress() + " (resolving Thread)");
                                } else {
                                    string3 = "(unresolved)";
                                }
                            }
                        }
                        structurePointer = J9ROMConstantDynamicRefPointer.cast(j9ROMConstantPoolItemPointer2);
                        SelfRelativePointer selfRelativePointer = SelfRelativePointer.cast(j9ROMClassPointer.callSiteData());
                        long l8 = j9ROMClassPointer.callSiteCount().longValue();
                        U16Pointer u16Pointer = U16Pointer.cast(selfRelativePointer.addOffset(4L * l8));
                        abstractPointer = u16Pointer.add(l8);
                        long l9 = ((J9ROMConstantDynamicRefPointer)structurePointer).bsmIndexAndCpType().rightShift((int)J9DescriptionBits.J9DescriptionCpTypeShift).bitAnd(J9DescriptionBits.J9DescriptionCpBsmIndexMask).longValue();
                        for (l7 = 0L; l7 < l9; ++l7) {
                            long l10 = ((U16Pointer)abstractPointer).at(1L).longValue();
                            abstractPointer = ((U16Pointer)abstractPointer).add(l10 + 2L);
                        }
                        long l11 = ((U16Pointer)abstractPointer).at(1L).longValue();
                        l7 = ((U16Pointer)abstractPointer).at(0L).longValue();
                        string4 = "#" + l7;
                        J9ROMNameAndSignaturePointer j9ROMNameAndSignaturePointer = ((J9ROMConstantDynamicRefPointer)structurePointer).nameAndSignature();
                        string2 = String.format("%s:%s #%d(", J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.name()), J9UTF8Helper.stringValue(j9ROMNameAndSignaturePointer.signature()), l7);
                        for (long j = 1L; j <= l11; ++j) {
                            string2 = string2 + "#" + ((U16Pointer)abstractPointer).add(1L + j).at(0L).longValue();
                            if (j >= l11) continue;
                            string2 = string2 + ", ";
                        }
                        string2 = string2 + ")";
                    }
                    catch (NoClassDefFoundError | NoSuchFieldException throwable) {
                        throw new CorruptDataException(throwable);
                    }
                } else {
                    throw new CorruptDataException("Incorrect or unsupported constant pool entry type");
                }
                CommandUtils.dbgPrint(printStream, String.format("%-8d%-50s%-50s%-20s%s%n", i, string4, string3, cpTypeToString.getOrDefault(l2, "Incorrect or unsupported type"), string2));
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    static {
        long l;
        cpTypeToString = new HashMap();
        J9_METHOD_INDEX_SHIFT = Long.numberOfTrailingZeros(J9Consts.J9_ITABLE_INDEX_METHOD_INDEX);
        J9_METHOD_ARG_COUNT_MASK = (1 << J9_METHOD_INDEX_SHIFT) - 1;
        try {
            l = J9Class.SIZEOF + (long)J9VTableHeader._initialVirtualMethodOffset_;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            l = 0L;
        }
        J9VTABLE_INITIAL_VIRTUAL_OFFSET = l;
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_CLASS, "Class");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_STRING, "String");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_INT, "int");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_FLOAT, "float");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_LONG, "long");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_DOUBLE, "double");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_FIELD, "Fieldref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_INSTANCE_METHOD, "Methodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_STATIC_METHOD, "Methodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_INTERFACE_STATIC_METHOD, "Methodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_INTERFACE_INSTANCE_METHOD, "Methodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_HANDLE_METHOD, "HandleMethodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_INTERFACE_METHOD, "InterfaceMethodref");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_METHOD_TYPE, "MethodType");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_METHODHANDLE, "MethodHandle");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8, "UTF8");
        cpTypeToString.put(J9ConstantPool.J9CPTYPE_CONSTANT_DYNAMIC, "ConstantDynamic");
    }
}

