/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.SystemProcessEntry;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=SystemProcessEntry.class)
public class SystemProcessEntryPointer
extends StructurePointer {
    public static final SystemProcessEntryPointer NULL = new SystemProcessEntryPointer(0L);

    protected SystemProcessEntryPointer(long l) {
        super(l);
    }

    public static SystemProcessEntryPointer cast(AbstractPointer abstractPointer) {
        return SystemProcessEntryPointer.cast(abstractPointer.getAddress());
    }

    public static SystemProcessEntryPointer cast(UDATA uDATA) {
        return SystemProcessEntryPointer.cast(uDATA.longValue());
    }

    public static SystemProcessEntryPointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new SystemProcessEntryPointer(l);
    }

    @Override
    public SystemProcessEntryPointer add(long l) {
        return SystemProcessEntryPointer.cast(this.address + SystemProcessEntry.SIZEOF * l);
    }

    @Override
    public SystemProcessEntryPointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public SystemProcessEntryPointer addOffset(long l) {
        return SystemProcessEntryPointer.cast(this.address + l);
    }

    @Override
    public SystemProcessEntryPointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public SystemProcessEntryPointer sub(long l) {
        return SystemProcessEntryPointer.cast(this.address - SystemProcessEntry.SIZEOF * l);
    }

    @Override
    public SystemProcessEntryPointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public SystemProcessEntryPointer subOffset(long l) {
        return SystemProcessEntryPointer.cast(this.address - l);
    }

    @Override
    public SystemProcessEntryPointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public SystemProcessEntryPointer untag(long l) {
        return SystemProcessEntryPointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public SystemProcessEntryPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return SystemProcessEntry.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_commandLineOffset_", declaredType="U8*")
    public U8Pointer commandLine() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(SystemProcessEntry._commandLineOffset_));
    }

    public PointerPointer commandLineEA() throws CorruptDataException {
        return PointerPointer.cast(this.nonNullFieldEA(SystemProcessEntry._commandLineOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_pidOffset_", declaredType="UDATA")
    public UDATA pid() throws CorruptDataException {
        return this.getUDATAAtOffset(SystemProcessEntry._pidOffset_);
    }

    public UDATAPointer pidEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(SystemProcessEntry._pidOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
    public IDATA ticks() throws CorruptDataException {
        return new I64(this.getLongAtOffset(SystemProcessEntry._ticksOffset_));
    }

    public IDATAPointer ticksEA() throws CorruptDataException {
        return IDATAPointer.cast(this.nonNullFieldEA(SystemProcessEntry._ticksOffset_));
    }
}

