/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.EnumPointer;
import com.ibm.j9ddr.vm29.pointer.IDATAPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.FrameType;
import com.ibm.j9ddr.vm29.structure.StackFrame;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=StackFrame.class)
public class StackFramePointer
extends StructurePointer {
    public static final StackFramePointer NULL = new StackFramePointer(0L);

    protected StackFramePointer(long l) {
        super(l);
    }

    public static StackFramePointer cast(AbstractPointer abstractPointer) {
        return StackFramePointer.cast(abstractPointer.getAddress());
    }

    public static StackFramePointer cast(UDATA uDATA) {
        return StackFramePointer.cast(uDATA.longValue());
    }

    public static StackFramePointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new StackFramePointer(l);
    }

    @Override
    public StackFramePointer add(long l) {
        return StackFramePointer.cast(this.address + StackFrame.SIZEOF * l);
    }

    @Override
    public StackFramePointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public StackFramePointer addOffset(long l) {
        return StackFramePointer.cast(this.address + l);
    }

    @Override
    public StackFramePointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public StackFramePointer sub(long l) {
        return StackFramePointer.cast(this.address - StackFrame.SIZEOF * l);
    }

    @Override
    public StackFramePointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public StackFramePointer subOffset(long l) {
        return StackFramePointer.cast(this.address - l);
    }

    @Override
    public StackFramePointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public StackFramePointer untag(long l) {
        return StackFramePointer.cast(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public StackFramePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return StackFrame.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_bytecodeIndexOffset_", declaredType="I32")
    public IDATA bytecodeIndex() throws CorruptDataException {
        return new I32(this.getIntAtOffset(StackFrame._bytecodeIndexOffset_));
    }

    public IDATAPointer bytecodeIndexEA() throws CorruptDataException {
        return IDATAPointer.cast(this.nonNullFieldEA(StackFrame._bytecodeIndexOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_frameTypeOffset_", declaredType="FrameType")
    public long frameType() throws CorruptDataException {
        if (FrameType.SIZEOF == 1L) {
            return this.getByteAtOffset(StackFrame._frameTypeOffset_);
        }
        if (FrameType.SIZEOF == 2L) {
            return this.getShortAtOffset(StackFrame._frameTypeOffset_);
        }
        if (FrameType.SIZEOF == 4L) {
            return this.getIntAtOffset(StackFrame._frameTypeOffset_);
        }
        if (FrameType.SIZEOF == 8L) {
            return this.getLongAtOffset(StackFrame._frameTypeOffset_);
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    public EnumPointer frameTypeEA() throws CorruptDataException {
        return EnumPointer.cast(this.nonNullFieldEA(StackFrame._frameTypeOffset_), FrameType.class);
    }

    @GeneratedFieldAccessor(offsetFieldName="_lineNumberOffset_", declaredType="I32")
    public IDATA lineNumber() throws CorruptDataException {
        return new I32(this.getIntAtOffset(StackFrame._lineNumberOffset_));
    }

    public IDATAPointer lineNumberEA() throws CorruptDataException {
        return IDATAPointer.cast(this.nonNullFieldEA(StackFrame._lineNumberOffset_));
    }

    @GeneratedFieldAccessor(offsetFieldName="_methodIndexOffset_", declaredType="U32")
    public UDATA methodIndex() throws CorruptDataException {
        return new U32(this.getIntAtOffset(StackFrame._methodIndexOffset_));
    }

    public UDATAPointer methodIndexEA() throws CorruptDataException {
        return UDATAPointer.cast(this.nonNullFieldEA(StackFrame._methodIndexOffset_));
    }
}

