/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolSplitAddressOrderedList;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

class GCFreeListHeapIteratorSplitAddressOrderedList
extends GCFreeListHeapIterator {
    protected UDATA _freeListIndex = new UDATA(0L);
    protected GCMemoryPoolSplitAddressOrderedList _memoryPool = null;
    protected GCHeapLinkedFreeHeader _currentFreeEntry = null;
    protected UDATA _totalListCount = null;

    public GCFreeListHeapIteratorSplitAddressOrderedList(GCMemoryPoolSplitAddressOrderedList gCMemoryPoolSplitAddressOrderedList) throws CorruptDataException {
        this._memoryPool = gCMemoryPoolSplitAddressOrderedList;
        this._totalListCount = this._memoryPool.getFreeListCount();
        this.advanceFreeListEntry();
    }

    private void advanceFreeListEntry() {
        try {
            if (this._currentFreeEntry != null) {
                if (this._currentFreeEntry.getNext().getHeader().notNull()) {
                    this._currentFreeEntry = this._currentFreeEntry.getNext();
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            while (this._freeListIndex.lt(this._totalListCount)) {
                this._currentFreeEntry = this._memoryPool.getFirstEntryAtFreeListIndex(this._freeListIndex);
                if (this._currentFreeEntry.getHeader().notNull()) {
                    return;
                }
                this._freeListIndex = this._freeListIndex.add(1L);
            }
            this._currentFreeEntry = null;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Freelist corruption detected", corruptDataException, false);
            this._currentFreeEntry = null;
        }
    }

    @Override
    public boolean hasNext() {
        return null != this._currentFreeEntry;
    }

    @Override
    public GCHeapLinkedFreeHeader next() throws NoSuchElementException {
        if (this.hasNext()) {
            GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = this._currentFreeEntry;
            this.advanceFreeListEntry();
            return gCHeapLinkedFreeHeader;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public int getFreeListNumber() {
        return this._freeListIndex.intValue();
    }

    @Override
    public String toString() {
        GCFreeListHeapIteratorSplitAddressOrderedList gCFreeListHeapIteratorSplitAddressOrderedList = null;
        try {
            gCFreeListHeapIteratorSplitAddressOrderedList = new GCFreeListHeapIteratorSplitAddressOrderedList(this._memoryPool);
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCFreeListHeapIteratorSplitAddressOrderedList.hasNext()) {
            stringBuilder.append(gCFreeListHeapIteratorSplitAddressOrderedList.next() + string);
        }
        return stringBuilder.toString();
    }
}

