/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class BuildVersionCommand
extends LoadCommand {
    int platform;
    int minOs;
    int sdk;
    int numTools;
    Version minOsVersion;
    Version sdkVersion;
    List<BuildToolVersion> tools;

    @Override
    public BuildVersionCommand readCommand(ImageInputStream imageInputStream, long l) throws IOException {
        super.readCommand(imageInputStream, l);
        this.platform = imageInputStream.readInt();
        this.minOs = imageInputStream.readInt();
        this.sdk = imageInputStream.readInt();
        this.numTools = imageInputStream.readInt();
        this.minOsVersion = new Version(this.minOs);
        this.sdkVersion = new Version(this.sdk);
        this.tools = new ArrayList<BuildToolVersion>(this.numTools);
        for (int i = 0; i < this.numTools; ++i) {
            this.tools.add(new BuildToolVersion(imageInputStream));
        }
        return this;
    }

    public static class BuildToolVersion {
        public static final int TOOL_CLANG = 1;
        public static final int TOOL_SWIFT = 2;
        public static final int TOOL_LD = 3;
        final int toolType;
        final int version;

        BuildToolVersion(ImageInputStream imageInputStream) throws IOException {
            this.toolType = imageInputStream.readInt();
            this.version = imageInputStream.readInt();
        }
    }

    public static class Version {
        final int major;
        final int minor;
        final int patch;

        public Version(int n) {
            this.major = n >>> 16;
            this.minor = n >>> 8 & 0xFF;
            this.patch = n & 0xFF;
        }
    }
}

