/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.HelperBase;
import com.ibm.j9ddr.PrimitiveAccessor;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;

final class PointerHelper
extends HelperBase {
    private static final Pattern ConstPattern = Pattern.compile("\\s*\\bconst\\s+");
    private static final Set<String> predefinedDataTypes;
    private static final Set<String> predefinedPointerTypes;
    private static final Pattern TypeTagPattern;
    private final String basePrefix;
    private final String className;
    private final StructureReader reader;
    private final StructureReader.StructureDescriptor structure;
    private final StructureTypeManager typeManager;
    private final Type abstractPointerType;
    private final Type classType;
    private final ClassWriter clazz;
    private final String[] normalThrows;
    private final String[] optionalThrows;
    private final Type scalarType;
    private final Type udataType;

    private static Set<String> addNames(Set<String> set, String string) {
        set.addAll(Arrays.asList(string.split(" ")));
        return set;
    }

    private static boolean checkPresent(StructureReader.FieldDescriptor fieldDescriptor, MethodVisitor methodVisitor) {
        if (fieldDescriptor.isPresent()) {
            return true;
        }
        String string = "java/lang/NoSuchFieldException";
        methodVisitor.visitTypeInsn(187, string);
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, string, "<init>", "()V", false);
        methodVisitor.visitInsn(191);
        return false;
    }

    private static String generalizeSimpleType(String string) {
        if ("I32".equals(string) || "I64".equals(string)) {
            return "IDATA";
        }
        if ("U32".equals(string) || "U64".equals(string)) {
            return "UDATA";
        }
        return string;
    }

    static byte[] getClassBytes(StructureReader structureReader, StructureTypeManager structureTypeManager, StructureReader.StructureDescriptor structureDescriptor, String string) {
        PointerHelper pointerHelper = new PointerHelper(structureReader, structureTypeManager, structureDescriptor, string);
        return pointerHelper.generate();
    }

    private static String getEnumType(String string) {
        int n = string.startsWith("enum ") ? 5 : 0;
        int n2 = string.length();
        if (string.endsWith("[]")) {
            n2 -= 2;
        }
        return string.substring(n, n2);
    }

    private static String getTargetType(String string) {
        int n;
        String string2 = ConstPattern.matcher(string).replaceAll("").trim();
        if (string2.indexOf(42, (n = string2.indexOf(42)) + 1) > 0) {
            return "Pointer";
        }
        if ((string2 = string2.substring(0, n).trim()).equals("bool")) {
            return "Bool";
        }
        if (string2.equals("double")) {
            return "Double";
        }
        if (string2.equals("float")) {
            return "Float";
        }
        if (string2.equals("void")) {
            return "Void";
        }
        return string2;
    }

    private static String removeTypeTags(String string) {
        return TypeTagPattern.matcher(string).replaceAll("").trim();
    }

    private PointerHelper(StructureReader structureReader, StructureTypeManager structureTypeManager, StructureReader.StructureDescriptor structureDescriptor, String string) {
        String string2;
        int n = string.indexOf("/pointer/generated/");
        if (n <= 0) {
            throw new IllegalArgumentException(string);
        }
        this.basePrefix = string2 = string.substring(0, n + 1);
        this.className = string;
        this.reader = structureReader;
        this.structure = structureDescriptor;
        this.typeManager = structureTypeManager;
        this.abstractPointerType = Type.getObjectType(string2 + "pointer/AbstractPointer");
        this.classType = Type.getObjectType(string);
        this.clazz = new ClassWriter(0);
        this.normalThrows = new String[]{"com/ibm/j9ddr/CorruptDataException"};
        this.optionalThrows = new String[]{"com/ibm/j9ddr/CorruptDataException", "java/lang/NoSuchFieldException"};
        this.scalarType = Type.getObjectType(string2 + "types/Scalar");
        this.udataType = Type.getObjectType(string2 + "types/UDATA");
    }

    private MethodVisitor beginAnnotatedMethod(StructureReader.FieldDescriptor fieldDescriptor, String string, String string2) {
        MethodVisitor methodVisitor = this.beginMethod(fieldDescriptor, string, string2);
        if (fieldDescriptor.isPresent()) {
            Type type2 = Type.getObjectType("com/ibm/j9ddr/GeneratedFieldAccessor");
            AnnotationVisitor annotationVisitor = methodVisitor.visitAnnotation(type2.getDescriptor(), true);
            annotationVisitor.visit("offsetFieldName", String.format("_%sOffset_", fieldDescriptor.getName()));
            annotationVisitor.visit("declaredType", fieldDescriptor.getDeclaredType());
            annotationVisitor.visitEnd();
        }
        return methodVisitor;
    }

    private MethodVisitor beginMethod(StructureReader.FieldDescriptor fieldDescriptor, String string, String string2) {
        String[] stringArray = fieldDescriptor.isOptional() ? this.optionalThrows : this.normalThrows;
        return this.clazz.visitMethod(1, string, string2, null, stringArray);
    }

    private void doAccessorMethods() {
        block23: for (StructureReader.FieldDescriptor fieldDescriptor : this.structure.getFields()) {
            String string = fieldDescriptor.getName();
            if (string.isEmpty() || string.indexOf(35) >= 0) continue;
            String string2 = fieldDescriptor.getType();
            int n = this.typeManager.getType(string2);
            switch (n) {
                case 120: {
                    this.doStructureMethod(fieldDescriptor);
                    continue block23;
                }
                case 121: {
                    this.doStructurePointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 110: {
                    this.doPointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 113: {
                    this.doArrayMethod(fieldDescriptor);
                    continue block23;
                }
                case 111: {
                    this.doSRPMethod(fieldDescriptor, false);
                    continue block23;
                }
                case 112: {
                    this.doSRPMethod(fieldDescriptor, true);
                    continue block23;
                }
                case 114: {
                    this.doSRPPointerMethod(fieldDescriptor, false);
                    continue block23;
                }
                case 115: {
                    this.doSRPPointerMethod(fieldDescriptor, true);
                    continue block23;
                }
                case 130: {
                    this.doFJ9ObjectMethod(fieldDescriptor);
                    continue block23;
                }
                case 131: {
                    this.doFJ9ObjectPointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 132: {
                    this.doJ9ObjectClassMethod(fieldDescriptor);
                    continue block23;
                }
                case 133: {
                    this.doJ9ObjectClassPointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 134: {
                    this.doJ9ObjectMonitorMethod(fieldDescriptor);
                    continue block23;
                }
                case 135: {
                    this.doJ9ObjectMonitorPointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 0: {
                    this.doStructureMethod(fieldDescriptor);
                    continue block23;
                }
                case 100: {
                    this.doBooleanMethod(fieldDescriptor);
                    continue block23;
                }
                case 102: {
                    this.doDoubleMethod(fieldDescriptor);
                    continue block23;
                }
                case 103: {
                    this.doFloatMethod(fieldDescriptor);
                    continue block23;
                }
                case 101: {
                    this.doEnumMethod(fieldDescriptor);
                    continue block23;
                }
                case 105: {
                    this.doEnumPointerMethod(fieldDescriptor);
                    continue block23;
                }
                case 104: {
                    int n2 = string2.indexOf(58);
                    if (n2 <= 0) {
                        throw new IllegalArgumentException(String.format("%s.%s : %s is not a valid bitfield", this.structure.getName(), string, string2));
                    }
                    String string3 = string2.substring(0, n2);
                    int n3 = Integer.parseInt(string2.substring(n2 + 1));
                    this.doBitfieldMethod(fieldDescriptor, string3, n3);
                    continue block23;
                }
            }
            if (1 > n || n > 99) continue;
            this.doSimpleTypeMethod(fieldDescriptor, n);
        }
    }

    private void doArrayMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getType();
        String string2 = string.substring(0, string.lastIndexOf(91)).trim();
        int n = this.typeManager.getType(string2);
        switch (n) {
            case 100: {
                this.doEAMethod("Bool", fieldDescriptor);
                return;
            }
            case 102: {
                this.doEAMethod("Double", fieldDescriptor);
                return;
            }
            case 101: {
                this.doEnumEAMethod(fieldDescriptor);
                return;
            }
            case 103: {
                this.doEAMethod("Float", fieldDescriptor);
                return;
            }
            case 130: {
                this.doEAMethod("ObjectReference", fieldDescriptor);
                return;
            }
            case 132: {
                this.doEAMethod("ObjectClassReference", fieldDescriptor);
                return;
            }
            case 134: {
                this.doEAMethod("ObjectMonitorReference", fieldDescriptor);
                return;
            }
            case 120: {
                this.doEAMethod(PointerHelper.removeTypeTags(string2), fieldDescriptor);
                return;
            }
            case 110: 
            case 113: 
            case 121: 
            case 131: 
            case 133: 
            case 135: {
                this.doEAMethod("Pointer", fieldDescriptor);
                return;
            }
            default: {
                if (1 > n || n > 99) break;
                this.doEAMethod(string2, fieldDescriptor);
                return;
            }
            case 104: 
            case 111: 
            case 112: 
        }
        throw new IllegalArgumentException("Unrecognized array: " + string);
    }

    private void doBitfieldMethod(StructureReader.FieldDescriptor fieldDescriptor, String string, int n) {
        String string2 = fieldDescriptor.getName();
        String string3 = String.format("_%s_s_", string2);
        String string4 = String.format("get%sBitfield", string);
        Type type2 = Type.getObjectType(this.qualifyType(string));
        Type type3 = Type.getObjectType(this.qualifyType(PointerHelper.generalizeSimpleType(string)));
        String string5 = Type.getMethodDescriptor(type3, new Type[0]);
        String string6 = Type.getMethodDescriptor(type2, Type.INT_TYPE, Type.INT_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, string2, string5);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, this.getStructureClassName(), string3, Type.INT_TYPE.getDescriptor());
            PointerHelper.loadInt(methodVisitor, n);
            methodVisitor.visitMethodInsn(182, this.className, string4, string6, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void doBooleanMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]);
        String string2 = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getBoolAtOffset", string2, false);
            methodVisitor.visitInsn(172);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Bool", fieldDescriptor);
    }

    private void doClassAnnotation() {
        Type type2 = Type.getObjectType("com/ibm/j9ddr/GeneratedPointerClass");
        AnnotationVisitor annotationVisitor = this.clazz.visitAnnotation(type2.getDescriptor(), true);
        Type type3 = Type.getObjectType(this.getStructureClassName());
        annotationVisitor.visit("structureClass", type3);
        annotationVisitor.visitEnd();
    }

    private void doConstructors(String string) {
        String string2 = Type.getMethodDescriptor(this.abstractPointerType, Type.LONG_TYPE);
        String string3 = Type.getMethodDescriptor(this.abstractPointerType, this.scalarType);
        String string4 = Type.getMethodDescriptor(this.classType, Type.LONG_TYPE);
        String string5 = Type.getMethodDescriptor(this.classType, this.scalarType);
        MethodVisitor methodVisitor = this.clazz.visitMethod(4, "<init>", "(J)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(183, string, "<init>", "(J)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(9, "cast", string4, null, null);
        Object object = new Label();
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(22, 0);
        methodVisitor.visitInsn(9);
        methodVisitor.visitInsn(148);
        methodVisitor.visitJumpInsn(154, (Label)object);
        methodVisitor.visitFieldInsn(178, this.className, "NULL", this.classType.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel((Label)object);
        methodVisitor.visitFrame(3, 0, null, 0, null);
        methodVisitor.visitTypeInsn(187, this.className);
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(22, 0);
        methodVisitor.visitMethodInsn(183, this.className, "<init>", "(J)V", false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(9, "cast", Type.getMethodDescriptor(this.classType, this.abstractPointerType), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, this.abstractPointerType.getInternalName(), "getAddress", "()J", false);
        methodVisitor.visitMethodInsn(184, this.className, "cast", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(9, "cast", Type.getMethodDescriptor(this.classType, this.udataType), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, this.udataType.getInternalName(), "longValue", "()J", false);
        methodVisitor.visitMethodInsn(184, this.className, "cast", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "add", string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        PointerHelper.loadLong(methodVisitor, this.structure.getSizeOf());
        methodVisitor.visitInsn(105);
        methodVisitor.visitMethodInsn(182, this.className, "addOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(5, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "add", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(182, this.className, "add", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "add", string5, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", "()J", false);
        methodVisitor.visitMethodInsn(182, this.className, "add", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "add", string3, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.className, "add", string5, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "addOffset", string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitInsn(97);
        methodVisitor.visitMethodInsn(184, this.className, "cast", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "addOffset", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(182, this.className, "addOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "addOffset", string5, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", "()J", false);
        methodVisitor.visitMethodInsn(182, this.className, "addOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "addOffset", string3, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.className, "addOffset", string5, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "sub", string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        PointerHelper.loadLong(methodVisitor, this.structure.getSizeOf());
        methodVisitor.visitInsn(105);
        methodVisitor.visitMethodInsn(182, this.className, "subOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(5, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "sub", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(182, this.className, "sub", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "sub", string5, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", "()J", false);
        methodVisitor.visitMethodInsn(182, this.className, "sub", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "sub", string3, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.className, "sub", string5, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "subOffset", string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitInsn(101);
        methodVisitor.visitMethodInsn(184, this.className, "cast", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "subOffset", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(182, this.className, "subOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "subOffset", string5, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.scalarType.getInternalName(), "longValue", "()J", false);
        methodVisitor.visitMethodInsn(182, this.className, "subOffset", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "subOffset", string3, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, this.className, "subOffset", string5, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(1, "untag", string4, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
        methodVisitor.visitVarInsn(22, 1);
        PointerHelper.loadLong(methodVisitor, -1L);
        methodVisitor.visitInsn(131);
        methodVisitor.visitInsn(127);
        methodVisitor.visitMethodInsn(184, this.className, "cast", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(6, 3);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "untag", string2, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(22, 1);
        methodVisitor.visitMethodInsn(182, this.className, "untag", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
        object = Type.getMethodDescriptor(this.classType, new Type[0]);
        methodVisitor = this.clazz.visitMethod(1, "untag", (String)object, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        PointerHelper.loadLong(methodVisitor, this.reader.getSizeOfUDATA() - 1);
        methodVisitor.visitMethodInsn(182, this.className, "untag", string4, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4161, "untag", Type.getMethodDescriptor(this.abstractPointerType, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, this.className, "untag", (String)object, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        methodVisitor = this.clazz.visitMethod(4, "sizeOfBaseType", "()J", null, null);
        methodVisitor.visitCode();
        PointerHelper.loadLong(methodVisitor, this.structure.getSizeOf());
        methodVisitor.visitInsn(173);
        methodVisitor.visitMaxs(2, 1);
        methodVisitor.visitEnd();
    }

    private void doDoubleMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), "()D");
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getDoubleAtOffset", "(J)D", false);
            methodVisitor.visitInsn(175);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Double", fieldDescriptor);
    }

    private void doEAMethod(String string, StructureReader.FieldDescriptor fieldDescriptor) {
        String string2 = fieldDescriptor.getName() + "EA";
        String string3 = PointerHelper.generalizeSimpleType(string);
        String string4 = this.qualifyPointerType(string3);
        String string5 = this.qualifyPointerType(string);
        String string6 = Type.getMethodDescriptor(Type.getObjectType(string4), new Type[0]);
        String string7 = Type.getMethodDescriptor(Type.getObjectType(string5), Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginMethod(fieldDescriptor, string2, string6);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "nonNullFieldEA", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string5, "cast", string7, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void doEnumEAMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = fieldDescriptor.getName() + "EA";
        String string2 = this.qualifyPointerType("Enum");
        Type type2 = Type.getObjectType(string2);
        String string3 = Type.getMethodDescriptor(type2, new Type[0]);
        String string4 = Type.getMethodDescriptor(type2, Type.LONG_TYPE, Type.getType(Class.class));
        Type type3 = Type.getObjectType(this.qualifyType(PointerHelper.getEnumType(fieldDescriptor.getType())));
        MethodVisitor methodVisitor = this.beginMethod(fieldDescriptor, string, string3);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "nonNullFieldEA", "(J)J", false);
            methodVisitor.visitLdcInsn(type3);
            methodVisitor.visitMethodInsn(184, string2, "cast", string4, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void doEnumMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = PointerHelper.getEnumType(fieldDescriptor.getType());
        int n = this.reader.getStructureSizeOf(string);
        PrimitiveAccessor primitiveAccessor = PrimitiveAccessor.forSize(n);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), "()J");
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, primitiveAccessor.methodName, primitiveAccessor.descriptor, false);
            if (!primitiveAccessor.returnsLong) {
                methodVisitor.visitInsn(133);
            }
            methodVisitor.visitInsn(173);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEnumEAMethod(fieldDescriptor);
    }

    private void doEnumPointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("Enum");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE, Type.getType(Class.class));
        String string4 = PointerHelper.getTargetType(PointerHelper.getEnumType(fieldDescriptor.getType()));
        Type type3 = Type.getObjectType(this.qualifyType(string4));
        MethodVisitor methodVisitor = this.beginMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitLdcInsn(type3);
            methodVisitor.visitMethodInsn(184, string, "cast", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 2);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doFJ9ObjectMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        Type type2 = Type.getObjectType(this.qualifyPointerType("J9Object"));
        String string = Type.getMethodDescriptor(type2, new Type[0]);
        String string2 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getObjectReferenceAtOffset", string2, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("ObjectReference", fieldDescriptor);
    }

    private void doFJ9ObjectPointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("ObjectReference");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string, "cast", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doFloatMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), "()F");
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getFloatAtOffset", "(J)F", false);
            methodVisitor.visitInsn(174);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Float", fieldDescriptor);
    }

    private void doJ9ObjectClassMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("J9Class");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getObjectClassAtOffset", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("ObjectClassReference", fieldDescriptor);
    }

    private void doJ9ObjectClassPointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("ObjectClassReference");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string, "cast", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doJ9ObjectMonitorMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("J9ObjectMonitor");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getObjectMonitorAtOffset", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("ObjectMonitorReference", fieldDescriptor);
    }

    private void doJ9ObjectMonitorPointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = this.qualifyPointerType("ObjectMonitorReference");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string, "cast", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doNullInstance() {
        this.clazz.visitField(25, "NULL", this.classType.getDescriptor(), null, null).visitEnd();
        MethodVisitor methodVisitor = this.clazz.visitMethod(8, "<clinit>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, this.className);
        methodVisitor.visitInsn(89);
        methodVisitor.visitInsn(9);
        methodVisitor.visitMethodInsn(183, this.className, "<init>", "(J)V", false);
        methodVisitor.visitFieldInsn(179, this.className, "NULL", this.classType.getDescriptor());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(4, 0);
        methodVisitor.visitEnd();
    }

    private void doPointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = PointerHelper.getTargetType(PointerHelper.removeTypeTags(fieldDescriptor.getType()));
        String string2 = this.qualifyPointerType(string);
        String string3 = PointerHelper.generalizeSimpleType(string);
        String string4 = this.qualifyPointerType(string3);
        String string5 = Type.getMethodDescriptor(Type.getObjectType(string2), Type.LONG_TYPE);
        String string6 = Type.getMethodDescriptor(Type.getObjectType(string4), new Type[0]);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string6);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string2, "cast", string5, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doSimpleTypeMethod(StructureReader.FieldDescriptor fieldDescriptor, int n) {
        String string = fieldDescriptor.getType();
        String string2 = PointerHelper.generalizeSimpleType(string);
        String string3 = this.qualifyType(string);
        String string4 = this.qualifyType(string2);
        PrimitiveAccessor primitiveAccessor = this.simpleTypeAccessor(n);
        String string5 = Type.getMethodDescriptor(Type.getObjectType(string4), new Type[0]);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string5);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitTypeInsn(187, string3);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, primitiveAccessor.methodName, primitiveAccessor.descriptor, false);
            if (!primitiveAccessor.returnsLong) {
                methodVisitor.visitInsn(133);
            }
            methodVisitor.visitMethodInsn(183, string3, "<init>", "(J)V", false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(5, 1);
        methodVisitor.visitEnd();
        this.doEAMethod(string, fieldDescriptor);
    }

    private void doSRPEAMethod(StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string = fieldDescriptor.getName() + "EA";
        String string2 = this.qualifyPointerType(bl ? "WideSelfRelative" : "SelfRelative");
        Type type2 = Type.getObjectType(string2);
        String string3 = Type.getMethodDescriptor(type2, new Type[0]);
        String string4 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginMethod(fieldDescriptor, string, string3);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "nonNullFieldEA", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string2, "cast", string4, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
    }

    private void doSRPMethod(StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string = bl ? "J9WSRP" : "J9SRP";
        int n = string.length();
        String string2 = fieldDescriptor.getType();
        String string3 = string2.startsWith(string) && string2.startsWith("(", n) ? string2.substring(n + 1, string2.length() - 1).trim() : "void";
        int n2 = this.typeManager.getType(string3);
        switch (n2) {
            case 111: {
                string3 = "SelfRelative";
                break;
            }
            case 112: {
                string3 = "WideSelfRelative";
                break;
            }
            case 120: {
                string3 = PointerHelper.removeTypeTags(string3);
                break;
            }
            case 0: {
                string3 = "Void";
                break;
            }
            default: {
                if (1 <= n2 && n2 <= 99) {
                    string3 = PointerHelper.removeTypeTags(string3);
                    break;
                }
                throw new IllegalArgumentException("Unexpected SRP type: " + string2);
            }
        }
        String string4 = this.qualifyPointerType(PointerHelper.generalizeSimpleType(string3));
        String string5 = this.qualifyPointerType(string3);
        Type type2 = Type.getObjectType(string4);
        String string6 = Type.getMethodDescriptor(type2, new Type[0]);
        String string7 = Type.getObjectType(string5).getDescriptor();
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string6);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            Label label = new Label();
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            if (bl) {
                methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
                methodVisitor.visitVarInsn(55, 1);
                methodVisitor.visitVarInsn(22, 1);
                methodVisitor.visitInsn(9);
                methodVisitor.visitInsn(148);
            } else {
                methodVisitor.visitMethodInsn(182, this.className, "getIntAtOffset", "(J)I", false);
                methodVisitor.visitVarInsn(54, 1);
                methodVisitor.visitVarInsn(21, 1);
            }
            methodVisitor.visitJumpInsn(154, label);
            methodVisitor.visitFieldInsn(178, string5, "NULL", string7);
            methodVisitor.visitInsn(176);
            methodVisitor.visitLabel(label);
            methodVisitor.visitFrame(1, 1, new Object[]{bl ? LONG : INTEGER}, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.className, "address", Type.LONG_TYPE.getDescriptor());
            PointerHelper.addLong(methodVisitor, fieldDescriptor.getOffset());
            if (bl) {
                methodVisitor.visitVarInsn(22, 1);
            } else {
                methodVisitor.visitVarInsn(21, 1);
                methodVisitor.visitInsn(133);
            }
            methodVisitor.visitInsn(97);
            String string8 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
            methodVisitor.visitMethodInsn(184, string5, "cast", string8, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(4, bl ? 3 : 2);
        methodVisitor.visitEnd();
        this.doSRPEAMethod(fieldDescriptor, bl);
    }

    private void doSRPPointerMethod(StructureReader.FieldDescriptor fieldDescriptor, boolean bl) {
        String string = this.qualifyPointerType(bl ? "WideSelfRelative" : "SelfRelative");
        Type type2 = Type.getObjectType(string);
        String string2 = Type.getMethodDescriptor(type2, new Type[0]);
        String string3 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string2);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string, "cast", string3, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doStructureMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = PointerHelper.removeTypeTags(fieldDescriptor.getType());
        String string2 = "void".equals(string) ? "Void" : string;
        String string3 = this.qualifyPointerType(string2);
        Type type2 = Type.getObjectType(string3);
        String string4 = Type.getMethodDescriptor(type2, new Type[0]);
        String string5 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string4);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "nonNullFieldEA", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string3, "cast", string5, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private void doStructurePointerMethod(StructureReader.FieldDescriptor fieldDescriptor) {
        String string = PointerHelper.getTargetType(PointerHelper.removeTypeTags(fieldDescriptor.getType()));
        String string2 = this.qualifyPointerType(string);
        Type type2 = Type.getObjectType(string2);
        String string3 = Type.getMethodDescriptor(type2, new Type[0]);
        String string4 = Type.getMethodDescriptor(type2, Type.LONG_TYPE);
        MethodVisitor methodVisitor = this.beginAnnotatedMethod(fieldDescriptor, fieldDescriptor.getName(), string3);
        methodVisitor.visitCode();
        if (PointerHelper.checkPresent(fieldDescriptor, methodVisitor)) {
            methodVisitor.visitVarInsn(25, 0);
            PointerHelper.loadLong(methodVisitor, fieldDescriptor.getOffset());
            methodVisitor.visitMethodInsn(182, this.className, "getPointerAtOffset", "(J)J", false);
            methodVisitor.visitMethodInsn(184, string2, "cast", string4, false);
            methodVisitor.visitInsn(176);
        }
        methodVisitor.visitMaxs(3, 1);
        methodVisitor.visitEnd();
        this.doEAMethod("Pointer", fieldDescriptor);
    }

    private byte[] generate() {
        String string = this.getSuperClassName();
        this.clazz.visit(52, 33, this.className, null, string, null);
        this.doClassAnnotation();
        this.doNullInstance();
        this.doConstructors(string);
        this.doAccessorMethods();
        this.clazz.visitEnd();
        return this.clazz.toByteArray();
    }

    private String getStructureClassName() {
        return this.basePrefix + "structure/" + this.structure.getName();
    }

    private String getSuperClassName() {
        String string = this.structure.getSuperName();
        String string2 = string.isEmpty() ? this.basePrefix + "pointer/StructurePointer" : this.basePrefix + "pointer/generated/" + string + "Pointer";
        return string2;
    }

    private String qualifyPointerType(String string) {
        String string2 = predefinedPointerTypes.contains(string) ? "pointer/" : "pointer/generated/";
        return this.basePrefix + string2 + string + "Pointer";
    }

    private String qualifyType(String string) {
        String string2 = predefinedDataTypes.contains(string) ? "types/" : "structure/";
        return this.basePrefix + string2 + string;
    }

    private PrimitiveAccessor simpleTypeAccessor(int n) {
        int n2;
        switch (n) {
            case 1: 
            case 6: {
                n2 = 1;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
            case 3: 
            case 8: {
                n2 = 4;
                break;
            }
            case 4: 
            case 9: {
                n2 = 8;
                break;
            }
            case 5: 
            case 10: {
                n2 = this.reader.getSizeOfUDATA();
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + n);
            }
        }
        return PrimitiveAccessor.forSize(n2);
    }

    static {
        TypeTagPattern = Pattern.compile("\\s*\\b(class|enum|struct)\\s+");
        Set<String> set = PointerHelper.addNames(new HashSet<String>(), "I8 U8 I16 U16 I32 U32 I64 U64 IDATA UDATA Void");
        predefinedDataTypes = new HashSet<String>(set);
        PointerHelper.addNames(predefinedDataTypes, "Scalar IScalar UScalar");
        predefinedPointerTypes = new HashSet<String>(set);
        PointerHelper.addNames(predefinedPointerTypes, "Abstract Bool Double Enum Float ObjectClassReference ObjectMonitorReference");
        PointerHelper.addNames(predefinedPointerTypes, "ObjectReference Pointer SelfRelative Structure WideSelfRelative");
    }
}

