/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.jca.JCAUtil;
import sun.security.util.ECKeySizeParameterSpec;
import sun.security.util.Length;

public final class KeyUtil {
    public static final int getKeySize(Key key) {
        Object object;
        int n = -1;
        if (key instanceof Length) {
            try {
                object = (Length)((Object)key);
                n = object.length();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (n >= 0) {
                return n;
            }
        }
        if (key instanceof SecretKey) {
            object = (SecretKey)key;
            String string = object.getFormat();
            if ("RAW".equals(string) && object.getEncoded() != null) {
                n = object.getEncoded().length * 8;
            }
        } else if (key instanceof RSAKey) {
            object = (RSAKey)((Object)key);
            n = object.getModulus().bitLength();
        } else if (key instanceof ECKey) {
            object = (ECKey)((Object)key);
            n = object.getParams().getOrder().bitLength();
        } else if (key instanceof DSAKey) {
            object = (DSAKey)((Object)key);
            DSAParams dSAParams = object.getParams();
            n = dSAParams != null ? dSAParams.getP().bitLength() : -1;
        } else if (key instanceof DHKey) {
            object = (DHKey)((Object)key);
            n = object.getParams().getP().bitLength();
        }
        return n;
    }

    public static final int getKeySize(AlgorithmParameters algorithmParameters) {
        String string;
        switch (string = algorithmParameters.getAlgorithm()) {
            case "EC": {
                AlgorithmParameterSpec algorithmParameterSpec;
                try {
                    algorithmParameterSpec = algorithmParameters.getParameterSpec(ECKeySizeParameterSpec.class);
                    if (algorithmParameterSpec != null) {
                        return ((ECKeySizeParameterSpec)algorithmParameterSpec).getKeySize();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
                try {
                    algorithmParameterSpec = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                    if (algorithmParameterSpec != null) {
                        return ((ECParameterSpec)algorithmParameterSpec).getOrder().bitLength();
                    }
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {}
                break;
            }
            case "DiffieHellman": {
                try {
                    DHParameterSpec dHParameterSpec = algorithmParameters.getParameterSpec(DHParameterSpec.class);
                    if (dHParameterSpec != null) {
                        return dHParameterSpec.getP().bitLength();
                    }
                    break;
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    // empty catch block
                }
            }
        }
        return -1;
    }

    public static final void validate(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("The key to be validated cannot be null");
        }
        if (key instanceof DHPublicKey) {
            KeyUtil.validateDHPublicKey((DHPublicKey)key);
        }
    }

    public static final void validate(KeySpec keySpec) throws InvalidKeyException {
        if (keySpec == null) {
            throw new NullPointerException("The key spec to be validated cannot be null");
        }
        if (keySpec instanceof DHPublicKeySpec) {
            KeyUtil.validateDHPublicKey((DHPublicKeySpec)keySpec);
        }
    }

    public static final boolean isOracleJCEProvider(String string) {
        return string != null && (string.equals("SunJCE") || string.equals("SunMSCAPI") || string.equals("OracleUcrypto") || string.startsWith("SunPKCS11"));
    }

    public static byte[] checkTlsPreMasterSecretKey(int n, int n2, SecureRandom secureRandom, byte[] byArray, boolean bl) {
        if (secureRandom == null) {
            secureRandom = JCAUtil.getSecureRandom();
        }
        byte[] byArray2 = new byte[48];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = bl ? byArray2 : byArray;
        byArray = byArray3 == null ? byArray2 : byArray3;
        byArray3 = byArray.length != 48 ? byArray2 : byArray;
        int n3 = (byArray3[0] & 0xFF) << 8 | byArray3[1] & 0xFF;
        int n4 = n - n3 | n3 - n;
        int n5 = 769 - n;
        int n6 = n2 - n3 | n3 - n2;
        n4 = (n4 & (n5 | n6)) >> 24;
        n5 = ~n4;
        for (int i = 0; i < 48; ++i) {
            byArray3[i] = (byte)(byArray3[i] & n5 | byArray2[i] & n4);
        }
        return byArray3;
    }

    private static void validateDHPublicKey(DHPublicKey dHPublicKey) throws InvalidKeyException {
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        BigInteger bigInteger = dHParameterSpec.getP();
        BigInteger bigInteger2 = dHParameterSpec.getG();
        BigInteger bigInteger3 = dHPublicKey.getY();
        KeyUtil.validateDHPublicKey(bigInteger, bigInteger2, bigInteger3);
    }

    private static void validateDHPublicKey(DHPublicKeySpec dHPublicKeySpec) throws InvalidKeyException {
        KeyUtil.validateDHPublicKey(dHPublicKeySpec.getP(), dHPublicKeySpec.getG(), dHPublicKeySpec.getY());
    }

    private static void validateDHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        BigInteger bigInteger4 = BigInteger.ONE;
        BigInteger bigInteger5 = bigInteger.subtract(BigInteger.ONE);
        if (bigInteger3.compareTo(bigInteger4) <= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too small");
        }
        if (bigInteger3.compareTo(bigInteger5) >= 0) {
            throw new InvalidKeyException("Diffie-Hellman public key is too large");
        }
        BigInteger bigInteger6 = bigInteger.remainder(bigInteger3);
        if (bigInteger6.equals(BigInteger.ZERO)) {
            throw new InvalidKeyException("Invalid Diffie-Hellman parameters");
        }
    }

    public static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy((Object)byArray, n, (Object)byArray2, 0, byArray2.length);
        return byArray2;
    }
}

