/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;
import sun.security.jca.JCAUtil;
import sun.security.rsa.MGF1;
import sun.security.rsa.PSSParameters;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;

public class RSAPSSSignature
extends SignatureSpi {
    private static final boolean DEBUG = false;
    private static final byte[] EIGHT_BYTES_OF_ZEROS = new byte[8];
    private static final Hashtable<String, Integer> DIGEST_LENGTHS = new Hashtable();
    private MessageDigest md = null;
    private boolean digestReset = true;
    private RSAPrivateKey privKey = null;
    private RSAPublicKey pubKey = null;
    private PSSParameterSpec sigParams = null;
    private SecureRandom random;

    private boolean isDigestEqual(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.indexOf("-") != -1) {
            return string.equalsIgnoreCase(string2);
        }
        if (string.equals("SHA-1")) {
            return string2.equalsIgnoreCase("SHA") || string2.equalsIgnoreCase("SHA1");
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        if (string2.regionMatches(true, 0, "SHA", 0, 3)) {
            string2 = stringBuilder.insert(3, "-").toString();
            return string.equalsIgnoreCase(string2);
        }
        throw new ProviderException("Unsupported digest algorithm " + string2);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("key must be RSAPublicKey");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        this.isPublicKeyValid(rSAPublicKey);
        this.pubKey = rSAPublicKey;
        this.privKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("key must be RSAPrivateKey");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
        this.isPrivateKeyValid(rSAPrivateKey);
        this.privKey = rSAPrivateKey;
        this.pubKey = null;
        this.random = secureRandom == null ? JCAUtil.getSecureRandom() : secureRandom;
        this.resetDigest();
    }

    private static boolean isCompatible(AlgorithmParameterSpec algorithmParameterSpec, PSSParameterSpec pSSParameterSpec) {
        if (algorithmParameterSpec == null) {
            return true;
        }
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            return false;
        }
        if (pSSParameterSpec == null) {
            return true;
        }
        PSSParameterSpec pSSParameterSpec2 = (PSSParameterSpec)algorithmParameterSpec;
        if (pSSParameterSpec2.getSaltLength() > pSSParameterSpec.getSaltLength()) {
            return false;
        }
        PSSParameterSpec pSSParameterSpec3 = new PSSParameterSpec(pSSParameterSpec2.getDigestAlgorithm(), pSSParameterSpec2.getMGFAlgorithm(), pSSParameterSpec2.getMGFParameters(), pSSParameterSpec.getSaltLength(), pSSParameterSpec2.getTrailerField());
        PSSParameters pSSParameters = new PSSParameters();
        try {
            pSSParameters.engineInit(pSSParameterSpec3);
            byte[] byArray = pSSParameters.engineGetEncoded();
            pSSParameters.engineInit(pSSParameterSpec);
            byte[] byArray2 = pSSParameters.engineGetEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void isPrivateKeyValid(RSAPrivateKey rSAPrivateKey) throws InvalidKeyException {
        try {
            if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
                if (!RSAPrivateCrtKeyImpl.checkComponents(rSAPrivateCrtKey)) throw new InvalidKeyException("Some of the CRT-specific components are not available");
                RSAKeyFactory.checkRSAProviderKeyLengths(rSAPrivateCrtKey.getModulus().bitLength(), rSAPrivateCrtKey.getPublicExponent());
            } else {
                RSAKeyFactory.checkRSAProviderKeyLengths(rSAPrivateKey.getModulus().bitLength(), null);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Can not access private key components", exception);
        }
        this.isValid(rSAPrivateKey);
    }

    private void isPublicKeyValid(RSAPublicKey rSAPublicKey) throws InvalidKeyException {
        try {
            RSAKeyFactory.checkRSAProviderKeyLengths(rSAPublicKey.getModulus().bitLength(), rSAPublicKey.getPublicExponent());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Can not access public key components", exception);
        }
        this.isValid(rSAPublicKey);
    }

    private void isValid(RSAKey rSAKey) throws InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = rSAKey.getParams();
            if (!RSAPSSSignature.isCompatible(rSAKey.getParams(), this.sigParams)) {
                throw new InvalidKeyException("Key contains incompatible PSS parameter values");
            }
            if (this.sigParams != null) {
                Integer n = DIGEST_LENGTHS.get(this.sigParams.getDigestAlgorithm());
                if (n == null) {
                    throw new ProviderException("Unsupported digest algo: " + this.sigParams.getDigestAlgorithm());
                }
                RSAPSSSignature.checkKeyLength(rSAKey, n, this.sigParams.getSaltLength());
            }
        }
        catch (SignatureException signatureException) {
            throw new InvalidKeyException(signatureException);
        }
    }

    private PSSParameterSpec validateSigParams(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        Key key;
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters cannot be null");
        }
        if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
        }
        PSSParameterSpec pSSParameterSpec = (PSSParameterSpec)algorithmParameterSpec;
        if (pSSParameterSpec == this.sigParams) {
            return pSSParameterSpec;
        }
        Key key2 = key = this.privKey == null ? this.pubKey : this.privKey;
        if (key != null && !RSAPSSSignature.isCompatible(key.getParams(), pSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Signature parameters does not match key parameters");
        }
        if (!pSSParameterSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        if (pSSParameterSpec.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        String string = pSSParameterSpec.getDigestAlgorithm();
        if (key != null) {
            try {
                int n = DIGEST_LENGTHS.get(string);
                RSAPSSSignature.checkKeyLength((RSAKey)((Object)key), n, pSSParameterSpec.getSaltLength());
            }
            catch (SignatureException signatureException) {
                throw new InvalidAlgorithmParameterException(signatureException);
            }
        }
        return pSSParameterSpec;
    }

    private void ensureInit() throws SignatureException {
        Key key;
        Key key2 = key = this.privKey == null ? this.pubKey : this.privKey;
        if (key == null) {
            throw new SignatureException("Missing key");
        }
        if (this.sigParams == null) {
            throw new SignatureException("Parameters required for RSASSA-PSS signatures");
        }
    }

    private static void checkKeyLength(RSAKey rSAKey, int n, int n2) throws SignatureException {
        int n3;
        int n4;
        if (rSAKey != null && (n4 = RSAPSSSignature.getKeyLengthInBits(rSAKey) + 7 >> 3) < (n3 = Math.addExact(Math.addExact(n, n2), 2))) {
            throw new SignatureException("Key is too short, need min " + n3 + " bytes");
        }
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.ensureInit();
        this.md.update(by);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInit();
        this.md.update(byArray, n, n2);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInit();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException.getMessage());
        }
        this.md.update(byteBuffer);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.ensureInit();
        byte[] byArray = this.getDigestValue();
        try {
            byte[] byArray2 = this.encodeSignature(byArray);
            byte[] byArray3 = RSACore.rsa(byArray2, this.privKey, true);
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not sign data", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new SignatureException("Could not encode data", iOException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        this.ensureInit();
        try {
            if (byArray.length != RSACore.getByteLength(this.pubKey)) {
                throw new SignatureException("Signature length not correct: got " + byArray.length + " but was expecting " + RSACore.getByteLength(this.pubKey));
            }
            byte[] byArray2 = this.getDigestValue();
            byte[] byArray3 = RSACore.rsa(byArray, this.pubKey);
            boolean bl = this.decodeSignature(byArray2, byArray3);
            return bl;
        }
        catch (BadPaddingException badPaddingException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            throw new SignatureException("Signature encoding error", iOException);
        }
        finally {
            this.resetDigest();
        }
    }

    private static int getKeyLengthInBits(RSAKey rSAKey) {
        if (rSAKey != null) {
            return rSAKey.getModulus().bitLength();
        }
        return -1;
    }

    private byte[] encodeSignature(byte[] byArray) throws IOException, DigestException {
        AlgorithmParameterSpec algorithmParameterSpec = this.sigParams.getMGFParameters();
        String string = algorithmParameterSpec != null ? ((MGF1ParameterSpec)algorithmParameterSpec).getDigestAlgorithm() : this.md.getAlgorithm();
        try {
            Object object;
            int n = RSAPSSSignature.getKeyLengthInBits(this.privKey) - 1;
            int n2 = n + 7 >> 3;
            int n3 = this.md.getDigestLength();
            int n4 = n2 - n3 - 1;
            int n5 = this.sigParams.getSaltLength();
            byte[] byArray2 = new byte[n2];
            byArray2[n4 - n5 - 1] = 1;
            byArray2[byArray2.length - 1] = -68;
            if (!this.digestReset) {
                throw new ProviderException("Digest should be reset");
            }
            this.md.update(EIGHT_BYTES_OF_ZEROS);
            this.digestReset = false;
            this.md.update(byArray);
            if (n5 != 0) {
                object = new byte[n5];
                this.random.nextBytes((byte[])object);
                this.md.update((byte[])object);
                System.arraycopy(object, 0, (Object)byArray2, n4 - n5, n5);
            }
            this.md.digest(byArray2, n4, n3);
            this.digestReset = true;
            object = new MGF1(string);
            ((MGF1)object).generateAndXor(byArray2, n4, n3, n4, byArray2, 0);
            int n6 = (n2 << 3) - n;
            if (n6 != 0) {
                byte by = (byte)(255 >>> n6);
                byArray2[0] = (byte)(byArray2[0] & by);
            }
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.toString());
        }
    }

    private boolean decodeSignature(byte[] byArray, byte[] byArray2) throws IOException {
        int n;
        byte by;
        int n2 = byArray.length;
        int n3 = this.sigParams.getSaltLength();
        int n4 = RSAPSSSignature.getKeyLengthInBits(this.pubKey) - 1;
        int n5 = n4 + 7 >> 3;
        int n6 = byArray2.length - n5;
        if (n6 == 1 && byArray2[0] != 0) {
            return false;
        }
        if (n5 < n2 + n3 + 2) {
            return false;
        }
        if (byArray2[n6 + n5 - 1] != -68) {
            return false;
        }
        int n7 = (n5 << 3) - n4;
        if (n7 != 0 && (byArray2[n6] & (by = (byte)(255 << 8 - n7))) != 0) {
            return false;
        }
        AlgorithmParameterSpec algorithmParameterSpec = this.sigParams.getMGFParameters();
        String string = algorithmParameterSpec != null ? ((MGF1ParameterSpec)algorithmParameterSpec).getDigestAlgorithm() : this.md.getAlgorithm();
        int n8 = n5 - n2 - 1;
        try {
            MGF1 mGF1 = new MGF1(string);
            mGF1.generateAndXor(byArray2, n6 + n8, n2, n8, byArray2, n6);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.toString());
        }
        if (n7 != 0) {
            byte by2 = (byte)(255 >>> n7);
            byArray2[n6] = (byte)(byArray2[n6] & by2);
        }
        for (n = n6; n < n6 + (n8 - n3 - 1); ++n) {
            if (byArray2[n] == 0) continue;
            return false;
        }
        if (byArray2[n] != 1) {
            return false;
        }
        this.md.update(EIGHT_BYTES_OF_ZEROS);
        this.digestReset = false;
        this.md.update(byArray);
        if (n3 > 0) {
            this.md.update(byArray2, n6 + (n8 - n3), n3);
        }
        byte[] byArray3 = this.md.digest();
        this.digestReset = true;
        byte[] byArray4 = Arrays.copyOfRange(byArray2, n6 + n8, n6 + n5 - 1);
        return MessageDigest.isEqual(byArray3, byArray4);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.sigParams = this.validateSigParams(algorithmParameterSpec);
        if (!this.digestReset) {
            throw new ProviderException("Cannot set parameters during operations");
        }
        String string = this.sigParams.getDigestAlgorithm();
        if (this.md == null || !this.md.getAlgorithm().equalsIgnoreCase(string)) {
            try {
                this.md = MessageDigest.getInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("Unsupported digest algorithm " + string, noSuchAlgorithmException);
            }
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.sigParams != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance("RSASSA-PSS");
                algorithmParameters.init(this.sigParams);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException.getMessage());
            }
        }
        return algorithmParameters;
    }

    static {
        DIGEST_LENGTHS.put("SHA-1", 20);
        DIGEST_LENGTHS.put("SHA", 20);
        DIGEST_LENGTHS.put("SHA1", 20);
        DIGEST_LENGTHS.put("SHA-224", 28);
        DIGEST_LENGTHS.put("SHA224", 28);
        DIGEST_LENGTHS.put("SHA-256", 32);
        DIGEST_LENGTHS.put("SHA256", 32);
        DIGEST_LENGTHS.put("SHA-384", 48);
        DIGEST_LENGTHS.put("SHA384", 48);
        DIGEST_LENGTHS.put("SHA-512", 64);
        DIGEST_LENGTHS.put("SHA512", 64);
        DIGEST_LENGTHS.put("SHA-512/224", 28);
        DIGEST_LENGTHS.put("SHA512/224", 28);
        DIGEST_LENGTHS.put("SHA-512/256", 32);
        DIGEST_LENGTHS.put("SHA512/256", 32);
    }
}

