/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.misc.Unsafe;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.AnnotationTypeMismatchExceptionProxy;
import sun.reflect.annotation.ExceptionProxy;

class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 6182022883658399397L;
    private final Class<? extends Annotation> type;
    private final Map<String, Object> memberValues;
    private volatile transient Method[] memberMethods = null;

    AnnotationInvocationHandler(Class<? extends Annotation> clazz, Map<String, Object> map) {
        Class<?>[] classArray = clazz.getInterfaces();
        if (!clazz.isAnnotation() || classArray.length != 1 || classArray[0] != Annotation.class) {
            throw new AnnotationFormatError("Attempt to create proxy for a non-annotation type.");
        }
        this.type = clazz;
        this.memberValues = map;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        if (string.equals("equals") && classArray.length == 1 && classArray[0] == Object.class) {
            return this.equalsImpl(objectArray[0]);
        }
        if (classArray.length != 0) {
            throw new AssertionError((Object)"Too many parameters for an annotation method");
        }
        switch (string) {
            case "toString": {
                return this.toStringImpl();
            }
            case "hashCode": {
                return this.hashCodeImpl();
            }
            case "annotationType": {
                return this.type;
            }
        }
        Object object2 = this.memberValues.get(string);
        if (object2 == null) {
            throw new IncompleteAnnotationException(this.type, string);
        }
        if (object2 instanceof ExceptionProxy) {
            throw ((ExceptionProxy)object2).generateException();
        }
        if (object2.getClass().isArray() && Array.getLength(object2) != 0) {
            object2 = this.cloneArray(object2);
        }
        return object2;
    }

    private Object cloneArray(Object object) {
        Class<? extends Object> clazz = object.getClass();
        if (clazz == byte[].class) {
            byte[] byArray = (byte[])object;
            return byArray.clone();
        }
        if (clazz == char[].class) {
            char[] cArray = (char[])object;
            return cArray.clone();
        }
        if (clazz == double[].class) {
            double[] dArray = (double[])object;
            return dArray.clone();
        }
        if (clazz == float[].class) {
            float[] fArray = (float[])object;
            return fArray.clone();
        }
        if (clazz == int[].class) {
            int[] nArray = (int[])object;
            return nArray.clone();
        }
        if (clazz == long[].class) {
            long[] lArray = (long[])object;
            return lArray.clone();
        }
        if (clazz == short[].class) {
            short[] sArray = (short[])object;
            return sArray.clone();
        }
        if (clazz == boolean[].class) {
            boolean[] blArray = (boolean[])object;
            return blArray.clone();
        }
        Object[] objectArray = (Object[])object;
        return objectArray.clone();
    }

    private String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('@');
        stringBuilder.append(this.type.getName());
        stringBuilder.append('(');
        boolean bl = true;
        for (Map.Entry<String, Object> entry : this.memberValues.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(AnnotationInvocationHandler.memberValueToString(entry.getValue()));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String memberValueToString(Object object) {
        Class<? extends Object> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.toString();
        }
        if (clazz == byte[].class) {
            return Arrays.toString((byte[])object);
        }
        if (clazz == char[].class) {
            return Arrays.toString((char[])object);
        }
        if (clazz == double[].class) {
            return Arrays.toString((double[])object);
        }
        if (clazz == float[].class) {
            return Arrays.toString((float[])object);
        }
        if (clazz == int[].class) {
            return Arrays.toString((int[])object);
        }
        if (clazz == long[].class) {
            return Arrays.toString((long[])object);
        }
        if (clazz == short[].class) {
            return Arrays.toString((short[])object);
        }
        if (clazz == boolean[].class) {
            return Arrays.toString((boolean[])object);
        }
        return Arrays.toString((Object[])object);
    }

    private Boolean equalsImpl(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.type.isInstance(object)) {
            return false;
        }
        for (Method method : this.getMemberMethods()) {
            String string = method.getName();
            Object object2 = this.memberValues.get(string);
            Object object3 = null;
            AnnotationInvocationHandler annotationInvocationHandler = this.asOneOfUs(object);
            if (annotationInvocationHandler != null) {
                object3 = annotationInvocationHandler.memberValues.get(string);
            } else {
                try {
                    object3 = method.invoke(object, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
            }
            if (AnnotationInvocationHandler.memberValueEquals(object2, object3)) continue;
            return false;
        }
        return true;
    }

    private AnnotationInvocationHandler asOneOfUs(Object object) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(object.getClass()) && (invocationHandler = Proxy.getInvocationHandler(object)) instanceof AnnotationInvocationHandler) {
            return (AnnotationInvocationHandler)invocationHandler;
        }
        return null;
    }

    private static boolean memberValueEquals(Object object, Object object2) {
        Class<? extends Object> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.equals(object2);
        }
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object2.getClass() != clazz) {
            return false;
        }
        if (clazz == byte[].class) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz == char[].class) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz == double[].class) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (clazz == float[].class) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz == int[].class) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz == long[].class) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz == short[].class) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        assert (clazz == boolean[].class);
        return Arrays.equals((boolean[])object, (boolean[])object2);
    }

    private Method[] getMemberMethods() {
        if (this.memberMethods == null) {
            this.memberMethods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    AccessibleObject[] accessibleObjectArray = AnnotationInvocationHandler.this.type.getDeclaredMethods();
                    AnnotationInvocationHandler.this.validateAnnotationMethods((Method[])accessibleObjectArray);
                    AccessibleObject.setAccessible(accessibleObjectArray, true);
                    return accessibleObjectArray;
                }
            });
        }
        return this.memberMethods;
    }

    private void validateAnnotationMethods(Method[] methodArray) {
        boolean bl = true;
        for (Method method : methodArray) {
            if (method.getModifiers() != 1025 || method.isDefault() || method.getParameterCount() != 0 || method.getExceptionTypes().length != 0) {
                bl = false;
                break;
            }
            Class<?> clazz = method.getReturnType();
            if (clazz.isArray() && (clazz = clazz.getComponentType()).isArray()) {
                bl = false;
                break;
            }
            if (!(clazz.isPrimitive() && clazz != Void.TYPE || clazz == String.class || clazz == Class.class || clazz.isEnum() || clazz.isAnnotation())) {
                bl = false;
                break;
            }
            String string = method.getName();
            if (!(string.equals("toString") && clazz == String.class || string.equals("hashCode") && clazz == Integer.TYPE) && (!string.equals("annotationType") || clazz != Class.class)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        throw new AnnotationFormatError("Malformed method on an annotation type");
    }

    private int hashCodeImpl() {
        int n = 0;
        for (Map.Entry<String, Object> entry : this.memberValues.entrySet()) {
            n += 127 * entry.getKey().hashCode() ^ AnnotationInvocationHandler.memberValueHashCode(entry.getValue());
        }
        return n;
    }

    private static int memberValueHashCode(Object object) {
        Class<? extends Object> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object.hashCode();
        }
        if (clazz == byte[].class) {
            return Arrays.hashCode((byte[])object);
        }
        if (clazz == char[].class) {
            return Arrays.hashCode((char[])object);
        }
        if (clazz == double[].class) {
            return Arrays.hashCode((double[])object);
        }
        if (clazz == float[].class) {
            return Arrays.hashCode((float[])object);
        }
        if (clazz == int[].class) {
            return Arrays.hashCode((int[])object);
        }
        if (clazz == long[].class) {
            return Arrays.hashCode((long[])object);
        }
        if (clazz == short[].class) {
            return Arrays.hashCode((short[])object);
        }
        if (clazz == boolean[].class) {
            return Arrays.hashCode((boolean[])object);
        }
        return Arrays.hashCode((Object[])object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Class clazz = (Class)getField.get("type", null);
        Map map = (Map)getField.get("memberValues", null);
        AnnotationType annotationType = null;
        try {
            annotationType = AnnotationType.getInstance(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("Non-annotation type in annotation serial stream");
        }
        Map<String, Class<?>> map2 = annotationType.memberTypes();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            AnnotationTypeMismatchExceptionProxy annotationTypeMismatchExceptionProxy = null;
            Class<?> clazz2 = map2.get(string);
            if (clazz2 != null && !clazz2.isInstance(annotationTypeMismatchExceptionProxy = (AnnotationTypeMismatchExceptionProxy)entry.getValue()) && !(annotationTypeMismatchExceptionProxy instanceof ExceptionProxy)) {
                annotationTypeMismatchExceptionProxy = new AnnotationTypeMismatchExceptionProxy(AnnotationInvocationHandler.objectToString(annotationTypeMismatchExceptionProxy)).setMember(annotationType.members().get(string));
            }
            linkedHashMap.put(string, annotationTypeMismatchExceptionProxy);
        }
        UnsafeAccessor.setType(this, clazz);
        UnsafeAccessor.setMemberValues(this, linkedHashMap);
    }

    private static String objectToString(Object object) {
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private static class UnsafeAccessor {
        private static final Unsafe unsafe;
        private static final long typeOffset;
        private static final long memberValuesOffset;

        private UnsafeAccessor() {
        }

        static void setType(AnnotationInvocationHandler annotationInvocationHandler, Class<? extends Annotation> clazz) {
            unsafe.putObject((Object)annotationInvocationHandler, typeOffset, clazz);
        }

        static void setMemberValues(AnnotationInvocationHandler annotationInvocationHandler, Map<String, Object> map) {
            unsafe.putObject((Object)annotationInvocationHandler, memberValuesOffset, map);
        }

        static {
            try {
                unsafe = Unsafe.getUnsafe();
                typeOffset = unsafe.objectFieldOffset(AnnotationInvocationHandler.class.getDeclaredField("type"));
                memberValuesOffset = unsafe.objectFieldOffset(AnnotationInvocationHandler.class.getDeclaredField("memberValues"));
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }
}

