/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;

public class MessageHeader {
    private String[] keys;
    private String[] values;
    private int nkeys;
    private final int maxHeaderSize;
    private long size;

    public MessageHeader() {
        this(0);
    }

    public MessageHeader(int n) {
        this.maxHeaderSize = n;
        this.grow();
    }

    public MessageHeader(InputStream inputStream) throws IOException {
        this.maxHeaderSize = 0;
        this.parseHeader(inputStream);
    }

    public synchronized String getHeaderNamesInList() {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (int i = 0; i < this.nkeys; ++i) {
            stringJoiner.add(this.keys[i]);
        }
        return stringJoiner.toString();
    }

    public synchronized void reset() {
        this.keys = null;
        this.values = null;
        this.nkeys = 0;
        this.grow();
    }

    public synchronized String findValue(String string) {
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                return this.values[n];
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                return this.values[n];
            }
        }
        return null;
    }

    public synchronized int getKey(String string) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (this.keys[n] != string && (string == null || !string.equalsIgnoreCase(this.keys[n]))) continue;
            return n;
        }
        return -1;
    }

    public synchronized String getKey(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.keys[n];
    }

    public synchronized String getValue(int n) {
        if (n < 0 || n >= this.nkeys) {
            return null;
        }
        return this.values[n];
    }

    public synchronized String findNextValue(String string, String string2) {
        boolean bl = false;
        if (string == null) {
            int n = this.nkeys;
            while (--n >= 0) {
                if (this.keys[n] != null) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        } else {
            int n = this.nkeys;
            while (--n >= 0) {
                if (!string.equalsIgnoreCase(this.keys[n])) continue;
                if (bl) {
                    return this.values[n];
                }
                if (this.values[n] != string2) continue;
                bl = true;
            }
        }
        return null;
    }

    public boolean filterNTLMResponses(String string) {
        int n;
        boolean bl = false;
        for (n = 0; n < this.nkeys; ++n) {
            if (!string.equalsIgnoreCase(this.keys[n]) || this.values[n] == null || this.values[n].length() <= 5 || !this.values[n].substring(0, 5).equalsIgnoreCase("NTLM ")) continue;
            bl = true;
            break;
        }
        if (bl) {
            n = 0;
            for (int i = 0; i < this.nkeys; ++i) {
                if (string.equalsIgnoreCase(this.keys[i]) && ("Negotiate".equalsIgnoreCase(this.values[i]) || "Kerberos".equalsIgnoreCase(this.values[i]))) continue;
                if (i != n) {
                    this.keys[n] = this.keys[i];
                    this.values[n] = this.values[i];
                }
                ++n;
            }
            if (n != this.nkeys) {
                this.nkeys = n;
                return true;
            }
        }
        return false;
    }

    public Iterator<String> multiValueIterator(String string) {
        return new HeaderIterator(string, this);
    }

    public synchronized Map<String, List<String>> getHeaders() {
        return this.getHeaders(null);
    }

    public synchronized Map<String, List<String>> getHeaders(String[] stringArray) {
        return this.filterAndAddHeaders(stringArray, null);
    }

    public synchronized Map<String, List<String>> filterAndAddHeaders(String[] stringArray, Map<String, List<String>> map) {
        boolean bl = false;
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        int n = this.nkeys;
        while (--n >= 0) {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || !stringArray[i].equalsIgnoreCase(this.keys[n])) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(this.keys[n]);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(this.keys[n], arrayList);
                }
                arrayList.add(this.values[n]);
                continue;
            }
            bl = false;
        }
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                ArrayList arrayList = (ArrayList)hashMap.get(entry.getKey());
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    hashMap.put(entry.getKey(), arrayList);
                }
                arrayList.addAll(entry.getValue());
            }
        }
        for (String string : hashMap.keySet()) {
            hashMap.put(string, Collections.unmodifiableList((List)hashMap.get(string)));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private boolean isRequestline(String string) {
        String string2 = string.trim();
        int n = string2.lastIndexOf(32);
        if (n <= 0) {
            return false;
        }
        int n2 = string2.length();
        if (n2 - n < 9) {
            return false;
        }
        char c = string2.charAt(n2 - 3);
        char c2 = string2.charAt(n2 - 2);
        char c3 = string2.charAt(n2 - 1);
        if (c < '1' || c > '9') {
            return false;
        }
        if (c2 != '.') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        return string2.substring(n + 1, n2 - 3).equalsIgnoreCase("HTTP/");
    }

    public synchronized void print(PrintStream printStream) {
        for (int i = 0; i < this.nkeys; ++i) {
            if (this.keys[i] == null) continue;
            StringBuilder stringBuilder = new StringBuilder(this.keys[i]);
            if (this.values[i] != null) {
                stringBuilder.append(": " + this.values[i]);
            } else if (i != 0 || !this.isRequestline(this.keys[i])) {
                stringBuilder.append(":");
            }
            printStream.print(stringBuilder.append("\r\n"));
        }
        printStream.print("\r\n");
        printStream.flush();
    }

    public synchronized void add(String string, String string2) {
        this.grow();
        this.keys[this.nkeys] = string;
        this.values[this.nkeys] = string2;
        ++this.nkeys;
    }

    public synchronized void prepend(String string, String string2) {
        this.grow();
        for (int i = this.nkeys; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[0] = string;
        this.values[0] = string2;
        ++this.nkeys;
    }

    public synchronized void set(int n, String string, String string2) {
        this.grow();
        if (n < 0) {
            return;
        }
        if (n >= this.nkeys) {
            this.add(string, string2);
        } else {
            this.keys[n] = string;
            this.values[n] = string2;
        }
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] stringArray = new String[this.nkeys + 4];
            String[] stringArray2 = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy((Object)this.keys, 0, (Object)stringArray, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy((Object)this.values, 0, (Object)stringArray2, 0, this.nkeys);
            }
            this.keys = stringArray;
            this.values = stringArray2;
        }
    }

    public synchronized void remove(String string) {
        if (string == null) {
            for (int i = 0; i < this.nkeys; ++i) {
                while (this.keys[i] == null && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.values[j] = this.values[j + 1];
                    }
                    --this.nkeys;
                }
            }
        } else {
            for (int i = 0; i < this.nkeys; ++i) {
                while (string.equalsIgnoreCase(this.keys[i]) && i < this.nkeys) {
                    for (int j = i; j < this.nkeys - 1; ++j) {
                        this.keys[j] = this.keys[j + 1];
                        this.values[j] = this.values[j + 1];
                    }
                    --this.nkeys;
                }
            }
        }
    }

    public synchronized void set(String string, String string2) {
        int n = this.nkeys;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(this.keys[n])) continue;
            this.values[n] = string2;
            return;
        }
        this.add(string, string2);
    }

    public synchronized void setIfNotSet(String string, String string2) {
        if (this.findValue(string) == null) {
            this.add(string, string2);
        }
    }

    public static String canonicalID(String string) {
        char c;
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        boolean bl = false;
        for (n = 0; n < n2 && ((c = string.charAt(n)) == '<' || c <= ' '); ++n) {
            bl = true;
        }
        while (n < n2 && ((c = string.charAt(n2 - 1)) == '>' || c <= ' ')) {
            --n2;
            bl = true;
        }
        return bl ? string.substring(n, n2) : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHeader(InputStream inputStream) throws IOException {
        MessageHeader messageHeader = this;
        synchronized (messageHeader) {
            this.nkeys = 0;
            this.size = 0L;
        }
        this.mergeHeader(inputStream);
    }

    private void checkMaxHeaderSize(int n) throws ProtocolException {
        if (this.maxHeaderSize > 0) {
            this.checkNewSize(this.size, n, 0);
        }
    }

    private long checkNewSize(long l, int n, int n2) throws ProtocolException {
        long l2 = l + (long)n + (long)n2 + 32L;
        if (this.maxHeaderSize > 0 && l2 > (long)this.maxHeaderSize) {
            Arrays.fill(this.keys, 0, this.nkeys, null);
            Arrays.fill(this.values, 0, this.nkeys, null);
            this.nkeys = 0;
            throw new ProtocolException(String.format("Header size too big: %s > %s", l2, this.maxHeaderSize));
        }
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mergeHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        char[] cArray = new char[10];
        int n = inputStream.read();
        while (true) {
            String string;
            int n2;
            int n3;
            block20: {
                int n4;
                long l;
                boolean bl;
                if (n != 10 && n != 13 && n >= 0) {
                    n3 = 0;
                    n2 = -1;
                    bl = n > 32;
                    cArray[n3++] = (char)n;
                    this.checkMaxHeaderSize(n3);
                    l = this.maxHeaderSize > 0 ? (long)this.maxHeaderSize - this.size - 32L : Long.MAX_VALUE;
                } else {
                    return;
                }
                while ((n4 = inputStream.read()) >= 0) {
                    switch (n4) {
                        case 58: {
                            if (bl && n3 > 0) {
                                n2 = n3;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n4 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n = inputStream.read();
                            if (n4 == 13 && n == 10 && (n = inputStream.read()) == 13) {
                                n = inputStream.read();
                            }
                            if (n == 10 || n == 13 || n > 32) break block20;
                            n4 = 32;
                        }
                    }
                    if (n3 >= cArray.length) {
                        char[] cArray2 = new char[cArray.length * 2];
                        System.arraycopy((Object)cArray, 0, (Object)cArray2, 0, n3);
                        cArray = cArray2;
                    }
                    cArray[n3++] = (char)n4;
                    if (this.maxHeaderSize <= 0 || (long)n3 <= l) continue;
                    this.checkMaxHeaderSize(n3);
                }
                n = -1;
            }
            while (n3 > 0 && cArray[n3 - 1] <= ' ') {
                --n3;
            }
            if (n2 <= 0) {
                string = null;
                n2 = 0;
            } else {
                string = String.copyValueOf(cArray, 0, n2);
                if (n2 < n3 && cArray[n2] == ':') {
                    ++n2;
                }
                while (n2 < n3 && cArray[n2] <= ' ') {
                    ++n2;
                }
            }
            String string2 = n2 >= n3 ? new String() : String.copyValueOf(cArray, n2, n3 - n2);
            int n5 = string == null ? 0 : string.length();
            this.size = this.checkNewSize(this.size, n5, string2.length());
            this.add(string, string2);
        }
    }

    public synchronized String toString() {
        String string = super.toString() + this.nkeys + " pairs: ";
        for (int i = 0; i < this.keys.length && i < this.nkeys; ++i) {
            string = string + "{" + this.keys[i] + ": " + this.values[i] + "}";
        }
        return string;
    }

    class HeaderIterator
    implements Iterator<String> {
        int index = 0;
        int next = -1;
        String key;
        boolean haveNext = false;
        Object lock;

        public HeaderIterator(String string, Object object) {
            this.key = string;
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.lock;
            synchronized (object) {
                if (this.haveNext) {
                    return true;
                }
                while (this.index < MessageHeader.this.nkeys) {
                    if (this.key.equalsIgnoreCase(MessageHeader.this.keys[this.index])) {
                        this.haveNext = true;
                        this.next = this.index++;
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }
        }

        @Override
        public String next() {
            Object object = this.lock;
            synchronized (object) {
                if (this.haveNext) {
                    this.haveNext = false;
                    return MessageHeader.this.values[this.next];
                }
                if (this.hasNext()) {
                    return this.next();
                }
                throw new NoSuchElementException("No more elements");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not allowed");
        }
    }
}

