/*
 * Decompiled with CFR 0.152.
 */
package openj9.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.jvm.Dump;
import com.ibm.jvm.DumpConfigurationUnavailableException;
import com.ibm.jvm.InvalidDumpOptionException;
import com.ibm.oti.util.Msg;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import openj9.lang.management.ConfigurationUnavailableException;
import openj9.lang.management.InvalidOptionException;
import openj9.lang.management.OpenJ9DiagnosticsMXBean;

public final class OpenJ9DiagnosticsMXBeanImpl
implements OpenJ9DiagnosticsMXBean {
    private static final OpenJ9DiagnosticsMXBean instance = OpenJ9DiagnosticsMXBeanImpl.createInstance();

    private static OpenJ9DiagnosticsMXBean createInstance() {
        return new OpenJ9DiagnosticsMXBeanImpl();
    }

    @Override
    public void resetDumpOptions() throws ConfigurationUnavailableException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            Dump.resetDumpOptions();
        }
        catch (Exception exception) {
            this.handleDumpConfigurationUnavailableException(exception);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
        }
    }

    @Override
    public String[] queryDumpOptions() {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            return Dump.queryDumpOptions();
        }
        catch (Exception exception) {
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
        }
    }

    @Override
    public String getDumpOptions() {
        String[] stringArray = this.queryDumpOptions();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    public void setDumpOptions(String string) throws InvalidOptionException, ConfigurationUnavailableException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            Dump.setDumpOptions(string);
        }
        catch (Exception exception) {
            this.handleInvalidDumpOptionException(exception);
            this.handleDumpConfigurationUnavailableException(exception);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
        }
    }

    @Override
    public void triggerDump(String string) throws IllegalArgumentException {
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        switch (string) {
            case "java": {
                Dump.JavaDump();
                break;
            }
            case "heap": {
                Dump.HeapDump();
                break;
            }
            case "system": {
                Dump.SystemDump();
                break;
            }
            case "snap": {
                Dump.SnapDump();
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.getString("K0663"));
            }
        }
    }

    @Override
    public String triggerDumpToFile(String string, String string2) throws IllegalArgumentException, InvalidOptionException {
        String string3 = null;
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        switch (string) {
            case "java": {
                try {
                    string3 = Dump.javaDumpToFile(string2);
                    break;
                }
                catch (Exception exception) {
                    this.handleInvalidDumpOptionException(exception);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
                }
            }
            case "heap": {
                try {
                    string3 = Dump.heapDumpToFile(string2);
                    break;
                }
                catch (Exception exception) {
                    this.handleInvalidDumpOptionException(exception);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
                }
            }
            case "system": {
                try {
                    string3 = Dump.systemDumpToFile(string2);
                    break;
                }
                catch (Exception exception) {
                    this.handleInvalidDumpOptionException(exception);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
                }
            }
            case "snap": {
                try {
                    string3 = Dump.snapDumpToFile(string2);
                    break;
                }
                catch (Exception exception) {
                    this.handleInvalidDumpOptionException(exception);
                    throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
                }
            }
            default: {
                throw new IllegalArgumentException(Msg.getString("K0663"));
            }
        }
        return string3;
    }

    @Override
    public String triggerClassicHeapDump() throws InvalidOptionException {
        String string = "heap:opts=CLASSIC";
        OpenJ9DiagnosticsMXBeanImpl.checkManagementSecurityPermission();
        try {
            String string2 = Dump.triggerDump(string);
            return string2;
        }
        catch (Exception exception) {
            this.handleInvalidDumpOptionException(exception);
            throw OpenJ9DiagnosticsMXBeanImpl.handleError(exception);
        }
    }

    private static void checkManagementSecurityPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
    }

    public static OpenJ9DiagnosticsMXBean getInstance() {
        return instance;
    }

    private OpenJ9DiagnosticsMXBeanImpl() {
    }

    @Override
    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("openj9.lang.management:type=OpenJ9Diagnostics");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InternalError(malformedObjectNameException);
        }
    }

    private static InternalError handleError(Exception exception) {
        throw new InternalError(exception.toString(), exception);
    }

    private void handleInvalidDumpOptionException(Exception exception) throws InvalidOptionException {
        if (exception instanceof InvalidDumpOptionException) {
            throw new InvalidOptionException("Error in dump options specified", exception);
        }
    }

    private void handleDumpConfigurationUnavailableException(Exception exception) throws ConfigurationUnavailableException {
        if (exception instanceof DumpConfigurationUnavailableException) {
            throw new ConfigurationUnavailableException("Dump configuration cannot be changed while a dump is in progress", exception);
        }
    }
}

