/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.vm.VM;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import openj9.internal.management.ClassLoaderInfoBaseImpl;
import openj9.internal.tools.attach.target.Attachment;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.IPC;
import openj9.management.internal.IDCacheInitializer;
import openj9.management.internal.InvalidDumpOptionExceptionBase;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.ThreadInfoBase;

public class DiagnosticUtils {
    private static final String FORMAT_PREFIX = " Format: ";
    private static final String SYNTAX_PREFIX = "Syntax : ";
    private static final String HEAP_DUMP_OPTION_HELP = " [request=<options>] [opts=<options>] [<file path>]%n Set optional request= and opts= -Xdump options. The order of the parameters does not matter.%n";
    private static final String OTHER_DUMP_OPTION_HELP = " [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n";
    private static final String HEAPSYSTEM_DUMP_OPTION_HELP = " system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n";
    private static final String GENERIC_DUMP_OPTION_HELP = " <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_HELP = "help";
    private static final String DIAGNOSTICS_THREAD_PRINT = "Thread.print";
    private static final String DIAGNOSTICS_GC_RUN = "GC.run";
    private static final String DIAGNOSTICS_GC_CLASS_HISTOGRAM = "GC.class_histogram";
    private static final String DIAGNOSTICS_DUMP_HEAP = "Dump.heap";
    private static final String DIAGNOSTICS_GC_HEAP_DUMP = "GC.heap_dump";
    private static final String DIAGNOSTICS_DUMP_JAVA = "Dump.java";
    private static final String DIAGNOSTICS_DUMP_SNAP = "Dump.snap";
    private static final String DIAGNOSTICS_DUMP_SYSTEM = "Dump.system";
    private static final String DIAGNOSTICS_STAT_CLASS = "jstat.class";
    private static final String DIAGNOSTICS_LOAD_JVMTI_AGENT = "JVMTI.agent_load";
    public static final String COMMAND_STRING = "command_string";
    public static final String DIAGNOSTICS_OPTION_SEPARATOR = ",";
    public static final String DIAGNOSTICS_PROPERTY_SEPARATOR = "=";
    private static final String ALL_OPTION = "all";
    private static final String LIVE_OPTION = "live";
    private static final String THREAD_LOCKED_SYNCHRONIZERS_OPTION = "-l";
    private static final Map<String, Function<String, DiagnosticProperties>> commandTable;
    private static final Map<String, String> helpTable;
    private static final String DIAGNOSTICS_HELP_HELP = "Show help for a command%n Format:  help <command>%n If no command is supplied, print the list of available commands on the target JVM.%n";
    private static final String DIAGNOSTICS_GC_CLASS_HISTOGRAM_HELP = "Obtain heap information about a Java process%n Format: GC.class_histogram [options]%n Options:%n          all : include all objects, including dead objects (this is the default option)%n         live : include all objects after a global GC collection%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_GC_RUN_HELP = "Run the garbage collector.%n Format: GC.run%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_THREAD_PRINT_HELP = "List thread information.%n Format: Thread.print [options]%n Options: -l : print information about ownable synchronizers%n";
    private static final String DIAGNOSTICS_DUMP_HEAP_HELP = "Create a heap dump.%n Format: Dump.heap [request=<options>] [opts=<options>] [<file path>]%n Set optional request= and opts= -Xdump options. The order of the parameters does not matter.%n system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%nGC.heap_dump is an alias for Dump.heap%n";
    private static final String DIAGNOSTICS_DUMP_JAVA_HELP = "Create a javacore file.%n Format: Dump.java [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_DUMP_SNAP_HELP = "Dump the snap trace buffer.%n Format: Dump.snap [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_DUMP_SYSTEM_HELP = "Create a native core file.%n Format: Dump.system [request=<options>] [<file path>]%n Set optional request= -Xdump options. The order of the parameters does not matter.%n system and heap dumps default to request=exclusive+prepwalk rather than the -Xdump:<type>:defaults setting.%n <file path> is optional, otherwise a default path/name is used.%n Relative paths are resolved to the target's working directory.%n The dump agent may choose a different file path if the requested file exists.%n";
    private static final String DIAGNOSTICS_JSTAT_CLASS_HELP = "Show JVM classloader statistics.%n Format: jstat.class%nNOTE: this utility might significantly affect the performance of the target VM.%n";
    private static final String DIAGNOSTICS_LOAD_JVMTI_AGENT_HELP = "Load JVMTI agent.%n Format: JVMTI.agent_load <agentLibrary> [<agent option>]%n          agentLibrary: the absolute path of the agent%n          agent option: (Optional) the agent option string%n";

    public static String makeHeapHistoCommand(boolean bl) {
        String string = DIAGNOSTICS_GC_CLASS_HISTOGRAM;
        if (bl) {
            string = "GC.class_histogram,live";
        }
        return string;
    }

    public static String makeThreadPrintCommand(boolean bl) {
        String string = bl ? "Thread.print,-l" : DIAGNOSTICS_THREAD_PRINT;
        return string;
    }

    public static String makeJcmdCommand(String[] stringArray, int n) {
        int n2 = stringArray.length;
        String string = String.join((CharSequence)DIAGNOSTICS_OPTION_SEPARATOR, Arrays.asList(stringArray).subList(n, n2));
        return string;
    }

    private static native String getHeapClassStatisticsImpl();

    private static native String triggerDumpsImpl(String var0, String var1) throws InvalidDumpOptionExceptionBase;

    static DiagnosticProperties executeDiagnosticCommand(String string) {
        DiagnosticProperties diagnosticProperties;
        IPC.logMessage("executeDiagnosticCommand: ", string);
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        Function<String, DiagnosticProperties> function = commandTable.get(stringArray[0]);
        if (null == function) {
            diagnosticProperties = DiagnosticProperties.makeStatusProperties(true, "Command " + string + " not recognized");
        } else {
            diagnosticProperties = function.apply(string);
            diagnosticProperties.put(COMMAND_STRING, string);
        }
        return diagnosticProperties;
    }

    private static DiagnosticProperties getHeapStatistics(String string) {
        DiagnosticProperties diagnosticProperties = null;
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (stringArray.length > 2) {
            bl = true;
        } else if (stringArray.length == 2) {
            if (LIVE_OPTION.equalsIgnoreCase(stringArray[1])) {
                bl2 = true;
            } else if (!ALL_OPTION.equalsIgnoreCase(stringArray[1])) {
                bl = true;
            }
        }
        if (bl) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Command not recognized: " + string);
        } else {
            if (bl2) {
                DiagnosticUtils.runGC();
            }
            String string2 = DiagnosticUtils.getHeapClassStatisticsImpl();
            String string3 = System.lineSeparator();
            if (!"\n".equals(string3)) {
                string2 = string2.replace("\n", string3);
            }
            diagnosticProperties = DiagnosticProperties.makeStringResult(string2);
        }
        return diagnosticProperties;
    }

    private static DiagnosticProperties getThreadInfo(String string) {
        Object object;
        DiagnosticProperties diagnosticProperties = null;
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (stringArray.length > 2) {
            bl = false;
        } else if (stringArray.length == 2) {
            object = stringArray[1];
            if (((String)object).startsWith(THREAD_LOCKED_SYNCHRONIZERS_OPTION)) {
                if (THREAD_LOCKED_SYNCHRONIZERS_OPTION.length() == ((String)object).length() || ((String)object).toLowerCase().equals("-l=true")) {
                    bl2 = true;
                }
            } else {
                bl = false;
            }
        }
        if (!bl) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Command not recognized: " + string);
        } else {
            ThreadInfoBase[] threadInfoBaseArray;
            object = new StringWriter(2000);
            PrintWriter printWriter = new PrintWriter((Writer)object);
            printWriter.println(System.getProperty("java.vm.info"));
            printWriter.println();
            for (ThreadInfoBase threadInfoBase : threadInfoBaseArray = DiagnosticUtils.dumpAllThreadsImpl(true, bl2, Integer.MAX_VALUE)) {
                printWriter.print(threadInfoBase.toString());
                if (bl2) {
                    LockInfoBase[] lockInfoBaseArray = threadInfoBase.getLockedSynchronizers();
                    printWriter.printf("%n\tLocked ownable synchronizers: %d%n", lockInfoBaseArray.length);
                    for (LockInfoBase lockInfoBase : lockInfoBaseArray) {
                        printWriter.printf("\t- %s%n", lockInfoBase.toString());
                    }
                }
                printWriter.println();
            }
            printWriter.flush();
            diagnosticProperties = DiagnosticProperties.makeStringResult(((StringWriter)object).toString());
        }
        return diagnosticProperties;
    }

    private static DiagnosticProperties doDump(String string) {
        DiagnosticProperties diagnosticProperties = null;
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        IPC.logMessage("doDump: ", string);
        if (stringArray.length == 0 || stringArray.length > 4) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Error: wrong number of arguments");
        } else {
            Object object;
            Object object2 = "";
            if (DIAGNOSTICS_GC_HEAP_DUMP.equals(stringArray[0])) {
                object2 = "heap";
            } else {
                object = stringArray[0].split("\\.");
                if (((String[])object).length != 2) {
                    diagnosticProperties = DiagnosticProperties.makeErrorProperties(String.format("Error: invalid command %s", stringArray[0]));
                } else {
                    object2 = object[1];
                }
            }
            if (!((String)object2).isEmpty()) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                String string2 = null;
                boolean bl = false;
                boolean bl2 = "heap".equals(object2);
                boolean bl3 = "system".equals(object2);
                String string3 = ":";
                for (int i = 1; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    boolean bl4 = string4.startsWith("request=");
                    boolean bl5 = string4.startsWith("opts=");
                    if (bl4 || bl5) {
                        if (!bl2 && bl5) continue;
                        ((StringBuilder)object).append(string3).append(string4);
                        if (bl4) {
                            bl = true;
                        }
                    } else {
                        if (string2 != null) {
                            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Error: second <file path> found, \"" + string4 + "\" after \"" + string2 + "\"");
                            break;
                        }
                        String string5 = bl3 && IPC.isZOS ? "dsn=" : "file=";
                        ((StringBuilder)object).append(string3).append(string5).append(string4);
                        string2 = string4;
                    }
                    string3 = DIAGNOSTICS_OPTION_SEPARATOR;
                }
                if (diagnosticProperties == null) {
                    if (!bl && (bl3 || bl2)) {
                        ((StringBuilder)object).append(string3).append("request=exclusive+prepwalk");
                    }
                    try {
                        String string6 = DiagnosticUtils.triggerDumpsImpl(((StringBuilder)object).toString(), (String)object2 + "DumpToFile");
                        diagnosticProperties = DiagnosticProperties.makeStringResult("Dump written to " + string6);
                    }
                    catch (InvalidDumpOptionExceptionBase invalidDumpOptionExceptionBase) {
                        IPC.logMessage("doDump exception: ", invalidDumpOptionExceptionBase.getMessage());
                        diagnosticProperties = DiagnosticProperties.makeExceptionProperties(invalidDumpOptionExceptionBase);
                    }
                }
            }
        }
        return diagnosticProperties;
    }

    private static native ThreadInfoBase[] dumpAllThreadsImpl(boolean var0, boolean var1, int var2);

    private static DiagnosticProperties runGC() {
        VM.globalGC();
        return DiagnosticProperties.makeCommandSucceeded();
    }

    private static DiagnosticProperties getJstatClass(String string) {
        IPC.logMessage("jstat command : ", string);
        StringWriter stringWriter = new StringWriter(100);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Class Loaded    Class Unloaded");
        printWriter.printf("%12d    %14d%n", ClassLoaderInfoBaseImpl.getLoadedClassCountImpl(), ClassLoaderInfoBaseImpl.getUnloadedClassCountImpl());
        printWriter.flush();
        return DiagnosticProperties.makeStringResult(stringWriter.toString());
    }

    private static DiagnosticProperties loadJVMTIAgent(String string) {
        DiagnosticProperties diagnosticProperties;
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (stringArray.length < 2) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Too few arguments, the absolute path of the agent is required: " + string);
        } else if (stringArray.length > 3) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Command not recognized due to more than 3 arguments: " + string);
        } else {
            String string2 = Attachment.loadAgentLibrary(stringArray[1], stringArray.length == 3 ? stringArray[2] : "", false);
            diagnosticProperties = string2 == null ? DiagnosticProperties.makeStringResult("JVMTI.agent_load succeeded") : DiagnosticProperties.makeStatusProperties(true, string2);
        }
        return diagnosticProperties;
    }

    private static DiagnosticProperties doHelp(String string2) {
        String[] stringArray = string2.split(DIAGNOSTICS_OPTION_SEPARATOR);
        StringWriter stringWriter = new StringWriter(500);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (DIAGNOSTICS_HELP.equals(stringArray[0])) {
            if (stringArray.length == 1) {
                commandTable.keySet().stream().sorted().forEach(string -> printWriter.println((String)string));
            } else if (stringArray.length == 2) {
                String string3 = helpTable.getOrDefault(stringArray[1], "No help available");
                printWriter.printf("%s: ", stringArray[1]);
                printWriter.printf(string3, new Object[0]);
            }
        } else {
            printWriter.print("Invalid command: " + string2);
        }
        return DiagnosticProperties.makeStringResult(stringWriter.toString());
    }

    static {
        IDCacheInitializer.init();
        commandTable = new HashMap<String, Function<String, DiagnosticProperties>>();
        helpTable = new HashMap<String, String>();
        commandTable.put(DIAGNOSTICS_HELP, DiagnosticUtils::doHelp);
        helpTable.put(DIAGNOSTICS_HELP, DIAGNOSTICS_HELP_HELP);
        commandTable.put(DIAGNOSTICS_GC_CLASS_HISTOGRAM, DiagnosticUtils::getHeapStatistics);
        helpTable.put(DIAGNOSTICS_GC_CLASS_HISTOGRAM, DIAGNOSTICS_GC_CLASS_HISTOGRAM_HELP);
        commandTable.put(DIAGNOSTICS_GC_RUN, string -> DiagnosticUtils.runGC());
        helpTable.put(DIAGNOSTICS_GC_RUN, DIAGNOSTICS_GC_RUN_HELP);
        commandTable.put(DIAGNOSTICS_THREAD_PRINT, DiagnosticUtils::getThreadInfo);
        helpTable.put(DIAGNOSTICS_THREAD_PRINT, DIAGNOSTICS_THREAD_PRINT_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_HEAP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_HEAP, DIAGNOSTICS_DUMP_HEAP_HELP);
        commandTable.put(DIAGNOSTICS_GC_HEAP_DUMP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_GC_HEAP_DUMP, DIAGNOSTICS_DUMP_HEAP_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_JAVA, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_JAVA, DIAGNOSTICS_DUMP_JAVA_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_SNAP, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_SNAP, DIAGNOSTICS_DUMP_SNAP_HELP);
        commandTable.put(DIAGNOSTICS_DUMP_SYSTEM, DiagnosticUtils::doDump);
        helpTable.put(DIAGNOSTICS_DUMP_SYSTEM, DIAGNOSTICS_DUMP_SYSTEM_HELP);
        commandTable.put(DIAGNOSTICS_STAT_CLASS, DiagnosticUtils::getJstatClass);
        helpTable.put(DIAGNOSTICS_STAT_CLASS, DIAGNOSTICS_JSTAT_CLASS_HELP);
        commandTable.put(DIAGNOSTICS_LOAD_JVMTI_AGENT, DiagnosticUtils::loadJVMTIAgent);
        helpTable.put(DIAGNOSTICS_LOAD_JVMTI_AGENT, DIAGNOSTICS_LOAD_JVMTI_AGENT_HELP);
    }
}

