/*
 * Decompiled with CFR 0.152.
 */
package openj9.internal.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

public final class Advertisement {
    private static final String KEY_ATTACH_NOTIFICATION_SYNC = "attachNotificationSync";
    private static final String KEY_REPLY_FILE = "replyFile";
    private static final String KEY_NOTIFIER = "notifier";
    private static final String KEY_DISPLAY_NAME = "displayName";
    private static final String KEY_VM_ID = "vmId";
    private static final String KEY_USER_UID = "userUid";
    private static final String KEY_USER_ID = "userId";
    private static final String KEY_VERSION = "version";
    private static final String KEY_PROCESS_ID = "processId";
    private static final String ADVERT_FILENAME = "attachInfo";
    private static final String GLOBAL_SEMAPHORE = "globalSemaphore";
    private Properties props = new Properties();
    private final long pid;
    private final long uid;

    private Advertisement(InputStream inputStream) throws IOException {
        long l;
        try {
            this.props.load(inputStream);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(Msg.getString("K0556"), illegalArgumentException);
        }
        try {
            l = Long.parseLong(this.props.getProperty(KEY_PROCESS_ID));
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        this.pid = l;
        try {
            l = Long.parseLong(this.props.getProperty(KEY_USER_UID));
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
        }
        if (null == this.props.getProperty(KEY_VM_ID) || null == this.props.getProperty(KEY_DISPLAY_NAME)) {
            throw new IOException(Msg.getString("K0554"));
        }
        this.uid = l;
    }

    public static Advertisement readAdvertisementFile(InputStream inputStream) throws IOException {
        Advertisement advertisement = null;
        try {
            advertisement = new Advertisement(inputStream);
        }
        catch (IOException iOException) {
            IPC.logMessage("IOException opening advertisement ", iOException.getMessage());
            throw iOException;
        }
        return advertisement;
    }

    private static StringBuilder createAdvertContent(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(512);
        Advertisement.addKeyAsciiValue(stringBuilder, KEY_VERSION, "0.1");
        Advertisement.addKeyValue(stringBuilder, KEY_USER_ID, VM.internalGetProperties().getProperty("user.name"));
        Advertisement.addKeyAsciiValue(stringBuilder, KEY_USER_UID, Long.toString(IPC.getUid()));
        Advertisement.addKeyAsciiValue(stringBuilder, KEY_PROCESS_ID, Long.toString(IPC.getProcessId()));
        Advertisement.addKeyValue(stringBuilder, KEY_VM_ID, string);
        Advertisement.addKeyValue(stringBuilder, KEY_DISPLAY_NAME, null == string2 || string2.length() == 0 ? string : string2);
        Advertisement.addKeyValue(stringBuilder, KEY_NOTIFIER, "_notifier");
        Advertisement.addKeyValue(stringBuilder, GLOBAL_SEMAPHORE, Boolean.TRUE.toString());
        File file = TargetDirectory.getTargetDirectoryFileObject();
        File file2 = TargetDirectory.getSyncFileObject();
        if (null != file && null != file2) {
            Advertisement.addKeyValue(stringBuilder, KEY_REPLY_FILE, new File(file, "replyInfo").getPath());
            Advertisement.addKeyValue(stringBuilder, KEY_ATTACH_NOTIFICATION_SYNC, file2.getAbsolutePath());
            return stringBuilder;
        }
        return null;
    }

    private static void addKeyValue(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        Advertisement.encodeString(stringBuilder, string2);
        stringBuilder.append('\n');
    }

    private static void addKeyAsciiValue(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
        stringBuilder.append('\n');
    }

    private static void encodeString(StringBuilder stringBuilder, String string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                default: {
                    if ("\\#!=:".indexOf(c) >= 0 || c == ' ') {
                        stringBuilder.append('\\');
                    }
                    if (c >= ' ' && c <= '~') {
                        stringBuilder.append(c);
                        continue block6;
                    }
                    String string2 = Integer.toHexString(c);
                    stringBuilder.append("\\u");
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string2);
                }
            }
        }
    }

    static void createAdvertisementFile(String string, String string2) throws IOException {
        if (AttachHandler.isAttachApiTerminated()) {
            return;
        }
        File file = TargetDirectory.getAdvertisementFileObject();
        IPC.createNewFileWithPermissions(file, 384);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            StringBuilder stringBuilder = Advertisement.createAdvertContent(string, string2);
            if (null == stringBuilder) {
                IPC.logMessage("createAdvertisementFile failed to create advertisement file : file object is null");
                return;
            }
            fileOutputStream.write(stringBuilder.toString().getBytes("ISO8859_1"));
            if (1 != IPC.loggingStatus) {
                IPC.logMessage("createAdvertisementFile ", file.getAbsolutePath());
            }
        }
    }

    public static String getFilename() {
        return ADVERT_FILENAME;
    }

    public String getDisplayName() {
        return this.props.getProperty(KEY_DISPLAY_NAME);
    }

    public long getProcessId() {
        return this.pid;
    }

    public String getVmId() {
        return this.props.getProperty(KEY_VM_ID);
    }

    String getNotifier() {
        return this.props.getProperty(KEY_NOTIFIER);
    }

    public String getReplyFile() {
        return this.props.getProperty(KEY_REPLY_FILE);
    }

    public long getUid() {
        return this.uid;
    }

    public boolean isGlobalSemaphore() {
        return Boolean.parseBoolean(this.props.getProperty(GLOBAL_SEMAPHORE));
    }

    public String getNotificationSync() {
        return this.props.getProperty(KEY_ATTACH_NOTIFICATION_SYNC);
    }
}

