/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayPrefixHelpers;
import java.util.ArraysParallelSortHelpers;
import java.util.ComparableTimSort;
import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TimSort;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sun.security.action.GetBooleanAction;

public class Arrays {
    private static final int MIN_ARRAY_SORT_GRAN = 8192;
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    public static void sort(int[] nArray) {
        DualPivotQuicksort.sort(nArray, 0, nArray.length - 1, null, 0, 0);
    }

    public static void sort(int[] nArray, int n, int n2) {
        Arrays.rangeCheck(nArray.length, n, n2);
        DualPivotQuicksort.sort(nArray, n, n2 - 1, null, 0, 0);
    }

    public static void sort(long[] lArray) {
        DualPivotQuicksort.sort(lArray, 0, lArray.length - 1, null, 0, 0);
    }

    public static void sort(long[] lArray, int n, int n2) {
        Arrays.rangeCheck(lArray.length, n, n2);
        DualPivotQuicksort.sort(lArray, n, n2 - 1, null, 0, 0);
    }

    public static void sort(short[] sArray) {
        DualPivotQuicksort.sort(sArray, 0, sArray.length - 1, null, 0, 0);
    }

    public static void sort(short[] sArray, int n, int n2) {
        Arrays.rangeCheck(sArray.length, n, n2);
        DualPivotQuicksort.sort(sArray, n, n2 - 1, null, 0, 0);
    }

    public static void sort(char[] cArray) {
        DualPivotQuicksort.sort(cArray, 0, cArray.length - 1, null, 0, 0);
    }

    public static void sort(char[] cArray, int n, int n2) {
        Arrays.rangeCheck(cArray.length, n, n2);
        DualPivotQuicksort.sort(cArray, n, n2 - 1, null, 0, 0);
    }

    public static void sort(byte[] byArray) {
        DualPivotQuicksort.sort(byArray, 0, byArray.length - 1);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        Arrays.rangeCheck(byArray.length, n, n2);
        DualPivotQuicksort.sort(byArray, n, n2 - 1);
    }

    public static void sort(float[] fArray) {
        DualPivotQuicksort.sort(fArray, 0, fArray.length - 1, null, 0, 0);
    }

    public static void sort(float[] fArray, int n, int n2) {
        Arrays.rangeCheck(fArray.length, n, n2);
        DualPivotQuicksort.sort(fArray, n, n2 - 1, null, 0, 0);
    }

    public static void sort(double[] dArray) {
        DualPivotQuicksort.sort(dArray, 0, dArray.length - 1, null, 0, 0);
    }

    public static void sort(double[] dArray, int n, int n2) {
        Arrays.rangeCheck(dArray.length, n, n2);
        DualPivotQuicksort.sort(dArray, n, n2 - 1, null, 0, 0);
    }

    public static void parallelSort(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(byArray, 0, n2 - 1);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJByte.Sorter(null, byArray, new byte[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(byte[] byArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(byArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(byArray, n, n2 - 1);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJByte.Sorter(null, byArray, new byte[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(char[] cArray) {
        int n;
        int n2 = cArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(cArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJChar.Sorter(null, cArray, new char[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(char[] cArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(cArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(cArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJChar.Sorter(null, cArray, new char[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(short[] sArray) {
        int n;
        int n2 = sArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(sArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJShort.Sorter(null, sArray, new short[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(short[] sArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(sArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(sArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJShort.Sorter(null, sArray, new short[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(int[] nArray) {
        int n;
        int n2 = nArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(nArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJInt.Sorter(null, nArray, new int[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(int[] nArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(nArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(nArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJInt.Sorter(null, nArray, new int[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(long[] lArray) {
        int n;
        int n2 = lArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(lArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJLong.Sorter(null, lArray, new long[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(long[] lArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(lArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(lArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJLong.Sorter(null, lArray, new long[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(float[] fArray) {
        int n;
        int n2 = fArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(fArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJFloat.Sorter(null, fArray, new float[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(float[] fArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(fArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(fArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJFloat.Sorter(null, fArray, new float[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static void parallelSort(double[] dArray) {
        int n;
        int n2 = dArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(dArray, 0, n2 - 1, null, 0, 0);
        } else {
            int n3 = n2 / (n << 2);
            new ArraysParallelSortHelpers.FJDouble.Sorter(null, dArray, new double[n2], 0, n2, 0, n3 <= 8192 ? 8192 : n3).invoke();
        }
    }

    public static void parallelSort(double[] dArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(dArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            DualPivotQuicksort.sort(dArray, n, n2 - 1, null, 0, 0);
        } else {
            int n5 = n4 / (n3 << 2);
            new ArraysParallelSortHelpers.FJDouble.Sorter(null, dArray, new double[n4], n, n4, 0, n5 <= 8192 ? 8192 : n5).invoke();
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] TArray) {
        int n;
        int n2 = TArray.length;
        if (n2 <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(TArray, 0, n2, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int n3;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, TArray, (Comparable[])Array.newInstance(TArray.getClass().getComponentType(), n2), 0, n2, 0, (n3 = n2 / (n << 2)) <= 8192 ? 8192 : n3, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T extends Comparable<? super T>> void parallelSort(T[] TArray, int n, int n2) {
        int n3;
        Arrays.rangeCheck(TArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(TArray, n, n2, NaturalOrder.INSTANCE, null, 0, 0);
        } else {
            int n5;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, TArray, (Comparable[])Array.newInstance(TArray.getClass().getComponentType(), n4), n, n4, 0, (n5 = n4 / (n3 << 2)) <= 8192 ? 8192 : n5, NaturalOrder.INSTANCE).invoke();
        }
    }

    public static <T> void parallelSort(T[] TArray, Comparator<? super T> naturalOrder) {
        int n;
        int n2;
        if (naturalOrder == null) {
            naturalOrder = NaturalOrder.INSTANCE;
        }
        if ((n2 = TArray.length) <= 8192 || (n = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(TArray, 0, n2, naturalOrder, null, 0, 0);
        } else {
            int n3;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, TArray, (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2), 0, n2, 0, (n3 = n2 / (n << 2)) <= 8192 ? 8192 : n3, naturalOrder).invoke();
        }
    }

    public static <T> void parallelSort(T[] TArray, int n, int n2, Comparator<? super T> naturalOrder) {
        int n3;
        int n4;
        Arrays.rangeCheck(TArray.length, n, n2);
        if (naturalOrder == null) {
            naturalOrder = NaturalOrder.INSTANCE;
        }
        if ((n4 = n2 - n) <= 8192 || (n3 = ForkJoinPool.getCommonPoolParallelism()) == 1) {
            TimSort.sort(TArray, n, n2, naturalOrder, null, 0, 0);
        } else {
            int n5;
            new ArraysParallelSortHelpers.FJObject.Sorter<Object>(null, TArray, (Object[])Array.newInstance(TArray.getClass().getComponentType(), n4), n, n4, 0, (n5 = n4 / (n3 << 2)) <= 8192 ? 8192 : n5, naturalOrder).invoke();
        }
    }

    public static void sort(Object[] objectArray) {
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(objectArray);
        } else {
            ComparableTimSort.sort(objectArray, 0, objectArray.length, null, 0, 0);
        }
    }

    private static void legacyMergeSort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(objectArray, n, n2);
        } else {
            ComparableTimSort.sort(objectArray, n, n2, null, 0, 0);
        }
    }

    private static void legacyMergeSort(Object[] objectArray, int n, int n2) {
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, n, n2);
        Arrays.mergeSort(objectArray2, objectArray, n, n2, -n);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray2[j - 1]).compareTo(objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3);
        if (((Comparable)objectArray[n7 - 1]).compareTo(objectArray[n7]) <= 0) {
            System.arraycopy((Object)objectArray, n, (Object)objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && ((Comparable)objectArray[n8]).compareTo(objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        if (comparator == null) {
            Arrays.sort(TArray);
        } else if (LegacyMergeSort.userRequested) {
            Arrays.legacyMergeSort(TArray, comparator);
        } else {
            TimSort.sort(TArray, 0, TArray.length, comparator, null, 0, 0);
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, Comparator<? super T> comparator) {
        Object[] objectArray = (Object[])TArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0);
        } else {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0, comparator);
        }
    }

    public static <T> void sort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        if (comparator == null) {
            Arrays.sort(TArray, n, n2);
        } else {
            Arrays.rangeCheck(TArray.length, n, n2);
            if (LegacyMergeSort.userRequested) {
                Arrays.legacyMergeSort(TArray, n, n2, comparator);
            } else {
                TimSort.sort(TArray, n, n2, comparator, null, 0, 0);
            }
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        Object[] objectArray = Arrays.copyOfRange(TArray, n, n2);
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, n, n2, -n);
        } else {
            Arrays.mergeSort(objectArray, TArray, n, n2, -n, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Comparator comparator) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3, comparator);
        if (comparator.compare(objectArray[n7 - 1], objectArray[n7]) <= 0) {
            System.arraycopy((Object)objectArray, n, (Object)objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && comparator.compare(objectArray[n8], objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    public static <T> void parallelPrefix(T[] TArray, BinaryOperator<T> binaryOperator) {
        Objects.requireNonNull(binaryOperator);
        if (TArray.length > 0) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, binaryOperator, TArray, 0, TArray.length).invoke();
        }
    }

    public static <T> void parallelPrefix(T[] TArray, int n, int n2, BinaryOperator<T> binaryOperator) {
        Objects.requireNonNull(binaryOperator);
        Arrays.rangeCheck(TArray.length, n, n2);
        if (n < n2) {
            new ArrayPrefixHelpers.CumulateTask<T>(null, binaryOperator, TArray, n, n2).invoke();
        }
    }

    public static void parallelPrefix(long[] lArray, LongBinaryOperator longBinaryOperator) {
        Objects.requireNonNull(longBinaryOperator);
        if (lArray.length > 0) {
            new ArrayPrefixHelpers.LongCumulateTask(null, longBinaryOperator, lArray, 0, lArray.length).invoke();
        }
    }

    public static void parallelPrefix(long[] lArray, int n, int n2, LongBinaryOperator longBinaryOperator) {
        Objects.requireNonNull(longBinaryOperator);
        Arrays.rangeCheck(lArray.length, n, n2);
        if (n < n2) {
            new ArrayPrefixHelpers.LongCumulateTask(null, longBinaryOperator, lArray, n, n2).invoke();
        }
    }

    public static void parallelPrefix(double[] dArray, DoubleBinaryOperator doubleBinaryOperator) {
        Objects.requireNonNull(doubleBinaryOperator);
        if (dArray.length > 0) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, doubleBinaryOperator, dArray, 0, dArray.length).invoke();
        }
    }

    public static void parallelPrefix(double[] dArray, int n, int n2, DoubleBinaryOperator doubleBinaryOperator) {
        Objects.requireNonNull(doubleBinaryOperator);
        Arrays.rangeCheck(dArray.length, n, n2);
        if (n < n2) {
            new ArrayPrefixHelpers.DoubleCumulateTask(null, doubleBinaryOperator, dArray, n, n2).invoke();
        }
    }

    public static void parallelPrefix(int[] nArray, IntBinaryOperator intBinaryOperator) {
        Objects.requireNonNull(intBinaryOperator);
        if (nArray.length > 0) {
            new ArrayPrefixHelpers.IntCumulateTask(null, intBinaryOperator, nArray, 0, nArray.length).invoke();
        }
    }

    public static void parallelPrefix(int[] nArray, int n, int n2, IntBinaryOperator intBinaryOperator) {
        Objects.requireNonNull(intBinaryOperator);
        Arrays.rangeCheck(nArray.length, n, n2);
        if (n < n2) {
            new ArrayPrefixHelpers.IntCumulateTask(null, intBinaryOperator, nArray, n, n2).invoke();
        }
    }

    public static int binarySearch(long[] lArray, long l) {
        return Arrays.binarySearch0(lArray, 0, lArray.length, l);
    }

    public static int binarySearch(long[] lArray, int n, int n2, long l) {
        Arrays.rangeCheck(lArray.length, n, n2);
        return Arrays.binarySearch0(lArray, n, n2, l);
    }

    private static int binarySearch0(long[] lArray, int n, int n2, long l) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            long l2 = lArray[n5];
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            if (l2 > l) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(int[] nArray, int n) {
        return Arrays.binarySearch0(nArray, 0, nArray.length, n);
    }

    public static int binarySearch(int[] nArray, int n, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n, n2);
        return Arrays.binarySearch0(nArray, n, n2, n3);
    }

    private static int binarySearch0(int[] nArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = nArray[n6];
            if (n7 < n3) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n3) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(short[] sArray, short s) {
        return Arrays.binarySearch0(sArray, 0, sArray.length, s);
    }

    public static int binarySearch(short[] sArray, int n, int n2, short s) {
        Arrays.rangeCheck(sArray.length, n, n2);
        return Arrays.binarySearch0(sArray, n, n2, s);
    }

    private static int binarySearch0(short[] sArray, int n, int n2, short s) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            short s2 = sArray[n5];
            if (s2 < s) {
                n3 = n5 + 1;
                continue;
            }
            if (s2 > s) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(char[] cArray, char c) {
        return Arrays.binarySearch0(cArray, 0, cArray.length, c);
    }

    public static int binarySearch(char[] cArray, int n, int n2, char c) {
        Arrays.rangeCheck(cArray.length, n, n2);
        return Arrays.binarySearch0(cArray, n, n2, c);
    }

    private static int binarySearch0(char[] cArray, int n, int n2, char c) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            char c2 = cArray[n5];
            if (c2 < c) {
                n3 = n5 + 1;
                continue;
            }
            if (c2 > c) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        return Arrays.binarySearch0(byArray, 0, byArray.length, by);
    }

    public static int binarySearch(byte[] byArray, int n, int n2, byte by) {
        Arrays.rangeCheck(byArray.length, n, n2);
        return Arrays.binarySearch0(byArray, n, n2, by);
    }

    private static int binarySearch0(byte[] byArray, int n, int n2, byte by) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            byte by2 = byArray[n5];
            if (by2 < by) {
                n3 = n5 + 1;
                continue;
            }
            if (by2 > by) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(double[] dArray, double d) {
        return Arrays.binarySearch0(dArray, 0, dArray.length, d);
    }

    public static int binarySearch(double[] dArray, int n, int n2, double d) {
        Arrays.rangeCheck(dArray.length, n, n2);
        return Arrays.binarySearch0(dArray, n, n2, d);
    }

    private static int binarySearch0(double[] dArray, int n, int n2, double d) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            long l;
            int n5 = n3 + n4 >>> 1;
            double d2 = dArray[n5];
            if (d2 < d) {
                n3 = n5 + 1;
                continue;
            }
            if (d2 > d) {
                n4 = n5 - 1;
                continue;
            }
            long l2 = Double.doubleToLongBits(d2);
            if (l2 == (l = Double.doubleToLongBits(d))) {
                return n5;
            }
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(float[] fArray, float f) {
        return Arrays.binarySearch0(fArray, 0, fArray.length, f);
    }

    public static int binarySearch(float[] fArray, int n, int n2, float f) {
        Arrays.rangeCheck(fArray.length, n, n2);
        return Arrays.binarySearch0(fArray, n, n2, f);
    }

    private static int binarySearch0(float[] fArray, int n, int n2, float f) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = n3 + n4 >>> 1;
            float f2 = fArray[n6];
            if (f2 < f) {
                n3 = n6 + 1;
                continue;
            }
            if (f2 > f) {
                n4 = n6 - 1;
                continue;
            }
            int n7 = Float.floatToIntBits(f2);
            if (n7 == (n5 = Float.floatToIntBits(f))) {
                return n6;
            }
            if (n7 < n5) {
                n3 = n6 + 1;
                continue;
            }
            n4 = n6 - 1;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch0(objectArray, 0, objectArray.length, object);
    }

    public static int binarySearch(Object[] objectArray, int n, int n2, Object object) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        return Arrays.binarySearch0(objectArray, n, n2, object);
    }

    private static int binarySearch0(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Comparable comparable = (Comparable)objectArray[n5];
            int n6 = comparable.compareTo(object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static <T> int binarySearch(T[] TArray, T t, Comparator<? super T> comparator) {
        return Arrays.binarySearch0(TArray, 0, TArray.length, t, comparator);
    }

    public static <T> int binarySearch(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        Arrays.rangeCheck(TArray.length, n, n2);
        return Arrays.binarySearch0(TArray, n, n2, t, comparator);
    }

    private static <T> int binarySearch0(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch0(TArray, n, n2, t);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            T t2 = TArray[n5];
            int n6 = comparator.compare(t2, t);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n = lArray.length;
        if (lArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n = sArray.length;
        if (sArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = cArray.length;
        if (cArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n = blArray.length;
        if (blArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n = dArray.length;
        if (dArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n = fArray.length;
        if (fArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Float.floatToIntBits(fArray[i]) == Float.floatToIntBits(fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        Arrays.rangeCheck(lArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            nArray[i] = n3;
        }
    }

    public static void fill(short[] sArray, short s) {
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        Arrays.rangeCheck(sArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(char[] cArray, char c) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        Arrays.rangeCheck(cArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        Arrays.rangeCheck(byArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        Arrays.rangeCheck(blArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(double[] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        Arrays.rangeCheck(dArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(float[] fArray, float f) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        Arrays.rangeCheck(fArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = object;
        }
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            objectArray[i] = object;
        }
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        return Arrays.copyOf(TArray, n, TArray.getClass());
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, (Object)objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy((Object)byArray, 0, (Object)byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    public static short[] copyOf(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        System.arraycopy((Object)sArray, 0, (Object)sArray2, 0, Math.min(sArray.length, n));
        return sArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy((Object)nArray, 0, (Object)nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        System.arraycopy((Object)lArray, 0, (Object)lArray2, 0, Math.min(lArray.length, n));
        return lArray2;
    }

    public static char[] copyOf(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy((Object)cArray, 0, (Object)cArray2, 0, Math.min(cArray.length, n));
        return cArray2;
    }

    public static float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy((Object)fArray, 0, (Object)fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy((Object)dArray, 0, (Object)dArray2, 0, Math.min(dArray.length, n));
        return dArray2;
    }

    public static boolean[] copyOf(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy((Object)blArray, 0, (Object)blArray2, 0, Math.min(blArray.length, n));
        return blArray2;
    }

    public static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        return Arrays.copyOfRange(TArray, n, n2, TArray.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] UArray, int n, int n2, Class<? extends T[]> clazz) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        Object[] objectArray = clazz == Object[].class ? new Object[n3] : (Object[])Array.newInstance(clazz.getComponentType(), n3);
        System.arraycopy(UArray, n, (Object)objectArray, 0, Math.min(UArray.length - n, n3));
        return objectArray;
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy((Object)byArray, n, (Object)byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    public static short[] copyOfRange(short[] sArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        short[] sArray2 = new short[n3];
        System.arraycopy((Object)sArray, n, (Object)sArray2, 0, Math.min(sArray.length - n, n3));
        return sArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        int[] nArray2 = new int[n3];
        System.arraycopy((Object)nArray, n, (Object)nArray2, 0, Math.min(nArray.length - n, n3));
        return nArray2;
    }

    public static long[] copyOfRange(long[] lArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        long[] lArray2 = new long[n3];
        System.arraycopy((Object)lArray, n, (Object)lArray2, 0, Math.min(lArray.length - n, n3));
        return lArray2;
    }

    public static char[] copyOfRange(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        char[] cArray2 = new char[n3];
        System.arraycopy((Object)cArray, n, (Object)cArray2, 0, Math.min(cArray.length - n, n3));
        return cArray2;
    }

    public static float[] copyOfRange(float[] fArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        float[] fArray2 = new float[n3];
        System.arraycopy((Object)fArray, n, (Object)fArray2, 0, Math.min(fArray.length - n, n3));
        return fArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        double[] dArray2 = new double[n3];
        System.arraycopy((Object)dArray, n, (Object)dArray2, 0, Math.min(dArray.length - n, n3));
        return dArray2;
    }

    public static boolean[] copyOfRange(boolean[] blArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        boolean[] blArray2 = new boolean[n3];
        System.arraycopy((Object)blArray, n, (Object)blArray2, 0, Math.min(blArray.length - n, n3));
        return blArray2;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 1;
        for (long l : lArray) {
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int n2 : nArray) {
            n = 31 * n + n2;
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 1;
        for (short s : sArray) {
            n = 31 * n + s;
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 1;
        for (char c : cArray) {
            n = 31 * n + c;
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 1;
        for (boolean bl : blArray) {
            n = 31 * n + (bl ? 1231 : 1237);
        }
        return n;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        for (float f : fArray) {
            n = 31 * n + Float.floatToIntBits(f);
        }
        return n;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        for (double d : dArray) {
            long l = Double.doubleToLongBits(d);
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = 0;
            if (object instanceof Object[]) {
                n2 = Arrays.deepHashCode((Object[])object);
            } else if (object instanceof byte[]) {
                n2 = Arrays.hashCode((byte[])object);
            } else if (object instanceof short[]) {
                n2 = Arrays.hashCode((short[])object);
            } else if (object instanceof int[]) {
                n2 = Arrays.hashCode((int[])object);
            } else if (object instanceof long[]) {
                n2 = Arrays.hashCode((long[])object);
            } else if (object instanceof char[]) {
                n2 = Arrays.hashCode((char[])object);
            } else if (object instanceof float[]) {
                n2 = Arrays.hashCode((float[])object);
            } else if (object instanceof double[]) {
                n2 = Arrays.hashCode((double[])object);
            } else if (object instanceof boolean[]) {
                n2 = Arrays.hashCode((boolean[])object);
            } else if (object != null) {
                n2 = object.hashCode();
            }
            n = 31 * n + n2;
        }
        return n;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == object2) continue;
            if (object == null) {
                return false;
            }
            boolean bl = Arrays.deepEquals0(object, object2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals0(Object object, Object object2) {
        assert (object != null);
        boolean bl = object instanceof Object[] && object2 instanceof Object[] ? Arrays.deepEquals((Object[])object, (Object[])object2) : (object instanceof byte[] && object2 instanceof byte[] ? Arrays.equals((byte[])object, (byte[])object2) : (object instanceof short[] && object2 instanceof short[] ? Arrays.equals((short[])object, (short[])object2) : (object instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object, (int[])object2) : (object instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object, (long[])object2) : (object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : (object instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object, (float[])object2) : (object instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object, (double[])object2) : (object instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object, (boolean[])object2) : object.equals(object2)))))))));
        return bl;
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n = lArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(lArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n = nArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(nArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        int n = sArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(sArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        int n = cArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(cArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        int n = byArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(byArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        int n = blArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(blArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        int n = fArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(fArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        int n = dArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(dArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n = objectArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(String.valueOf(objectArray[n2]));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    public static String deepToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n = 20 * objectArray.length;
        if (objectArray.length != 0 && n <= 0) {
            n = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        Arrays.deepToString(objectArray, stringBuilder, new HashSet<Object[]>());
        return stringBuilder.toString();
    }

    private static void deepToString(Object[] objectArray, StringBuilder stringBuilder, Set<Object[]> set) {
        if (objectArray == null) {
            stringBuilder.append("null");
            return;
        }
        int n = objectArray.length - 1;
        if (n == -1) {
            stringBuilder.append("[]");
            return;
        }
        set.add(objectArray);
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            Object object;
            if ((object = objectArray[n2]) == null) {
                stringBuilder.append("null");
            } else {
                Class<? extends Object> clazz = object.getClass();
                if (clazz.isArray()) {
                    if (clazz == byte[].class) {
                        stringBuilder.append(Arrays.toString((byte[])object));
                    } else if (clazz == short[].class) {
                        stringBuilder.append(Arrays.toString((short[])object));
                    } else if (clazz == int[].class) {
                        stringBuilder.append(Arrays.toString((int[])object));
                    } else if (clazz == long[].class) {
                        stringBuilder.append(Arrays.toString((long[])object));
                    } else if (clazz == char[].class) {
                        stringBuilder.append(Arrays.toString((char[])object));
                    } else if (clazz == float[].class) {
                        stringBuilder.append(Arrays.toString((float[])object));
                    } else if (clazz == double[].class) {
                        stringBuilder.append(Arrays.toString((double[])object));
                    } else if (clazz == boolean[].class) {
                        stringBuilder.append(Arrays.toString((boolean[])object));
                    } else if (set.contains(object)) {
                        stringBuilder.append("[...]");
                    } else {
                        Arrays.deepToString((Object[])object, stringBuilder, set);
                    }
                } else {
                    stringBuilder.append(object.toString());
                }
            }
            if (n2 == n) break;
            stringBuilder.append(", ");
            ++n2;
        }
        stringBuilder.append(']');
        set.remove(objectArray);
    }

    public static <T> void setAll(T[] TArray, IntFunction<? extends T> intFunction) {
        Objects.requireNonNull(intFunction);
        for (int i = 0; i < TArray.length; ++i) {
            TArray[i] = intFunction.apply(i);
        }
    }

    public static <T> void parallelSetAll(T[] TArray, IntFunction<? extends T> intFunction) {
        Objects.requireNonNull(intFunction);
        IntStream.range(0, TArray.length).parallel().forEach(n -> {
            objectArray[n] = intFunction.apply(n);
        });
    }

    public static void setAll(int[] nArray, IntUnaryOperator intUnaryOperator) {
        Objects.requireNonNull(intUnaryOperator);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = intUnaryOperator.applyAsInt(i);
        }
    }

    public static void parallelSetAll(int[] nArray, IntUnaryOperator intUnaryOperator) {
        Objects.requireNonNull(intUnaryOperator);
        IntStream.range(0, nArray.length).parallel().forEach(n -> {
            nArray[n] = intUnaryOperator.applyAsInt(n);
        });
    }

    public static void setAll(long[] lArray, IntToLongFunction intToLongFunction) {
        Objects.requireNonNull(intToLongFunction);
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = intToLongFunction.applyAsLong(i);
        }
    }

    public static void parallelSetAll(long[] lArray, IntToLongFunction intToLongFunction) {
        Objects.requireNonNull(intToLongFunction);
        IntStream.range(0, lArray.length).parallel().forEach(n -> {
            lArray[n] = intToLongFunction.applyAsLong(n);
        });
    }

    public static void setAll(double[] dArray, IntToDoubleFunction intToDoubleFunction) {
        Objects.requireNonNull(intToDoubleFunction);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = intToDoubleFunction.applyAsDouble(i);
        }
    }

    public static void parallelSetAll(double[] dArray, IntToDoubleFunction intToDoubleFunction) {
        Objects.requireNonNull(intToDoubleFunction);
        IntStream.range(0, dArray.length).parallel().forEach(n -> {
            dArray[n] = intToDoubleFunction.applyAsDouble(n);
        });
    }

    public static <T> Spliterator<T> spliterator(T[] TArray) {
        return Spliterators.spliterator(TArray, 1040);
    }

    public static <T> Spliterator<T> spliterator(T[] TArray, int n, int n2) {
        return Spliterators.spliterator(TArray, n, n2, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] nArray) {
        return Spliterators.spliterator(nArray, 1040);
    }

    public static Spliterator.OfInt spliterator(int[] nArray, int n, int n2) {
        return Spliterators.spliterator(nArray, n, n2, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] lArray) {
        return Spliterators.spliterator(lArray, 1040);
    }

    public static Spliterator.OfLong spliterator(long[] lArray, int n, int n2) {
        return Spliterators.spliterator(lArray, n, n2, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray) {
        return Spliterators.spliterator(dArray, 1040);
    }

    public static Spliterator.OfDouble spliterator(double[] dArray, int n, int n2) {
        return Spliterators.spliterator(dArray, n, n2, 1040);
    }

    public static <T> Stream<T> stream(T[] TArray) {
        return Arrays.stream(TArray, 0, TArray.length);
    }

    public static <T> Stream<T> stream(T[] TArray, int n, int n2) {
        return StreamSupport.stream(Arrays.spliterator(TArray, n, n2), false);
    }

    public static IntStream stream(int[] nArray) {
        return Arrays.stream(nArray, 0, nArray.length);
    }

    public static IntStream stream(int[] nArray, int n, int n2) {
        return StreamSupport.intStream(Arrays.spliterator(nArray, n, n2), false);
    }

    public static LongStream stream(long[] lArray) {
        return Arrays.stream(lArray, 0, lArray.length);
    }

    public static LongStream stream(long[] lArray, int n, int n2) {
        return StreamSupport.longStream(Arrays.spliterator(lArray, n, n2), false);
    }

    public static DoubleStream stream(double[] dArray) {
        return Arrays.stream(dArray, 0, dArray.length);
    }

    public static DoubleStream stream(double[] dArray, int n, int n2) {
        return StreamSupport.doubleStream(Arrays.spliterator(dArray, n, n2), false);
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] EArray) {
            this.a = Objects.requireNonNull(EArray);
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            int n = this.size();
            if (TArray.length < n) {
                return Arrays.copyOf(this.a, n, TArray.getClass());
            }
            System.arraycopy(this.a, 0, TArray, 0, n);
            if (TArray.length > n) {
                TArray[n] = null;
            }
            return TArray;
        }

        @Override
        public E get(int n) {
            return this.a[n];
        }

        @Override
        public E set(int n, E e) {
            E e2 = this.a[n];
            this.a[n] = e;
            return e2;
        }

        @Override
        public int indexOf(Object object) {
            E[] EArray = this.a;
            if (object == null) {
                for (int i = 0; i < EArray.length; ++i) {
                    if (EArray[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < EArray.length; ++i) {
                    if (!object.equals(EArray[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this.a, 16);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Objects.requireNonNull(consumer);
            for (E e : this.a) {
                consumer.accept(e);
            }
        }

        @Override
        public void replaceAll(UnaryOperator<E> unaryOperator) {
            Objects.requireNonNull(unaryOperator);
            E[] EArray = this.a;
            for (int i = 0; i < EArray.length; ++i) {
                EArray[i] = unaryOperator.apply(EArray[i]);
            }
        }

        @Override
        public void sort(Comparator<? super E> comparator) {
            Arrays.sort(this.a, comparator);
        }
    }

    static final class LegacyMergeSort {
        private static final boolean userRequested = AccessController.doPrivileged(new GetBooleanAction("java.util.Arrays.useLegacyMergeSort"));

        LegacyMergeSort() {
        }
    }

    static final class NaturalOrder
    implements Comparator<Object> {
        static final NaturalOrder INSTANCE = new NaturalOrder();

        NaturalOrder() {
        }

        @Override
        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }
}

