/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import com.ibm.lang.management.internal.AvailableProcessorsNotificationInfoUtil;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.OperatingSystemNotificationThreadShutdown;
import com.ibm.lang.management.internal.ProcessingCapacityNotificationInfoUtil;
import com.ibm.lang.management.internal.TotalPhysicalMemoryNotificationInfoUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Notification;

final class OperatingSystemNotificationThread
implements Runnable {
    private final ExtendedOperatingSystemMXBeanImpl osBean;

    OperatingSystemNotificationThread(ExtendedOperatingSystemMXBeanImpl extendedOperatingSystemMXBeanImpl) {
        this.osBean = extendedOperatingSystemMXBeanImpl;
    }

    @Override
    public void run() {
        final OperatingSystemNotificationThreadShutdown operatingSystemNotificationThreadShutdown = new OperatingSystemNotificationThreadShutdown(Thread.currentThread());
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(operatingSystemNotificationThreadShutdown);
                    return null;
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        this.processNotificationLoop();
    }

    private native void processNotificationLoop();

    private void dispatchNotificationHelper(int n, long l, long l2) {
        if (n == 1) {
            AvailableProcessorsNotificationInfo availableProcessorsNotificationInfo = new AvailableProcessorsNotificationInfo((int)l);
            Notification notification = new Notification("com.ibm.management.available.processors.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(AvailableProcessorsNotificationInfoUtil.toCompositeData(availableProcessorsNotificationInfo));
            this.osBean.sendNotification(notification);
        } else if (n == 2) {
            ProcessingCapacityNotificationInfo processingCapacityNotificationInfo = new ProcessingCapacityNotificationInfo((int)l);
            Notification notification = new Notification("com.ibm.management.processing.capacity.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(ProcessingCapacityNotificationInfoUtil.toCompositeData(processingCapacityNotificationInfo));
            this.osBean.sendNotification(notification);
        } else if (n == 3) {
            TotalPhysicalMemoryNotificationInfo totalPhysicalMemoryNotificationInfo = new TotalPhysicalMemoryNotificationInfo(l);
            Notification notification = new Notification("com.ibm.management.total.physical.memory.change", "java.lang:type=OperatingSystem", l2);
            notification.setUserData(TotalPhysicalMemoryNotificationInfoUtil.toCompositeData(totalPhysicalMemoryNotificationInfo));
            this.osBean.sendNotification(notification);
        }
    }
}

