/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.GarbageCollectorMXBeanImpl;
import com.ibm.java.lang.management.internal.MemoryNotificationInfoUtil;
import com.ibm.lang.management.internal.ExtendedGarbageCollectorMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedMemoryMXBeanImpl;
import com.ibm.lang.management.internal.MemoryNotificationThreadShutdown;
import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import com.sun.management.internal.GarbageCollectionNotificationInfoUtil;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.Notification;

final class MemoryNotificationThread
implements Runnable {
    private final ExtendedMemoryMXBeanImpl memBean;

    MemoryNotificationThread(ExtendedMemoryMXBeanImpl extendedMemoryMXBeanImpl) {
        this.memBean = extendedMemoryMXBeanImpl;
    }

    private void dispatchGCNotificationHelper(String string, String string2, String string3, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5, long[] lArray6, long[] lArray7, long l4) {
        GcInfo gcInfo = ExtendedGarbageCollectorMXBeanImpl.buildGcInfo(l, l2, l3, lArray, lArray2, lArray3, lArray4, lArray5, lArray6, lArray7);
        GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = new GarbageCollectionNotificationInfo(string, string2, string3, gcInfo);
        for (MemoryManagerMXBean memoryManagerMXBean : this.memBean.getMemoryManagerMXBeans(false)) {
            if (!(memoryManagerMXBean instanceof GarbageCollectorMXBeanImpl) || !memoryManagerMXBean.getName().equals(string)) continue;
            Notification notification = new Notification("com.sun.management.gc.notification", memoryManagerMXBean.getObjectName().getCanonicalName(), l4);
            notification.setUserData(GarbageCollectionNotificationInfoUtil.toCompositeData(garbageCollectionNotificationInfo));
            ((GarbageCollectorMXBeanImpl)memoryManagerMXBean).sendNotification(notification);
            break;
        }
    }

    private void dispatchMemoryNotificationHelper(String string, long l, long l2, long l3, long l4, long l5, long l6, boolean bl) {
        MemoryNotificationInfo memoryNotificationInfo = new MemoryNotificationInfo(string, new MemoryUsage(l, l2, l3, l4), l5);
        Notification notification = new Notification(bl ? "java.management.memory.collection.threshold.exceeded" : "java.management.memory.threshold.exceeded", "java.lang:type=Memory", l6);
        notification.setUserData(MemoryNotificationInfoUtil.toCompositeData(memoryNotificationInfo));
        this.memBean.sendNotification(notification);
    }

    private native void processNotificationLoop();

    private static boolean registerShutdownHandler() {
        MemoryNotificationThreadShutdown memoryNotificationThreadShutdown = new MemoryNotificationThreadShutdown(Thread.currentThread());
        PrivilegedAction<Boolean> privilegedAction = () -> {
            try {
                Runtime.getRuntime().addShutdownHook(memoryNotificationThreadShutdown);
                return Boolean.TRUE;
            }
            catch (IllegalStateException illegalStateException) {
                return Boolean.FALSE;
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    @Override
    public void run() {
        if (MemoryNotificationThread.registerShutdownHandler()) {
            this.processNotificationLoop();
        }
    }
}

