/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@DTFJPlugin(version=".*", runtime=false, image=false)
public class LogCommand
extends BaseJdmpviewCommand {
    public LogCommand() {
        this.addCommand("log", "[name level]", "display and control instances of java.util.logging.Logger");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        switch (stringArray.length) {
            case 0: {
                this.displayLoggers();
                break;
            }
            case 2: {
                this.configureLogger(stringArray[0], stringArray[1]);
                break;
            }
            default: {
                printStream.println("Incorrect number of parameters supplied. See 'help log' for more details");
            }
        }
    }

    private void displayLoggers() {
        LogManager logManager = LogManager.getLogManager();
        TreeSet<String> treeSet = new TreeSet<String>();
        Enumeration<String> enumeration = logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            Logger object = logManager.getLogger(enumeration.nextElement());
            StringBuilder stringBuilder = new StringBuilder();
            if (object.getName().length() == 0) {
                stringBuilder.append("<<default logger>>");
            } else {
                stringBuilder.append(object.getName());
            }
            if (object.getHandlers().length == 0) {
                stringBuilder.append(" : disabled");
            } else {
                stringBuilder.append(" : enabled");
                stringBuilder.append(" (");
                Level level = object.getLevel();
                if (level != null) {
                    String string = level.getName();
                    stringBuilder.append(string);
                }
                stringBuilder.append(") ");
            }
            treeSet.add(stringBuilder.toString());
        }
        this.out.println("Currently installed loggers :-");
        for (String string : treeSet) {
            this.out.print("\t");
            this.out.println(string);
        }
    }

    private void configureLogger(String string, String string2) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(string);
        if (logger == null) {
            this.out.println("The logger name " + string + " was not recognised");
            return;
        }
        Level level = null;
        try {
            level = Level.parse(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.out.println("The level " + string2 + " was not recognised");
            return;
        }
        if (logger.getHandlers().length != 0) {
            for (Handler handler : logger.getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                logger.setLevel(level);
                handler.setLevel(level);
                return;
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        logger.setLevel(level);
        consoleHandler.setLevel(level);
        logger.addHandler(consoleHandler);
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("Command 'log' displays all the currently installed Java util loggers. \n'log <logname> <log level> allows you to selectively enable a logger and set its level.\nValid log levels are SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST\nUse 'log <logname> OFF' to disable a logger");
    }
}

