/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;

public final class ClassScanner
extends ClassVisitor {
    private ClassInfo info;
    private Annotation currentAnnotation;
    private final URL url;
    private final Set<ClassListener> listeners;

    public static ClassInfo getClassInfo(InputStream inputStream, URL uRL, Set<ClassListener> set) throws IOException {
        ClassScanner classScanner = new ClassScanner(uRL, set);
        ClassReader classReader = new ClassReader(inputStream);
        classReader.accept(classScanner, 7);
        return classScanner.info;
    }

    private ClassScanner(URL uRL, Set<ClassListener> set) {
        super(327680, null);
        this.url = uRL;
        this.listeners = set;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        this.currentAnnotation = this.info.addAnnotation(string);
        for (ClassListener classListener : this.listeners) {
            classListener.visitAnnotation(string, bl);
        }
        final class ClassScannerAnnotation
        extends AnnotationVisitor {
            ClassScannerAnnotation(int n) {
                super(n);
            }

            @Override
            public void visit(String string, Object object) {
                ClassScanner.this.visitAnnotationValue(string, object);
            }
        }
        return new ClassScannerAnnotation(this.api);
    }

    final void visitAnnotationValue(String string, Object object) {
        this.currentAnnotation.addEntry(string, object);
        for (ClassListener classListener : this.listeners) {
            classListener.visitAnnotationValue(string, object);
        }
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        String string4 = string.replace('/', '.');
        String string5 = string3.replace('/', '.');
        this.info = new ClassInfo(string4, this.url);
        for (String string6 : stringArray) {
            this.info.addInterface(string6);
        }
        for (ClassListener classListener : this.listeners) {
            classListener.visit(n, n2, string4, string2, string5, stringArray);
        }
    }
}

