/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptImageSection;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaReference;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PHDJavaObject
implements JavaObject {
    private final long address;
    private final PHDJavaHeap heap;
    private JavaClass cls;
    private Object refs;
    private int hashCode;
    private long instanceSize;
    static final int HASHED = 1;
    static final int HASHED_AND_MOVED = 2;
    static final int NO_HASHCODE = 4;
    private int flags;
    static final int SIMPLE_OBJECT = -1;
    static final int UNRESOLVED_TYPE = -2;
    static final int UNKNOWN_TYPE = -3;
    private int length = -2;
    public static final long UNSPECIFIED_INSTANCE_SIZE = -1L;

    public PHDJavaObject(Builder builder) {
        this.heap = builder.heap;
        this.address = builder.address;
        this.cls = builder.cls;
        this.flags = builder.flags;
        this.hashCode = builder.hashCode;
        this.refs = builder.refs;
        this.length = builder.length;
        this.instanceSize = builder.instanceSize;
    }

    @Override
    public void arraycopy(int n, Object object, int n2, int n3) throws CorruptDataException, MemoryAccessException {
        String string;
        if (object == null) {
            throw new NullPointerException("destination null");
        }
        this.fillInDetails(true);
        if (!this.isArray()) {
            throw new IllegalArgumentException(this + " is not an array");
        }
        JavaClass javaClass = this.getJavaClass();
        try {
            string = javaClass.getName();
        }
        catch (CorruptDataException corruptDataException) {
            string = "[L";
        }
        if (n < 0 || n3 < 0 || n2 < 0 || n + n3 < 0 || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException(n + "," + n2 + "," + n3);
        }
        if (n + n3 > this.getArraySize()) {
            throw new IndexOutOfBoundsException(n + "+" + n3 + ">" + this.getArraySize() + javaClass);
        }
        if (object instanceof JavaObject[]) {
            int n4;
            Object object2;
            if (!string.startsWith("[[") && !string.startsWith("[L")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            JavaObject[] javaObjectArray = (JavaObject[])object;
            if (this.refs instanceof LongEnumeration) {
                object2 = (LongEnumeration)this.refs;
                n4 = object2.numberOfElements();
                for (int i = 0; i < n && i < n4; ++i) {
                    object2.nextLong();
                }
            } else if (this.refs instanceof int[]) {
                object2 = (int[])this.refs;
                n4 = ((Object)object2).length;
            } else if (this.refs instanceof long[]) {
                object2 = (long[])this.refs;
                n4 = ((Object)object2).length;
            } else {
                throw new CorruptDataException(new PHDCorruptData("Unknown array contents", this.getID()));
            }
            for (int i = n; i < n + n3; ++i) {
                PHDJavaObject pHDJavaObject;
                if (i < n4) {
                    long l;
                    Object object3;
                    if (this.refs instanceof LongEnumeration) {
                        object3 = (LongEnumeration)this.refs;
                        l = object3.nextLong();
                    } else if (this.refs instanceof int[]) {
                        object3 = (int[])this.refs;
                        l = this.heap.getJavaRuntime().expandAddress((int)object3[i]);
                    } else {
                        object3 = (long[])this.refs;
                        l = (long)object3[i];
                    }
                    pHDJavaObject = new Builder(this.heap, l, null, 4, -1).build();
                } else {
                    pHDJavaObject = null;
                }
                int n5 = n2 + (i - n);
                if (n5 >= javaObjectArray.length) {
                    throw new IndexOutOfBoundsException("Array " + javaClass + " 0x" + Long.toHexString(this.address) + "[" + this.getArraySize() + "]," + n + "," + javaObjectArray + "[" + javaObjectArray.length + "]," + n2 + "," + n3 + " at " + i);
                }
                javaObjectArray[n5] = pHDJavaObject;
            }
        } else if (object instanceof byte[]) {
            if (!string.startsWith("[B")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            byte[] byArray = (byte[])object;
            if (n2 + n3 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof short[]) {
            if (!string.startsWith("[S")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            short[] sArray = (short[])object;
            if (n2 + n3 > sArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof int[]) {
            if (!string.startsWith("[I")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            int[] nArray = (int[])object;
            if (n2 + n3 > nArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof long[]) {
            if (!string.startsWith("[J")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            long[] lArray = (long[])object;
            if (n2 + n3 > lArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof boolean[]) {
            if (!string.startsWith("[Z")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            boolean[] blArray = (boolean[])object;
            if (n2 + n3 > blArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof char[]) {
            if (!string.startsWith("[C")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            char[] cArray = (char[])object;
            if (n2 + n3 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof float[]) {
            if (!string.startsWith("[F")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            float[] fArray = (float[])object;
            if (n2 + n3 > fArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (object instanceof double[]) {
            if (!string.startsWith("[D")) {
                throw new IllegalArgumentException("Expected " + string + " not " + object);
            }
            double[] dArray = (double[])object;
            if (n2 + n3 > dArray.length) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            throw new IllegalArgumentException("Expected " + string + " not " + object);
        }
    }

    @Override
    public int getArraySize() throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this + " is not an array");
        }
        if (this.length == -3) {
            throw new CorruptDataException(new PHDCorruptData("Unknown length", this.getID()));
        }
        return this.length;
    }

    @Override
    public long getHashcode() throws DataUnavailable, CorruptDataException {
        this.getJavaClass();
        if ((this.flags & 4) != 0) {
            throw new DataUnavailable("no hashcode available");
        }
        return this.hashCode;
    }

    @Override
    public JavaHeap getHeap() throws CorruptDataException, DataUnavailable {
        return this.heap;
    }

    @Override
    public ImagePointer getID() {
        return this.heap.getImageAddressSpace().getPointer(this.address);
    }

    @Override
    public JavaClass getJavaClass() throws CorruptDataException {
        this.fillInDetails(false);
        if (this.cls == null) {
            PHDCorruptJavaClass pHDCorruptJavaClass = new PHDCorruptJavaClass("Unable to get type for object", this.getID(), null);
            throw new CorruptDataException(pHDCorruptJavaClass);
        }
        return this.cls;
    }

    @Override
    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        this.getJavaClass();
        if ((this.flags & 4) != 0) {
            throw new DataUnavailable("no hashcode available");
        }
        if ((this.flags & 3) == 0) {
            throw new DataUnavailable("hashcode not persistent");
        }
        return this.hashCode;
    }

    @Override
    public Iterator<JavaReference> getReferences() {
        this.fillInDetails(true);
        final PHDJavaObject pHDJavaObject = this;
        return new Iterator<JavaReference>(){
            int count = -1;
            Iterator<JavaClass> loaderCls;
            {
                this.loaderCls = ((PHDJavaObject)PHDJavaObject.this).heap.runtime.getLoaderClasses(pHDJavaObject);
            }

            @Override
            public boolean hasNext() {
                if (this.count < 0) {
                    return true;
                }
                if (this.loaderCls.hasNext()) {
                    return true;
                }
                if (PHDJavaObject.this.refs instanceof LongEnumeration) {
                    LongEnumeration longEnumeration = (LongEnumeration)PHDJavaObject.this.refs;
                    return this.count < longEnumeration.numberOfElements();
                }
                if (PHDJavaObject.this.refs instanceof long[]) {
                    long[] lArray = (long[])PHDJavaObject.this.refs;
                    return this.count < lArray.length;
                }
                if (PHDJavaObject.this.refs instanceof int[]) {
                    int[] nArray = (int[])PHDJavaObject.this.refs;
                    return this.count < nArray.length;
                }
                return false;
            }

            @Override
            public JavaReference next() {
                long l;
                JavaClass javaClass;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("" + this.count++);
                }
                int n = 0;
                if (this.count == -1) {
                    javaClass = PHDJavaObject.this.cls;
                    l = 0L;
                    ++this.count;
                    n = 1;
                } else if (this.loaderCls.hasNext()) {
                    n = 11;
                    javaClass = this.loaderCls.next();
                    l = 0L;
                } else {
                    if (PHDJavaObject.this.refs instanceof LongEnumeration) {
                        LongEnumeration longEnumeration = (LongEnumeration)PHDJavaObject.this.refs;
                        l = longEnumeration.nextLong();
                        ++this.count;
                    } else if (PHDJavaObject.this.refs instanceof int[]) {
                        int[] nArray = (int[])PHDJavaObject.this.refs;
                        l = PHDJavaObject.this.heap.getJavaRuntime().expandAddress(nArray[this.count++]);
                    } else {
                        long[] lArray = (long[])PHDJavaObject.this.refs;
                        l = lArray[this.count++];
                    }
                    n = PHDJavaObject.this.length >= 0 ? 3 : 2;
                    javaClass = PHDJavaObject.this.heap.getJavaRuntime().findClass(l);
                }
                if (javaClass != null) {
                    return new PHDJavaReference(javaClass, pHDJavaObject, 1, n, 0, "?");
                }
                return new PHDJavaReference(new Builder(PHDJavaObject.this.heap, l, null, 4, -1).build(), pHDJavaObject, 1, n, 0, "?");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<ImageSection> getSections() {
        PHDImageSection pHDImageSection;
        ArrayList<PHDImageSection> arrayList = new ArrayList<PHDImageSection>();
        try {
            pHDImageSection = new PHDImageSection("Object section", this.getID(), this.getSize());
        }
        catch (CorruptDataException corruptDataException) {
            pHDImageSection = new PHDCorruptImageSection("Corrupt object section", this.getID());
        }
        arrayList.add(pHDImageSection);
        return arrayList.iterator();
    }

    @Override
    public long getSize() throws CorruptDataException {
        if (this.instanceSize != -1L) {
            return this.instanceSize;
        }
        JavaClass javaClass = this.getJavaClass();
        if (this.isArray()) {
            return ((PHDJavaClass)javaClass).getArraySize(this.length);
        }
        return ((PHDJavaClass)javaClass).getInstanceSize();
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        if (this.length >= 0) {
            return true;
        }
        if (this.length == -1) {
            return false;
        }
        return this.getJavaClass().isArray();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PHDJavaObject)) {
            return false;
        }
        PHDJavaObject pHDJavaObject = (PHDJavaObject)object;
        return this.heap.equals(pHDJavaObject.heap) && this.address == pHDJavaObject.address;
    }

    @Override
    public int hashCode() {
        return (int)this.address ^ (int)(this.address >>> 32);
    }

    private void fillInDetails(boolean bl) {
        if (this.length == -2 || bl && this.refs == null) {
            JavaObject javaObject = this.heap.getObjectAtAddress(this.getID(), bl);
            if (this.equals(javaObject)) {
                PHDJavaObject pHDJavaObject = (PHDJavaObject)javaObject;
                if (pHDJavaObject.cls != null) {
                    this.cls = pHDJavaObject.cls;
                    this.hashCode = pHDJavaObject.hashCode;
                    this.flags = pHDJavaObject.flags;
                }
                this.length = pHDJavaObject.length;
                this.refs = pHDJavaObject.refs;
            } else {
                this.length = -3;
            }
        }
    }

    public String toString() {
        try {
            String string = this.getJavaClass().getName();
            return "Instance of " + string + " @ 0x" + Long.toHexString(this.address);
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }

    public static class Builder {
        private final PHDJavaHeap heap;
        private final long address;
        private final JavaClass cls;
        private final int flags;
        private final int hashCode;
        private Object refs = null;
        private int length = -2;
        private long instanceSize = -1L;

        public Builder(PHDJavaHeap pHDJavaHeap, long l, JavaClass javaClass, int n, int n2) {
            this.heap = pHDJavaHeap;
            this.address = l;
            this.cls = javaClass;
            this.flags = n;
            this.hashCode = n2;
        }

        public Builder refs(LongEnumeration longEnumeration, int n) {
            this.refs = this.heap.runtime.convertRefs(longEnumeration, n);
            return this;
        }

        public Builder refsAsArray(long[] lArray, int n) {
            this.refs = this.heap.runtime.convertRefs(lArray, n);
            return this;
        }

        public Builder length(int n) {
            this.length = n;
            return this;
        }

        public Builder instanceSize(long l) {
            this.instanceSize = l;
            return this;
        }

        public PHDJavaObject build() {
            return new PHDJavaObject(this);
        }
    }
}

