/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import java.util.Collections;
import java.util.Iterator;

public class PHDJavaMethod
implements JavaMethod {
    private JavaClass cls;
    private CorruptData cls_cd;
    private String name;
    private CorruptData name_cd;
    private String sig;
    private CorruptData sig_cd;
    private int mods;
    private CorruptData mods_cd;

    PHDJavaMethod(ImageAddressSpace imageAddressSpace, JavaClass javaClass, JavaMethod javaMethod) {
        this.cls = javaClass;
        try {
            this.name = javaMethod.getName();
        }
        catch (CorruptDataException corruptDataException) {
            this.name_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.sig = javaMethod.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
            this.sig_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        try {
            this.mods = javaMethod.getModifiers();
        }
        catch (CorruptDataException corruptDataException) {
            this.mods_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
    }

    PHDJavaMethod(ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime, JavaMethod javaMethod) {
        this(imageAddressSpace, (JavaClass)null, javaMethod);
        try {
            JavaClass javaClass = javaMethod.getDeclaringClass();
            ImagePointer imagePointer = javaClass.getID();
            if (imagePointer != null) {
                this.cls = pHDJavaRuntime.findClass(imagePointer.getAddress());
            }
            if (this.cls == null) {
                this.cls = pHDJavaRuntime.findClass(javaClass.getName());
            }
        }
        catch (CorruptDataException corruptDataException) {
            this.cls_cd = new PHDCorruptData(imageAddressSpace, corruptDataException);
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
    }

    @Override
    public Iterator<ImageSection> getBytecodeSections() {
        return Collections.emptyList().iterator();
    }

    @Override
    public Iterator getCompiledSections() {
        return Collections.emptyList().iterator();
    }

    @Override
    public JavaClass getDeclaringClass() throws CorruptDataException, DataUnavailable {
        this.checkCD(this.cls_cd);
        if (this.cls == null) {
            throw new DataUnavailable("No class");
        }
        return this.cls;
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        this.checkCD(this.mods_cd);
        return this.mods;
    }

    @Override
    public String getName() throws CorruptDataException {
        this.checkCD(this.name_cd);
        return this.name;
    }

    @Override
    public String getSignature() throws CorruptDataException {
        this.checkCD(this.sig_cd);
        return this.sig;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PHDJavaMethod pHDJavaMethod = (PHDJavaMethod)object;
        return this.equals(this.cls, pHDJavaMethod.cls) && this.equals(this.name, pHDJavaMethod.name) && this.equals(this.sig, pHDJavaMethod.sig);
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.cls) ^ this.hashCode(this.name) ^ this.hashCode(this.sig);
    }

    private boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    private void checkCD(CorruptData corruptData) throws CorruptDataException {
        if (corruptData != null) {
            throw new CorruptDataException(corruptData);
        }
    }
}

