/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.platform;

import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.platform.IPlatformTypes;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedHashMap;

public class PlatformSectionParser
extends SectionParser
implements IPlatformTypes {
    private IImageAddressSpaceBuilder fImageAddressSpaceBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public PlatformSectionParser() {
        super("GPINFO");
    }

    @Override
    protected void topLevelRule() throws ParserException {
        this.fImageAddressSpaceBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder();
        if (this.fImageAddressSpaceBuilder != null) {
            this.fImageProcessBuilder = this.fImageAddressSpaceBuilder.getCurrentImageProcessBuilder();
        }
        this.hostInfo();
        this.crashInfo();
        this.moduleInfo();
        this.registerInfo();
        this.moduleInfo();
        this.parseEnvironmentVars();
    }

    private void hostInfo() throws ParserException {
        String string;
        String string2;
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineOptional("2XHHOSTNAME");
        if (iAttributeValueMap != null) {
            string2 = iAttributeValueMap.getTokenValue("platform_host_name");
            string = iAttributeValueMap.getTokenValue("platform_host_addr");
            if (string2 != null) {
                this.fImageBuilder.setHostName(string2);
            }
            if (string != null) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    this.fImageBuilder.addHostAddr(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        if ((iAttributeValueMap = this.processTagLineRequired("2XHOSLEVEL")) != null) {
            string2 = iAttributeValueMap.getTokenValue("platform_os_name");
            string = iAttributeValueMap.getTokenValue("platform_os_version");
            this.fImageBuilder.setOSType(string2);
            this.fImageBuilder.setOSSubType(string);
        }
        this.processTagLineRequired("2XHCPUS");
        iAttributeValueMap = this.processTagLineRequired("3XHCPUARCH");
        if (iAttributeValueMap != null) {
            string2 = iAttributeValueMap.getTokenValue("platform_cpu_arch");
            this.fImageBuilder.setcpuType(string2);
        }
        if ((iAttributeValueMap = this.processTagLineRequired("3XHNUMCPUS")) != null) {
            int n = iAttributeValueMap.getIntValue("platform_cpu_count");
            this.fImageBuilder.setcpuCount(n);
        }
        this.processTagLineOptional("3XHNUMASUP");
    }

    private void crashInfo() throws ParserException {
        IAttributeValueMap iAttributeValueMap;
        while ((iAttributeValueMap = this.processTagLineOptional("1XHEXCPCODE")) != null) {
            String string;
            IParserToken iParserToken = iAttributeValueMap.getToken("platform_signal");
            if (iParserToken == null || !(string = iParserToken.getValue()).startsWith("0x")) continue;
            try {
                int n = Integer.parseUnsignedInt(string.substring(2), 16);
                if (n == -1) continue;
                this.fImageProcessBuilder.setSignal(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.processTagLineOptional("1XHERROR2");
    }

    private void moduleInfo() throws ParserException {
        IAttributeValueMap iAttributeValueMap;
        String string = null;
        long l = -1L;
        while ((iAttributeValueMap = this.processTagLineOptional("1XHEXCPMODULE")) != null) {
            long l2;
            String string2 = iAttributeValueMap.getTokenValue("platform_module_name");
            if (string2 != null) {
                string = string2;
            }
            if ((l2 = iAttributeValueMap.getLongValue("platform_module_base")) != -1L) {
                l = l2;
            }
            if (string == null || l == -1L) continue;
            this.fImageProcessBuilder.addLibrary(string);
            string = null;
            l = -1L;
        }
    }

    private void registerInfo() throws ParserException {
        if (this.processTagLineOptional("1XHREGISTERS") != null) {
            IAttributeValueMap iAttributeValueMap;
            LinkedHashMap<String, Short> linkedHashMap = new LinkedHashMap<String, Short>();
            while ((iAttributeValueMap = this.processTagLineOptional("2XHREGISTER")) != null) {
                String string = iAttributeValueMap.getTokenValue("platform_register_name");
                String string2 = iAttributeValueMap.getTokenValue("platform_register_value");
                Number number = null;
                if (string2 != null) {
                    String string3 = string2.regionMatches(true, 0, "0x", 0, 2) ? string2.substring(2) : string2;
                    BigInteger bigInteger = new BigInteger(string3, 16);
                    int n = bigInteger.bitLength();
                    number = n <= 16 ? (Number)((short)bigInteger.intValue()) : (Number)(n <= 32 ? (Number)bigInteger.intValue() : (Number)(n <= 64 ? Long.valueOf(bigInteger.longValue()) : bigInteger));
                }
                linkedHashMap.put(string, (Short)number);
            }
            this.fImageProcessBuilder.setRegisters(linkedHashMap);
        }
    }

    private void parseEnvironmentVars() throws ParserException {
        IAttributeValueMap iAttributeValueMap = null;
        iAttributeValueMap = this.processTagLineOptional("1XHENVVARS");
        if (iAttributeValueMap != null) {
            while ((iAttributeValueMap = this.processTagLineOptional("1XHENVVAR")) != null) {
                String string = iAttributeValueMap.getTokenValue("environment_variable_name");
                String string2 = iAttributeValueMap.getTokenValue("environment_variable_value");
                if (string == null) continue;
                this.fImageProcessBuilder.addEnvironmentVariable(string, string2);
            }
        }
    }

    @Override
    protected void sovOnlyRules(String string) throws ParserException {
    }
}

