/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryAccessException;
import com.ibm.dtfj.corereaders.MemoryRange;
import java.util.Iterator;

public class Memory {
    private IAbstractAddressSpace space = null;
    private int asid = 0;

    public Memory(IAbstractAddressSpace iAbstractAddressSpace) {
        Iterator iterator;
        this.space = iAbstractAddressSpace;
        if (null != iAbstractAddressSpace && (iterator = iAbstractAddressSpace.getMemoryRanges()).hasNext()) {
            MemoryRange memoryRange = (MemoryRange)iterator.next();
            this.asid = memoryRange.getAsid();
        }
    }

    public int bytesPerPointer() {
        return this.space.bytesPerPointer(this.asid);
    }

    public long findPattern(byte[] byArray, int n, long l) {
        return this.space.findPattern(byArray, n, l);
    }

    public byte getByteAt(long l) throws MemoryAccessException {
        return this.space.getByteAt(this.asid, l);
    }

    public int getBytesAt(long l, byte[] byArray) throws MemoryAccessException {
        return this.space.getBytesAt(this.asid, l, byArray);
    }

    public int getIntAt(long l) throws MemoryAccessException {
        return this.space.getIntAt(this.asid, l);
    }

    public long getLongAt(long l) throws MemoryAccessException {
        return this.space.getLongAt(this.asid, l);
    }

    public byte[] getMemoryBytes(long l, int n) {
        return this.space.getMemoryBytes(l, n);
    }

    public Iterator getMemoryRanges() {
        return this.space.getMemoryRanges();
    }

    public long getPointerAt(long l) throws MemoryAccessException {
        return this.space.getPointerAt(this.asid, l);
    }

    public short getShortAt(long l) throws MemoryAccessException {
        return this.space.getShortAt(this.asid, l);
    }

    public boolean isExecutable(long l) throws MemoryAccessException {
        return this.space.isExecutable(this.asid, l);
    }

    public boolean isReadOnly(long l) throws MemoryAccessException {
        return this.space.isReadOnly(this.asid, l);
    }

    public boolean isShared(long l) throws MemoryAccessException {
        return this.space.isShared(this.asid, l);
    }
}

