/**
 * The FORM element encompasses behavior similar to a collection and an element. It provides direct access to the contained form controls as well as the attributes of the form element. See the FORM element definition in HTML 4.01.
 */
var HTMLFormElement = {
}
/**
 * Submits the form. It performs the same action as a submit button.
 * @syntax hTMLFormElement.submit()
 * @returns {undefined} 
 */
HTMLFormElement.prototype.submit = function() {};

/**
 * List of character sets supported by the server. See the accept-charset attribute definition in HTML 4.01.
 * @syntax hTMLFormElement.acceptCharset
 * @returns {String} 
 */
HTMLFormElement.prototype.acceptCharset = new String();

/**
 * The content type of the submitted form, generally "application/x-www-form-urlencoded". See the enctype attribute definition in HTML 4.01. Note: The onsubmit even handler is not guaranteed to be triggered when invoking this method. The behavior is inconsistent for historical reasons and authors should not rely on a particular one.
 * @syntax hTMLFormElement.enctype
 * @returns {String} 
 */
HTMLFormElement.prototype.enctype = new String();

/**
 * Names the form.
 * @syntax hTMLFormElement.name
 * @returns {String} 
 */
HTMLFormElement.prototype.name = new String();

/**
 * Server-side form handler. See the action attribute definition in HTML 4.01.
 * @syntax hTMLFormElement.action
 * @returns {String} 
 */
HTMLFormElement.prototype.action = new String();

/**
 * The number of form controls in the form.
 * @syntax hTMLFormElement.length
 * @returns {Number} 
 */
HTMLFormElement.prototype.length = new Number();

/**
 * Frame to render the resource in. See the target attribute definition in HTML 4.01.
 * @syntax hTMLFormElement.target
 * @returns {String} 
 */
HTMLFormElement.prototype.target = new String();

/**
 * Restores a form element's default values. It performs the same action as a reset button.
 * @syntax hTMLFormElement.reset()
 * @returns {undefined} 
 */
HTMLFormElement.prototype.reset = function() {};

/**
 * HTTP method [IETF RFC 2616] used to submit form. See the method attribute definition in HTML 4.01.
 * @syntax hTMLFormElement.method
 * @returns {String} 
 */
HTMLFormElement.prototype.method = new String();

/**
 * Returns a collection of all form control elements in the form.
 * @syntax hTMLFormElement.elements
 * @returns {HTMLCollection} 
 */
HTMLFormElement.prototype.elements = new HTMLCollection();

/**
 * Represents the HTMLFormElement prototype object.
 * @syntax HTMLFormElement.prototype
 * @static
 */
HTMLFormElement.prototype;

