/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.util.function.Consumer;
import org.netbeans.modules.java.lsp.server.ui.IOContext;

public final class NbProcessConsole
extends IOContext {
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private final Consumer<ConsoleMessage> messageConsumer;
    private boolean stopped;

    NbProcessConsole(Consumer<ConsoleMessage> messageConsumer) {
        this.messageConsumer = messageConsumer;
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    protected void stdOut(String line) {
        ConsoleMessage msg = new ConsoleMessage(line, STDOUT);
        this.messageConsumer.accept(msg);
    }

    @Override
    protected void stdErr(String line) {
        ConsoleMessage msg = new ConsoleMessage(line, STDERR);
        this.messageConsumer.accept(msg);
    }

    @Override
    protected boolean isValid() {
        return !this.stopped;
    }

    public static final class ConsoleMessage {
        public String output;
        public String category;

        public ConsoleMessage(String message, String category) {
            this.output = message;
            this.category = category;
        }
    }
}

