/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public class TreeShims {
    public static final String BINDING_PATTERN = "BINDING_PATTERN";
    public static final String SWITCH_EXPRESSION = "SWITCH_EXPRESSION";
    public static final String YIELD = "YIELD";
    public static final String BINDING_VARIABLE = "BINDING_VARIABLE";
    public static final String RECORD = "RECORD";

    public static java.util.List<? extends ExpressionTree> getExpressions(CaseTree node) {
        try {
            Method getExpressions = CaseTree.class.getDeclaredMethod("getExpressions", new Class[0]);
            return (java.util.List)getExpressions.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return Collections.singletonList(node.getExpression());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Tree getBody(CaseTree node) {
        try {
            Method getBody = CaseTree.class.getDeclaredMethod("getBody", new Class[0]);
            return (Tree)getBody.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static boolean isRuleCase(CaseTree node) {
        try {
            Method getCaseKind = CaseTree.class.getDeclaredMethod("getCaseKind", new Class[0]);
            return "RULE".equals(String.valueOf(getCaseKind.invoke((Object)node, new Object[0])));
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Tree getPattern(InstanceOfTree node) {
        try {
            Method getPattern = InstanceOfTree.class.getDeclaredMethod("getPattern", new Class[0]);
            return (Tree)getPattern.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static java.util.List<? extends ExpressionTree> getExpressions(Tree node) {
        java.util.List<Object> exprTrees = new ArrayList();
        switch (node.getKind().toString()) {
            case "CASE": {
                exprTrees = TreeShims.getExpressions((CaseTree)node);
                break;
            }
            case "SWITCH_EXPRESSION": {
                try {
                    Class<?> swExprTreeClass = Class.forName("com.sun.source.tree.SwitchExpressionTree");
                    Method getExpressions = swExprTreeClass.getDeclaredMethod("getExpression", new Class[0]);
                    exprTrees = Collections.singletonList((ExpressionTree)getExpressions.invoke((Object)node, new Object[0]));
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw TreeShims.throwAny(ex);
                }
            }
            case "SWITCH": {
                exprTrees = Collections.singletonList(((SwitchTree)node).getExpression());
                break;
            }
        }
        return exprTrees;
    }

    public static java.util.List<? extends CaseTree> getCases(Tree node) {
        java.util.List<Object> caseTrees = new ArrayList();
        switch (node.getKind().toString()) {
            case "SWITCH": {
                caseTrees = ((SwitchTree)node).getCases();
                break;
            }
            case "SWITCH_EXPRESSION": {
                try {
                    Class<?> swExprTreeClass = Class.forName("com.sun.source.tree.SwitchExpressionTree");
                    Method getCases = swExprTreeClass.getDeclaredMethod("getCases", new Class[0]);
                    caseTrees = (java.util.List)getCases.invoke((Object)node, new Object[0]);
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                    throw TreeShims.throwAny(ex);
                }
            }
        }
        return caseTrees;
    }

    public static ExpressionTree getValue(BreakTree node) {
        try {
            Method getExpression = BreakTree.class.getDeclaredMethod("getValue", new Class[0]);
            return (ExpressionTree)getExpression.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Name getBinding(Tree node) {
        try {
            Class<?> bpt = Class.forName("com.sun.source.tree.BindingPatternTree");
            Method getBinding = bpt.getDeclaredMethod("getBinding", new Class[0]);
            return (Name)getBinding.invoke((Object)node, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static java.util.List<? extends Tree> getPermits(ClassTree node) {
        java.util.List perms = null;
        try {
            Class<?> classTree = Class.forName("com.sun.source.tree.ClassTree");
            Method getPerms = classTree.getDeclaredMethod("getPermitsClause", new Class[0]);
            perms = (java.util.List)getPerms.invoke((Object)node, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
        return perms;
    }

    public static java.util.List<? extends Tree> getPermits(JCTree.JCClassDecl newT) {
        AbstractCollection newPermitings = new ArrayList();
        try {
            Class<?> jCClassDecl = Class.forName("com.sun.tools.javac.tree.JCTree$JCClassDecl");
            newPermitings = (List)jCClassDecl.getDeclaredField("permitting").get(newT);
        }
        catch (ClassNotFoundException | NoSuchFieldException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw TreeShims.throwAny(ex);
        }
        return newPermitings;
    }

    public static ExpressionTree getYieldValue(Tree node) {
        if (!node.getKind().toString().equals(YIELD)) {
            return null;
        }
        try {
            Class<?> yieldTreeClass = Class.forName("com.sun.source.tree.YieldTree");
            Method getExpression = yieldTreeClass.getDeclaredMethod("getValue", new Class[0]);
            return (ExpressionTree)getExpression.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Tree SwitchExpression(TreeMaker make, ExpressionTree selector, java.util.List<? extends CaseTree> caseList) throws SecurityException {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        for (CaseTree caseTree : caseList) {
            cases.append((JCTree.JCCase)caseTree);
        }
        try {
            Method getMethod = TreeMaker.class.getDeclaredMethod("SwitchExpression", JCTree.JCExpression.class, List.class);
            return (Tree)getMethod.invoke((Object)make, (JCTree.JCExpression)selector, cases.toList());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    public static Tree getBindingPatternType(Tree node) {
        if (!node.getKind().toString().equals(BINDING_PATTERN)) {
            return null;
        }
        try {
            Class<?> bindingPatternTreeClass = Class.forName("com.sun.source.tree.BindingPatternTree");
            Method getType = bindingPatternTreeClass.getDeclaredMethod("getType", new Class[0]);
            return (Tree)getType.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw TreeShims.throwAny(ex);
        }
    }

    private static <T extends Throwable> RuntimeException throwAny(Throwable t) throws T {
        throw t;
    }

    public static boolean isRecord(Element el) {
        return el != null && RECORD.equals(el.getKind().name());
    }

    public static <N extends Tree> boolean isRecord(N node) {
        return node != null && RECORD.equals(node.getKind().name());
    }

    public static boolean isRecordComponent(Element el) {
        return el != null && "RECORD_COMPONENT".equals(el.getKind().name());
    }

    public static Element toRecordComponent(Element el) {
        if (el == null || el.getKind() != ElementKind.FIELD) {
            return el;
        }
        TypeElement owner = (TypeElement)el.getEnclosingElement();
        if (!RECORD.equals(owner.getKind().name())) {
            return el;
        }
        for (Element element : owner.getEnclosedElements()) {
            if (!TreeShims.isRecordComponent(element.getKind()) || !element.getSimpleName().equals(el.getSimpleName())) continue;
            return element;
        }
        return el;
    }

    public static boolean isRecordComponent(ElementKind kind) {
        return "RECORD_COMPONENT".equals(kind.name());
    }

    public static ElementKind getRecordKind() {
        try {
            return ElementKind.valueOf(RECORD);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Tree getTarget(Tree node) {
        if (!node.getKind().name().equals(YIELD)) {
            throw new IllegalStateException();
        }
        try {
            Field target = node.getClass().getField("target");
            return (Tree)target.get(node);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw TreeShims.throwAny(ex);
        }
    }
}

