/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.preferences;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.atoum.AtoumTestingProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class AtoumPreferences {
    private static final String BOOTSTRAP_ENABLED = "bootstrap.enabled";
    private static final String BOOTSTRAP_PATH = "bootstrap.path";
    private static final String CONFIGURATION_ENABLED = "configuration.enabled";
    private static final String CONFIGURATION_PATH = "configuration.path";
    private static final String ATOUM_ENABLED = "atoum.enabled";
    private static final String ATOUM_PATH = "atoum.path";

    private AtoumPreferences() {
    }

    public static boolean isBootstrapEnabled(PhpModule phpModule) {
        return AtoumPreferences.getPreferences(phpModule).getBoolean(BOOTSTRAP_ENABLED, false);
    }

    public static void setBootstrapEnabled(PhpModule phpModule, boolean bootstrapEnabled) {
        AtoumPreferences.getPreferences(phpModule).putBoolean(BOOTSTRAP_ENABLED, bootstrapEnabled);
    }

    public static String getBootstrapPath(PhpModule phpModule) {
        return AtoumPreferences.resolvePath(phpModule, AtoumPreferences.getPreferences(phpModule).get(BOOTSTRAP_PATH, null));
    }

    public static void setBootstrapPath(PhpModule phpModule, String bootstrapPath) {
        AtoumPreferences.getPreferences(phpModule).put(BOOTSTRAP_PATH, AtoumPreferences.relativizePath(phpModule, bootstrapPath));
    }

    public static boolean isConfigurationEnabled(PhpModule phpModule) {
        return AtoumPreferences.getPreferences(phpModule).getBoolean(CONFIGURATION_ENABLED, false);
    }

    public static void setConfigurationEnabled(PhpModule phpModule, boolean configurationEnabled) {
        AtoumPreferences.getPreferences(phpModule).putBoolean(CONFIGURATION_ENABLED, configurationEnabled);
    }

    public static String getConfigurationPath(PhpModule phpModule) {
        return AtoumPreferences.resolvePath(phpModule, AtoumPreferences.getPreferences(phpModule).get(CONFIGURATION_PATH, null));
    }

    public static void setConfigurationPath(PhpModule phpModule, String configurationPath) {
        AtoumPreferences.getPreferences(phpModule).put(CONFIGURATION_PATH, AtoumPreferences.relativizePath(phpModule, configurationPath));
    }

    public static boolean isAtoumEnabled(PhpModule phpModule) {
        return AtoumPreferences.getPreferences(phpModule).getBoolean(ATOUM_ENABLED, false);
    }

    public static void setAtoumEnabled(PhpModule phpModule, boolean atoumEnabled) {
        AtoumPreferences.getPreferences(phpModule).putBoolean(ATOUM_ENABLED, atoumEnabled);
    }

    public static String getAtoumPath(PhpModule phpModule) {
        return AtoumPreferences.resolvePath(phpModule, AtoumPreferences.getPreferences(phpModule).get(ATOUM_PATH, null));
    }

    public static void setAtoumPath(PhpModule phpModule, String atoumPath) {
        AtoumPreferences.getPreferences(phpModule).put(ATOUM_PATH, AtoumPreferences.relativizePath(phpModule, atoumPath));
    }

    private static Preferences getPreferences(PhpModule module) {
        return module.getPreferences(AtoumTestingProvider.class, true);
    }

    private static String relativizePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        String path = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (File)file);
        if (path == null) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    private static String resolvePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

