/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.security.impl.policyconv.BindingProcessor;
import com.sun.xml.ws.security.impl.policyconv.EncryptionAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.TokenProcessor;
import com.sun.xml.ws.security.impl.policyconv.XWSSPolicyContainer;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.EndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedEncryptedSupportingTokens;
import com.sun.xml.ws.security.policy.SignedEndorsingSupportingTokens;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.ws.security.policy.SignedSupportingTokens;
import com.sun.xml.ws.security.policy.SupportingTokens;
import com.sun.xml.ws.security.policy.Token;
import com.sun.xml.ws.security.policy.TransportBinding;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.TimestampPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.Iterator;

public class TransportBindingProcessor
extends BindingProcessor {
    private TransportBinding binding = null;
    private TimestampPolicy tp = null;
    private boolean buildSP = false;
    private boolean buildEP = false;

    public TransportBindingProcessor(TransportBinding binding, boolean isServer, boolean isIncoming, XWSSPolicyContainer container) {
        this.binding = binding;
        this.container = container;
        this.isIncoming = isIncoming;
        this.isServer = isServer;
        this.iAP = new IntegrityAssertionProcessor(binding.getAlgorithmSuite(), false);
        this.eAP = new EncryptionAssertionProcessor(binding.getAlgorithmSuite(), false);
        this.tokenProcessor = new TokenProcessor(isServer, isIncoming, this.pid);
    }

    public void process() throws PolicyException {
        this.container.setPolicyContainerMode(this.binding.getLayout());
        if (this.binding.isIncludeTimeStamp()) {
            this.tp = new TimestampPolicy();
            this.tp.setUUID(this.pid.generateID());
            this.container.insert(this.tp);
        }
    }

    @Override
    public void processSupportingTokens(SupportingTokens tokens) throws PolicyException {
        Iterator itr = tokens.getTokens();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            WSSPolicy policy = this.tokenProcessor.getWSSToken(token);
            if (policy instanceof IssuedTokenKeyBinding) {
                ((IssuedTokenKeyBinding)policy).setSTRID(null);
            } else if (policy instanceof AuthenticationTokenPolicy.SAMLAssertionBinding) {
                ((AuthenticationTokenPolicy.SAMLAssertionBinding)policy).setSTRID(null);
            }
            AuthenticationTokenPolicy atp = new AuthenticationTokenPolicy();
            atp.setFeatureBinding(policy);
            this.container.insert(atp);
        }
    }

    @Override
    public void processSupportingTokens(SignedSupportingTokens sst) throws PolicyException {
        Iterator itr = sst.getTokens();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            WSSPolicy policy = this.tokenProcessor.getWSSToken(token);
            if (policy instanceof IssuedTokenKeyBinding) {
                ((IssuedTokenKeyBinding)policy).setSTRID(null);
            } else if (policy instanceof AuthenticationTokenPolicy.SAMLAssertionBinding) {
                ((AuthenticationTokenPolicy.SAMLAssertionBinding)policy).setSTRID(null);
            }
            AuthenticationTokenPolicy atp = new AuthenticationTokenPolicy();
            atp.setFeatureBinding(policy);
            this.container.insert(atp);
        }
    }

    @Override
    public void processSupportingTokens(EndorsingSupportingTokens est) throws PolicyException {
        Iterator itr = est.getTokens();
        if (est.getSignedElements().hasNext() || est.getSignedParts().hasNext()) {
            this.buildSP = true;
        }
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            SignaturePolicy sp = new SignaturePolicy();
            SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
            SecurityPolicyUtil.setCanonicalizationMethod(spFB, this.binding.getAlgorithmSuite());
            sp.setUUID(this.pid.generateID());
            this.tokenProcessor.addKeyBinding(this.binding, sp, token, false);
            if (this.tp != null) {
                SignatureTarget target = this.iAP.getTargetCreator().newURISignatureTarget(this.tp.getUUID());
                this.iAP.getTargetCreator().addTransform(target);
                SecurityPolicyUtil.setName(target, this.tp);
                spFB.addTargetBinding(target);
            }
            if (this.buildSP) {
                Iterator<SignedParts> itr_sp = est.getSignedParts();
                while (itr_sp.hasNext()) {
                    SignedParts target = itr_sp.next();
                    this.iAP.process(target, spFB);
                }
                Iterator<SignedElements> itr_se = est.getSignedElements();
                while (itr_se.hasNext()) {
                    SignedElements target = itr_se.next();
                    this.iAP.process(target, spFB);
                }
            }
            this.container.insert(sp);
        }
    }

    @Override
    public void processSupportingTokens(SignedEndorsingSupportingTokens set) throws PolicyException {
        Iterator itr = set.getTokens();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            SignaturePolicy sp = new SignaturePolicy();
            sp.setUUID(this.pid.generateID());
            SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
            SecurityPolicyUtil.setCanonicalizationMethod(spFB, this.binding.getAlgorithmSuite());
            this.tokenProcessor.addKeyBinding(this.binding, sp, token, false);
            if (this.tp == null) continue;
            SignatureTarget target = this.iAP.getTargetCreator().newURISignatureTarget(this.tp.getUUID());
            this.iAP.getTargetCreator().addTransform(target);
            SecurityPolicyUtil.setName(target, this.tp);
            spFB.addTargetBinding(target);
            this.container.insert(sp);
        }
    }

    @Override
    public void processSupportingTokens(SignedEncryptedSupportingTokens sest) throws PolicyException {
        Iterator itr = sest.getTokens();
        while (itr.hasNext()) {
            Token token = (Token)itr.next();
            WSSPolicy policy = this.tokenProcessor.getWSSToken(token);
            if (policy instanceof IssuedTokenKeyBinding) {
                ((IssuedTokenKeyBinding)policy).setSTRID(null);
            } else if (policy instanceof AuthenticationTokenPolicy.SAMLAssertionBinding) {
                ((AuthenticationTokenPolicy.SAMLAssertionBinding)policy).setSTRID(null);
            }
            AuthenticationTokenPolicy atp = new AuthenticationTokenPolicy();
            atp.setFeatureBinding(policy);
            this.container.insert(atp);
        }
    }

    @Override
    protected EncryptionPolicy getSecondaryEncryptionPolicy() throws PolicyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Binding getBinding() {
        return this.binding;
    }

    @Override
    protected void close() {
    }
}

