/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WildflyDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "wildfly-deployer:";
    private static final String DISCONNECTED_URI = "wildfly-deployer:http://localhost:8080&";
    private static final Logger LOGGER = Logger.getLogger(WildflyDeploymentFactory.class.getName());
    private final Map<InstanceProperties, DeploymentFactory> factoryCache = new WeakHashMap<InstanceProperties, DeploymentFactory>();
    private final Map<InstanceProperties, WildflyDeploymentManager> managerCache = new WeakHashMap<InstanceProperties, WildflyDeploymentManager>();
    private final Map<InstanceProperties, WildFlyClassLoader> classLoaderCache = new WeakHashMap<InstanceProperties, WildFlyClassLoader>();
    private static WildflyDeploymentFactory instance;

    private WildflyDeploymentFactory() {
    }

    public static synchronized WildflyDeploymentFactory getInstance() {
        if (instance == null) {
            instance = new WildflyDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public synchronized WildFlyClassLoader getWildFlyClassLoader(InstanceProperties ip) {
        WildFlyClassLoader cl = this.classLoaderCache.get(ip);
        if (cl == null) {
            DeploymentFactory factory = this.factoryCache.get(ip);
            if (factory != null && factory.getClass().getClassLoader() instanceof WildFlyClassLoader) {
                cl = (WildFlyClassLoader)factory.getClass().getClassLoader();
            }
            if (cl == null) {
                cl = WildflyDeploymentFactory.createWildFlyClassLoader(ip.getProperty("root-dir"));
            }
            this.classLoaderCache.put(ip, cl);
        }
        return cl;
    }

    public static WildFlyClassLoader createWildFlyClassLoader(String serverRoot) {
        try {
            File jbossClient;
            String sep = File.separator;
            ArrayList<URL> urlList = new ArrayList<URL>(20);
            File org = new File(serverRoot, WildflyPluginUtils.getModulesBase(serverRoot) + "org");
            WildflyDeploymentFactory.addUrl(urlList, org, "dom4j" + sep + "main", Pattern.compile("dom4j-.*.jar"));
            if (urlList.isEmpty()) {
                LOGGER.log(Level.INFO, "No dom4j.jar availabale on classpath");
            }
            File jboss = new File(org, "jboss");
            File wildfly = new File(org, "wildfly");
            File as = new File(jboss, "as");
            File jbossModules = new File(serverRoot, "jboss-modules.jar");
            if (jbossModules.exists()) {
                urlList.add(Utilities.toURI((File)jbossModules).toURL());
            }
            if ((jbossClient = new File(serverRoot, "bin" + sep + "client" + sep + "jboss-client.jar")).exists()) {
                urlList.add(Utilities.toURI((File)jbossClient).toURL());
            }
            WildflyDeploymentFactory.addUrl(urlList, jboss, "dmr" + sep + "main", Pattern.compile("jboss-dmr-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "logging" + sep + "main", Pattern.compile("jboss-logging-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "marshalling" + sep + "main", Pattern.compile("jboss-marshalling-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "marshalling" + sep + "river" + sep + "main", Pattern.compile("jboss-marshalling-river-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "remoting" + sep + "main", Pattern.compile("jboss-remoting-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "sasl" + sep + "main", Pattern.compile("jboss-sasl-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "threads" + sep + "main", Pattern.compile("jboss-threads-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "xnio" + sep + "main", Pattern.compile("xnio-api-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, jboss, "xnio" + sep + "nio" + sep + "main", Pattern.compile("xnio-nio-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "controller" + sep + "main", Pattern.compile("wildfly-controller-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "controller" + sep + "main", Pattern.compile("jboss-as-controller-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "controller-client" + sep + "main", Pattern.compile("jboss-as-controller-client-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "controller-client" + sep + "main", Pattern.compile("wildfly-controller-client-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "protocol" + sep + "main", Pattern.compile("wildfly-protocol-.*.jar"));
            WildflyDeploymentFactory.addUrl(urlList, as, "protocol" + sep + "main", Pattern.compile("jboss-as-protocol-.*.jar"));
            File serverPath = new File(serverRoot);
            WildflyPluginUtils.Version version = WildflyPluginUtils.getServerVersion(serverPath);
            if (WildflyPluginUtils.WILDFLY_10_0_0.compareToIgnoreUpdate(version) >= 0) {
                WildflyDeploymentFactory.addUrl(urlList, wildfly, "common" + sep + "main", Pattern.compile("wildfly-common-.*.jar"));
            }
            boolean shouldPatchXnio = WildflyPluginUtils.WILDFLY_8_0_0.compareToIgnoreUpdate(version) <= 0;
            WildFlyClassLoader loader = new WildFlyClassLoader(urlList.toArray(new URL[0]), WildflyDeploymentFactory.class.getClassLoader(), shouldPatchXnio);
            return loader;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
            return null;
        }
    }

    private static void addUrl(List<URL> result, File root, String path, final Pattern pattern) {
        File[] children;
        File folder = new File(root, path);
        if (folder.exists() && folder.isDirectory() && (children = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        })) != null) {
            for (File child : children) {
                try {
                    result.add(child.toURI().toURL());
                    LOGGER.log(Level.INFO, "Adding {0} to the classpath", child.getAbsolutePath());
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        Class<WildflyDeploymentFactory> clazz = WildflyDeploymentFactory.class;
        synchronized (WildflyDeploymentFactory.class) {
            WildflyDeploymentManager dm;
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
            if (ip != null && (dm = this.managerCache.get(ip)) != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return dm;
            }
            try {
                DeploymentFactory df = this.getFactory(uri);
                if (df == null) {
                    throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
                }
                String jbURI = uri;
                try {
                    int index1 = uri.indexOf(35);
                    int index2 = uri.indexOf(38);
                    int index = Math.min(index1, index2);
                    jbURI = uri.substring(0, index);
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, null, e);
                }
                if (jbURI.endsWith("as7")) {
                    jbURI = jbURI + "&serverHost=" + (ip != null ? ip.getProperty("host") : "localhost");
                }
                WildflyDeploymentManager dm2 = new WildflyDeploymentManager(df, uri, jbURI, uname, passwd);
                if (ip != null) {
                    this.managerCache.put(ip, dm2);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return dm2;
            }
            catch (NoClassDefFoundError e) {
                DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
                dmce.initCause((Throwable)e);
                throw dmce;
            }
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        try {
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
            if (ip == null && !DISCONNECTED_URI.equals(uri)) {
                throw new DeploymentManagerCreationException("JBoss instance " + uri + " is not registered in the IDE.");
            }
            if (ip != null) {
                String root = ip.getProperty("root-dir");
                if (root == null || !new File(root).isDirectory()) {
                    throw new DeploymentManagerCreationException("Non existent server root " + root);
                }
                String server = ip.getProperty("server-dir");
                if (server == null || !new File(server).isDirectory()) {
                    throw new DeploymentManagerCreationException("Non existent domain root " + server);
                }
            }
            return new WildflyDeploymentManager(null, uri, null, null, null);
        }
        catch (NoClassDefFoundError e) {
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
            dmce.initCause((Throwable)e);
            throw dmce;
        }
    }

    public String getProductVersion() {
        return NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"LBL_JBossFactoryVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WildflyDeploymentFactory.class, (String)"WILDFLY_SERVER_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentFactory getFactory(String instanceURL) {
        WildflyDeploymentFactory jbossFactory = null;
        try {
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)instanceURL);
            Class<WildflyDeploymentFactory> clazz = WildflyDeploymentFactory.class;
            synchronized (WildflyDeploymentFactory.class) {
                if (ip != null) {
                    jbossFactory = this.factoryCache.get(ip);
                }
                if (jbossFactory == null) {
                    jbossFactory = this;
                    if (ip != null) {
                        this.factoryCache.put(ip, jbossFactory);
                    }
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        {
            return jbossFactory;
        }
    }

    public static class WildFlyClassLoader
    extends URLClassLoader {
        private final boolean patchXnio;

        public WildFlyClassLoader(URL[] urls, ClassLoader parent, boolean patchXnio) throws MalformedURLException, RuntimeException {
            super(urls, parent);
            this.patchXnio = patchXnio;
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.contains("jndi.properties")) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (!this.patchXnio) return super.findClass(name);
            if (!"org.xnio.nio.WorkerThread".equals(name)) return super.findClass(name);
            try {
                LOGGER.log(Level.INFO, "Patching the issue #249135");
                String path = name.replace('.', '/').concat(".class");
                try (InputStream is = super.getResourceAsStream(path);){
                    ClassReader cr = new ClassReader(is);
                    ClassWriter cw = new ClassWriter(cr, 2){

                        protected String getCommonSuperClass(String string, String string1) {
                            if ("org/xnio/nio/NioHandle".equals(string) || "org/xnio/nio/NioHandle".equals(string1)) {
                                return "java/lang/Object";
                            }
                            return super.getCommonSuperClass(string, string1);
                        }
                    };
                    ClassNode node = new ClassNode(458752);
                    cr.accept((ClassVisitor)node, 0);
                    for (MethodNode m : node.methods) {
                        if (!"execute".equals(m.name) || !"(Ljava/lang/Runnable;)V".equals(m.desc)) continue;
                        InsnList list = m.instructions;
                        ListIterator it = list.iterator();
                        while (it.hasNext()) {
                            AbstractInsnNode possibleThrow;
                            AbstractInsnNode n = (AbstractInsnNode)it.next();
                            if (!(n instanceof MethodInsnNode)) continue;
                            MethodInsnNode mn = (MethodInsnNode)n;
                            if (!"org/xnio/nio/Log".equals(mn.owner) || !"threadExiting".equals(mn.name) || !"()Ljava/util/concurrent/RejectedExecutionException;".equals(mn.desc) || !it.hasNext() || (possibleThrow = (AbstractInsnNode)it.next()).getOpcode() != 191) continue;
                            it.set(new InsnNode(87));
                            break;
                        }
                        break;
                    }
                    node.accept((ClassVisitor)cw);
                    byte[] newBytecode = cw.toByteArray();
                    Class<?> clazz = super.defineClass(name, newBytecode, 0, newBytecode.length);
                    return clazz;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return super.findClass(name);
        }
    }
}

