/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.utilities.AlwaysValidAssumption;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.Flags;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LayoutStrategy;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.PropertyImpl;
import com.oracle.truffle.object.ShapeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@ExportLibrary(value=DynamicObjectLibrary.class, receiverType=DynamicObject.class, priority=10, transitionLimit="5")
abstract class DynamicObjectLibraryImpl {
    static final int KEY_LIMIT = 3;
    private static final LocationFactory CONSTANT_LOCATION_FACTORY = new LocationFactory(){

        @Override
        public Location createLocation(Shape s, Object v) {
            return s.allocator().constantLocation(v);
        }
    };
    private static final LocationFactory DECLARED_LOCATION_FACTORY = new LocationFactory(){

        @Override
        public Location createLocation(Shape s, Object v) {
            return s.allocator().declaredLocation(v);
        }
    };

    DynamicObjectLibraryImpl() {
    }

    static boolean keyEquals(Object cachedKey, Object key) {
        if (cachedKey instanceof String) {
            return cachedKey == key || key instanceof String && ((String)cachedKey).equals(key);
        }
        if (cachedKey instanceof HiddenKey) {
            return key == cachedKey;
        }
        if (cachedKey instanceof Long) {
            return key instanceof Long && ((Long)cachedKey).equals(key);
        }
        return cachedKey == key || DynamicObjectLibraryImpl.keyEqualsBoundary(cachedKey, key);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    static boolean keyEqualsBoundary(Object cachedKey, Object key) {
        return Objects.equals(cachedKey, key);
    }

    @ExportMessage
    static boolean accepts(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return object.getShape() == cachedShape;
    }

    @ExportMessage
    static Shape getShape(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return cachedShape;
    }

    @ExportMessage
    static Object getOrDefault(DynamicObject object, Object key, Object defaultValue, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        return keyCache.getOrDefault(object, cachedShape, key, defaultValue);
    }

    @ExportMessage
    static int getIntOrDefault(DynamicObject object, Object key, Object defaultValue, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) throws UnexpectedResultException {
        return keyCache.getIntOrDefault(object, cachedShape, key, defaultValue);
    }

    @ExportMessage
    static double getDoubleOrDefault(DynamicObject object, Object key, Object defaultValue, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) throws UnexpectedResultException {
        return keyCache.getDoubleOrDefault(object, cachedShape, key, defaultValue);
    }

    @ExportMessage
    static long getLongOrDefault(DynamicObject object, Object key, Object defaultValue, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) throws UnexpectedResultException {
        return keyCache.getLongOrDefault(object, cachedShape, key, defaultValue);
    }

    @ExportMessage
    static boolean containsKey(DynamicObject object, Object key, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        return keyCache.containsKey(object, cachedShape, key);
    }

    @ExportMessage
    static void put(DynamicObject object, Object key, Object value, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.put(object, cachedShape, key, value, 0L);
    }

    @ExportMessage
    static void putInt(DynamicObject object, Object key, int value, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.putInt(object, cachedShape, key, value, 0L);
    }

    @ExportMessage
    static void putLong(DynamicObject object, Object key, long value, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.putLong(object, cachedShape, key, value, 0L);
    }

    @ExportMessage
    static void putDouble(DynamicObject object, Object key, double value, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.putDouble(object, cachedShape, key, value, 0L);
    }

    @ExportMessage
    static boolean putIfPresent(DynamicObject object, Object key, Object value, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        return keyCache.put(object, cachedShape, key, value, 0x400000000L);
    }

    @ExportMessage
    static void putWithFlags(DynamicObject object, Object key, Object value, int flags, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.put(object, cachedShape, key, value, Flags.propertyFlagsToPutFlags(flags) | 0x800000000L);
    }

    @ExportMessage
    static void putConstant(DynamicObject object, Object key, Object value, int flags, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        keyCache.put(object, cachedShape, key, value, Flags.propertyFlagsToPutFlags(flags) | 0x800000000L | 0x1000000000L);
    }

    @ExportMessage
    public static Property getProperty(DynamicObject object, Object key, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        return keyCache.getProperty(object, cachedShape, key);
    }

    @ExportMessage
    public static boolean setPropertyFlags(DynamicObject object, Object key, int propertyFlags, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached.Shared(value="keyCache") @Cached(value="create(object.getShape(), key)") KeyCacheNode keyCache) {
        return keyCache.setPropertyFlags(object, cachedShape, key, propertyFlags);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public static boolean removeKey(DynamicObject obj, Object key) {
        ShapeImpl oldShape = (ShapeImpl)LayoutImpl.ACCESS.getShape(obj);
        Property property = oldShape.getProperty(key);
        if (property == null) {
            return false;
        }
        Map<Object, Object> archive = null;
        assert ((archive = LayoutImpl.ACCESS.archive(obj)) != null);
        ShapeImpl newShape = oldShape.removeProperty(property);
        assert (oldShape != newShape);
        assert (LayoutImpl.ACCESS.getShape(obj) == oldShape);
        LayoutImpl.ACCESS.setShape(obj, newShape);
        if (!oldShape.isShared()) {
            DynamicObjectLibraryImpl.shiftPropertyValuesAfterRemove(obj, oldShape, newShape);
            LayoutImpl.ACCESS.trimToSize(obj, newShape);
        }
        assert (LayoutImpl.ACCESS.verifyValues(obj, archive));
        return true;
    }

    @ExportMessage
    public static Object getDynamicType(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return cachedShape.getDynamicType();
    }

    @ExportMessage
    public static boolean setDynamicType(DynamicObject object, Object objectType, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached SetDynamicTypeNode setCache) {
        return setCache.execute(object, cachedShape, objectType);
    }

    @ExportMessage
    public static int getShapeFlags(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return cachedShape.getFlags();
    }

    @ExportMessage
    public static boolean setShapeFlags(DynamicObject object, int flags, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached SetFlagsNode setCache) {
        return setCache.execute(object, cachedShape, flags);
    }

    @ExportMessage
    public static boolean isShared(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return cachedShape.isShared();
    }

    @ExportMessage
    public static void markShared(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached MakeSharedNode setCache) {
        setCache.execute(object, cachedShape);
    }

    @ExportMessage
    public static boolean updateShape(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        if (cachedShape.isValid()) {
            return false;
        }
        return DynamicObjectLibraryImpl.updateShapeImpl(object);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean updateShapeImpl(DynamicObject object) {
        return ((ShapeImpl)object.getShape()).getLayout().getStrategy().updateShape(object);
    }

    @ExportMessage
    public static boolean resetShape(DynamicObject object, Shape otherShape, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape, @Cached ResetShapeNode setCache) {
        return setCache.execute(object, cachedShape, otherShape);
    }

    @ExportMessage
    public static Object[] getKeyArray(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return ((ShapeImpl)cachedShape).getKeyArray();
    }

    @ExportMessage
    public static Property[] getPropertyArray(DynamicObject object, @Cached.Shared(value="cachedShape") @Cached(value="object.getShape()", allowUncached=true) Shape cachedShape) {
        return ((ShapeImpl)cachedShape).getPropertyArray();
    }

    private static LocationImpl getLocation(Property existing) {
        return (LocationImpl)existing.getLocation();
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean putUncached(DynamicObject object, Object key, Object value, long putFlags) {
        Shape s = LayoutImpl.ACCESS.getShape(object);
        Property existingProperty = s.getProperty(key);
        if (existingProperty == null && Flags.isSetExisting(putFlags)) {
            return false;
        }
        if (existingProperty != null && !Flags.isUpdateFlags(putFlags) && existingProperty.getLocation().canSet(value)) {
            try {
                DynamicObjectLibraryImpl.getLocation(existingProperty).set(object, value, false);
            }
            catch (FinalLocationException | IncompatibleLocationException e) {
                throw DynamicObjectLibraryImpl.shouldNotHappen(e);
            }
            return true;
        }
        return DynamicObjectLibraryImpl.putUncachedSlow(object, key, value, putFlags);
    }

    private static boolean putUncachedSlow(DynamicObject object, Object key, Object value, long putFlags) {
        Property property;
        ShapeImpl newShape;
        ShapeImpl oldShape;
        CompilerAsserts.neverPartOfCompilation();
        DynamicObjectLibraryImpl.updateShapeImpl(object);
        do {
            LocationFactory locationFactory;
            LayoutStrategy strategy;
            Property existingProperty;
            if ((existingProperty = (oldShape = (ShapeImpl)LayoutImpl.ACCESS.getShape(object)).getProperty(key)) == null) {
                if (Flags.isSetExisting(putFlags)) {
                    return false;
                }
                strategy = oldShape.getLayout().getStrategy();
                locationFactory = DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags);
                newShape = strategy.defineProperty(oldShape, key, value, Flags.getPropertyFlags(putFlags), locationFactory, existingProperty, putFlags);
                property = ((Shape)newShape).getProperty(key);
                continue;
            }
            if (Flags.isUpdateFlags(putFlags) && Flags.getPropertyFlags(putFlags) != existingProperty.getFlags()) {
                strategy = oldShape.getLayout().getStrategy();
                locationFactory = DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags);
                newShape = strategy.defineProperty(oldShape, key, value, Flags.getPropertyFlags(putFlags), locationFactory, existingProperty, putFlags);
                property = ((Shape)newShape).getProperty(key);
                continue;
            }
            if (existingProperty.getLocation().canSet(value)) {
                newShape = oldShape;
                property = existingProperty;
                continue;
            }
            strategy = oldShape.getLayout().getStrategy();
            locationFactory = DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags);
            newShape = strategy.defineProperty(oldShape, key, value, existingProperty.getFlags(), locationFactory, existingProperty, putFlags);
            property = ((Shape)newShape).getProperty(key);
        } while (DynamicObjectLibraryImpl.updateShapeImpl(object));
        assert (LayoutImpl.ACCESS.getShape(object) == oldShape);
        if (oldShape != newShape) {
            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
            try {
                DynamicObjectLibraryImpl.getLocation(property).setInternal(object, value, false);
            }
            catch (IncompatibleLocationException e) {
                throw DynamicObjectLibraryImpl.shouldNotHappen(e);
            }
            DynamicObjectLibraryImpl.updateShapeImpl(object);
        } else {
            try {
                DynamicObjectLibraryImpl.getLocation(property).set(object, value, false);
            }
            catch (FinalLocationException | IncompatibleLocationException e) {
                throw DynamicObjectLibraryImpl.shouldNotHappen(e);
            }
        }
        return true;
    }

    static LocationFactory getLocationFactory(LayoutStrategy strategy, long putFlags) {
        if (Flags.isConstant(putFlags)) {
            return CONSTANT_LOCATION_FACTORY;
        }
        if (Flags.isDeclaration(putFlags)) {
            return DECLARED_LOCATION_FACTORY;
        }
        return strategy.getDefaultLocationFactory(putFlags);
    }

    private static void shiftPropertyValuesAfterRemove(DynamicObject object, ShapeImpl oldShape, ShapeImpl newShape) {
        ArrayList<Move> moves = new ArrayList<Move>();
        ListIterator<Property> iterator = newShape.getPropertyListInternal(false).listIterator();
        while (iterator.hasNext()) {
            Property to = iterator.next();
            Property from = oldShape.getProperty(to.getKey());
            LocationImpl fromLoc = DynamicObjectLibraryImpl.getLocation(from);
            LocationImpl toLoc = DynamicObjectLibraryImpl.getLocation(to);
            if (LocationImpl.isSameLocation(toLoc, fromLoc)) continue;
            assert (!toLoc.isValue());
            Move move = new Move(fromLoc, toLoc, oldShape.getLayout().getStrategy());
            moves.add(move);
        }
        if (!DynamicObjectLibraryImpl.isSorted(moves)) {
            Collections.sort(moves);
        }
        iterator = moves.listIterator(moves.size());
        while (iterator.hasPrevious()) {
            Move current = (Move)((Object)iterator.previous());
            boolean last = !iterator.hasPrevious();
            current.accept(object, last);
        }
    }

    private static boolean isSorted(List<Move> moves) {
        for (int i = 1; i < moves.size(); ++i) {
            Move m2;
            Move m1 = moves.get(i - 1);
            if (m1.compareTo(m2 = moves.get(i)) <= 0) continue;
            return false;
        }
        return true;
    }

    static <T extends CacheData<T>> T filterValid(T cache) {
        if (cache == null) {
            return null;
        }
        Object filteredNext = DynamicObjectLibraryImpl.filterValid(((CacheData)cache).next);
        if (((CacheData)cache).isValid()) {
            if (filteredNext == ((CacheData)cache).next) {
                return (T)cache;
            }
            return ((CacheData)cache).withNext(filteredNext);
        }
        return filteredNext;
    }

    static RuntimeException shouldNotHappen(Exception e) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException(e);
    }

    @GenerateUncached
    static abstract class ResetShapeNode
    extends Node {
        ResetShapeNode() {
        }

        abstract boolean execute(DynamicObject var1, Shape var2, Shape var3);

        @Specialization(guards={"otherShape == cachedOtherShape"})
        static boolean doCached(DynamicObject object, Shape cachedShape, Shape otherShape, @Cached(value="verifyResetShape(cachedShape, otherShape)", allowUncached=true) Shape cachedOtherShape) {
            if (cachedShape == cachedOtherShape) {
                return false;
            }
            LayoutImpl.ACCESS.resizeAndSetShape(object, cachedShape, cachedOtherShape);
            return true;
        }

        static Shape verifyResetShape(Shape currentShape, Shape otherShape) {
            if (((ShapeImpl)otherShape).hasInstanceProperties()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Shape must not contain any instance properties.");
            }
            if (currentShape != otherShape) {
                LayoutImpl.ACCESS.invalidateAllPropertyAssumptions(currentShape);
            }
            return otherShape;
        }
    }

    @GenerateUncached
    static abstract class MakeSharedNode
    extends Node {
        MakeSharedNode() {
        }

        abstract void execute(DynamicObject var1, Shape var2);

        @Specialization
        static void doCached(DynamicObject object, Shape cachedShape, @Cached(value="cachedShape.makeSharedShape()", allowUncached=true) Shape newShape) {
            assert (newShape != cachedShape);
            LayoutImpl.ACCESS.growAndSetShape(object, cachedShape, newShape);
        }
    }

    @GenerateUncached
    static abstract class SetDynamicTypeNode
    extends Node {
        SetDynamicTypeNode() {
        }

        abstract boolean execute(DynamicObject var1, Shape var2, Object var3);

        @Specialization(guards={"objectType == newObjectType"}, limit="3")
        static boolean doCached(DynamicObject object, Shape cachedShape, Object objectType, @Cached(value="objectType", allowUncached=true) Object newObjectType, @Cached(value="shapeSetDynamicType(cachedShape, newObjectType)", allowUncached=true) Shape newShape) {
            if (newShape != cachedShape) {
                LayoutImpl.ACCESS.setShape(object, newShape);
                return true;
            }
            return false;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(DynamicObject object, Shape cachedShape, Object objectType) {
            Shape newShape = SetDynamicTypeNode.shapeSetDynamicType(cachedShape, objectType);
            if (newShape != cachedShape) {
                LayoutImpl.ACCESS.setShape(object, newShape);
                return true;
            }
            return false;
        }

        static Shape shapeSetDynamicType(Shape shape, Object newType) {
            return shape.changeType((ObjectType)newType);
        }
    }

    @GenerateUncached
    static abstract class SetFlagsNode
    extends Node {
        SetFlagsNode() {
        }

        abstract boolean execute(DynamicObject var1, Shape var2, int var3);

        @Specialization(guards={"flags == newFlags"}, limit="3")
        static boolean doCached(DynamicObject object, Shape cachedShape, int flags, @Cached(value="flags", allowUncached=true) int newFlags, @Cached(value="shapeSetFlags(cachedShape, newFlags)", allowUncached=true) Shape newShape) {
            if (newShape != cachedShape) {
                LayoutImpl.ACCESS.setShape(object, newShape);
                return true;
            }
            return false;
        }

        @Specialization(replaces={"doCached"})
        static boolean doUncached(DynamicObject object, Shape cachedShape, int flags) {
            Shape newShape = SetFlagsNode.shapeSetFlags(cachedShape, flags);
            if (newShape != cachedShape) {
                LayoutImpl.ACCESS.setShape(object, newShape);
                return true;
            }
            return false;
        }

        static Shape shapeSetFlags(Shape shape, int newFlags) {
            return ((ShapeImpl)shape).setFlags(newFlags);
        }
    }

    static class PutCacheData
    extends CacheData<PutCacheData> {
        static final PutCacheData GENERIC = new PutCacheData(0L, null, null, null, null);
        final long putFlags;
        final Shape newShape;
        final Property property;
        final Assumption newShapeValidAssumption;

        PutCacheData(long putFlags, Shape newShape, Property property, Assumption newShapeValidAssumption, PutCacheData next) {
            super(next);
            this.putFlags = putFlags;
            this.newShape = newShape;
            this.property = property;
            this.newShapeValidAssumption = newShapeValidAssumption;
        }

        @Override
        protected boolean isValid() {
            return this.newShapeValidAssumption == NeverValidAssumption.INSTANCE || this.newShapeValidAssumption.isValid();
        }

        protected void maybeUpdateShape(DynamicObject store) {
            if (this.newShapeValidAssumption == NeverValidAssumption.INSTANCE) {
                DynamicObjectLibraryImpl.updateShapeImpl(store);
            }
        }

        @Override
        protected PutCacheData withNext(PutCacheData newNext) {
            return new PutCacheData(this.putFlags, this.newShape, this.property, this.newShapeValidAssumption, newNext);
        }
    }

    static abstract class CacheData<T extends CacheData<T>> {
        final T next;

        CacheData(T next) {
            this.next = next;
        }

        protected boolean isValid() {
            return true;
        }

        protected abstract T withNext(T var1);
    }

    static abstract class SpecificKey
    extends KeyCacheEntry {
        final Object cachedKey;
        @CompilerDirectives.CompilationFinal
        PutCacheData cache;

        SpecificKey(Object key, KeyCacheEntry next) {
            super(next);
            this.cachedKey = key;
        }

        static SpecificKey create(Object key, Shape shape, KeyCacheEntry next) {
            Property property;
            if (key != null && (property = shape.getProperty(key)) != null) {
                return new ExistingKey(key, property, next);
            }
            return new MissingKey(key, next);
        }

        protected final boolean assertCachedKeyAndShapeForRead(DynamicObject object, Shape cachedShape, Object key) {
            assert (object.getShape() == cachedShape || cachedShape.isShared());
            assert (DynamicObjectLibraryImpl.keyEquals(this.cachedKey, key));
            return true;
        }

        protected final boolean assertCachedKeyAndShapeForWrite(DynamicObject object, Shape cachedShape, Object key) {
            assert (object.getShape() == cachedShape);
            assert (DynamicObjectLibraryImpl.keyEquals(this.cachedKey, key));
            return true;
        }

        @Override
        public boolean acceptsKey(Object key) {
            return DynamicObjectLibraryImpl.keyEquals(this.cachedKey, key);
        }

        @ExplodeLoop
        protected boolean putImpl(DynamicObject object, Shape cachedShape, Object key, Object value, long putFlags, Property oldProperty) {
            Shape oldShape = cachedShape;
            PutCacheData start = this.cache;
            if (start == PutCacheData.GENERIC || !cachedShape.isValid()) {
                return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
            }
            PutCacheData c = start;
            while (c != null && c.isValid()) {
                block7: {
                    LocationImpl location;
                    block9: {
                        block8: {
                            if (c.putFlags != putFlags) break block7;
                            Property newProperty = c.property;
                            if (newProperty == null) {
                                assert (Flags.isSetExisting(putFlags));
                                return false;
                            }
                            location = DynamicObjectLibraryImpl.getLocation(newProperty);
                            if (!location.canStore(value)) break block7;
                            Shape newShape = c.newShape;
                            if (newShape == oldShape) break block8;
                            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                            break block9;
                        }
                        if (location.isFinal()) break block7;
                    }
                    try {
                        location.set(object, value, object.getShape() == oldShape);
                    }
                    catch (FinalLocationException | IncompatibleLocationException e) {
                        throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                    }
                    c.maybeUpdateShape(object);
                    return true;
                }
                c = (PutCacheData)c.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            KeyCacheNode impl = this.insertIntoPutCache(object, cachedShape, value, putFlags, oldProperty);
            return impl.put(object, cachedShape, key, value, putFlags);
        }

        @ExplodeLoop
        protected boolean putIntImpl(DynamicObject object, Shape cachedShape, Object key, int value, long putFlags, Property oldProperty) {
            Shape oldShape = cachedShape;
            PutCacheData start = this.cache;
            if (start == PutCacheData.GENERIC || !cachedShape.isValid()) {
                return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
            }
            PutCacheData c = start;
            while (c != null && c.isValid()) {
                block17: {
                    LocationImpl location;
                    block28: {
                        block27: {
                            Shape newShape;
                            block24: {
                                block26: {
                                    block25: {
                                        block21: {
                                            block23: {
                                                block22: {
                                                    block18: {
                                                        block20: {
                                                            block19: {
                                                                if (c.putFlags != putFlags) break block17;
                                                                Property newProperty = c.property;
                                                                if (newProperty == null) {
                                                                    assert (Flags.isSetExisting(putFlags));
                                                                    return false;
                                                                }
                                                                location = DynamicObjectLibraryImpl.getLocation(newProperty);
                                                                newShape = c.newShape;
                                                                if (!location.isIntLocation()) break block18;
                                                                if (newShape == oldShape) break block19;
                                                                LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                                                                break block20;
                                                            }
                                                            if (location.isFinal()) break block17;
                                                        }
                                                        try {
                                                            location.setInt(object, value, object.getShape() == oldShape);
                                                        }
                                                        catch (FinalLocationException | IncompatibleLocationException e) {
                                                            throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                                                        }
                                                        c.maybeUpdateShape(object);
                                                        return true;
                                                    }
                                                    if (!location.isImplicitCastIntToLong()) break block21;
                                                    if (newShape == oldShape) break block22;
                                                    LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                                                    break block23;
                                                }
                                                if (location.isFinal()) break block17;
                                            }
                                            try {
                                                location.setLong(object, value, object.getShape() == oldShape);
                                            }
                                            catch (FinalLocationException | IncompatibleLocationException e) {
                                                throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                                            }
                                            c.maybeUpdateShape(object);
                                            return true;
                                        }
                                        if (!location.isImplicitCastIntToDouble()) break block24;
                                        if (newShape == oldShape) break block25;
                                        LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                                        break block26;
                                    }
                                    if (location.isFinal()) break block17;
                                }
                                try {
                                    location.setDouble(object, value, object.getShape() == oldShape);
                                }
                                catch (FinalLocationException | IncompatibleLocationException e) {
                                    throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                                }
                                c.maybeUpdateShape(object);
                                return true;
                            }
                            if (!location.canStore(value)) break block17;
                            if (newShape == oldShape) break block27;
                            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                            break block28;
                        }
                        if (location.isFinal()) break block17;
                    }
                    try {
                        location.set(object, (Object)value, object.getShape() == oldShape);
                    }
                    catch (FinalLocationException | IncompatibleLocationException e) {
                        throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                    }
                    c.maybeUpdateShape(object);
                    return true;
                }
                c = (PutCacheData)c.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            KeyCacheNode impl = this.insertIntoPutCache(object, cachedShape, value, putFlags, oldProperty);
            return impl.putInt(object, cachedShape, key, value, putFlags);
        }

        @ExplodeLoop
        protected boolean putLongImpl(DynamicObject object, Shape cachedShape, Object key, long value, long putFlags, Property oldProperty) {
            Shape oldShape = cachedShape;
            PutCacheData start = this.cache;
            if (start == PutCacheData.GENERIC) {
                return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
            }
            PutCacheData c = start;
            while (c != null) {
                block11: {
                    LocationImpl location;
                    block16: {
                        block15: {
                            Shape newShape;
                            block12: {
                                block14: {
                                    block13: {
                                        if (c.putFlags != putFlags) break block11;
                                        Property newProperty = c.property;
                                        if (newProperty == null) {
                                            assert (Flags.isSetExisting(putFlags));
                                            return false;
                                        }
                                        location = DynamicObjectLibraryImpl.getLocation(newProperty);
                                        if (!location.isLongLocation()) break block12;
                                        newShape = c.newShape;
                                        if (newShape == oldShape) break block13;
                                        LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                                        break block14;
                                    }
                                    if (location.isFinal()) break block11;
                                }
                                try {
                                    location.setLong(object, value, object.getShape() == oldShape);
                                }
                                catch (FinalLocationException | IncompatibleLocationException e) {
                                    throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                                }
                                c.maybeUpdateShape(object);
                                return true;
                            }
                            if (!location.canStore(value)) break block11;
                            newShape = c.newShape;
                            if (newShape == oldShape) break block15;
                            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                            break block16;
                        }
                        if (location.isFinal()) break block11;
                    }
                    try {
                        location.set(object, (Object)value, object.getShape() == oldShape);
                    }
                    catch (FinalLocationException | IncompatibleLocationException e) {
                        throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                    }
                    c.maybeUpdateShape(object);
                    return true;
                }
                c = (PutCacheData)c.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            KeyCacheNode impl = this.insertIntoPutCache(object, cachedShape, value, putFlags, oldProperty);
            return impl.putLong(object, cachedShape, key, value, putFlags);
        }

        @ExplodeLoop
        protected boolean putDoubleImpl(DynamicObject object, Shape cachedShape, Object key, double value, long putFlags, Property oldProperty) {
            Shape oldShape = cachedShape;
            PutCacheData start = this.cache;
            if (start == PutCacheData.GENERIC) {
                return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
            }
            PutCacheData c = start;
            while (c != null) {
                block11: {
                    LocationImpl location;
                    block16: {
                        block15: {
                            Shape newShape;
                            Property newProperty;
                            block12: {
                                block14: {
                                    block13: {
                                        if (c.putFlags != putFlags) break block11;
                                        newProperty = c.property;
                                        if (newProperty == null) {
                                            assert (Flags.isSetExisting(putFlags));
                                            return false;
                                        }
                                        location = DynamicObjectLibraryImpl.getLocation(newProperty);
                                        if (!location.isDoubleLocation()) break block12;
                                        newShape = c.newShape;
                                        if (newShape == oldShape) break block13;
                                        LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                                        break block14;
                                    }
                                    if (location.isFinal()) break block11;
                                }
                                try {
                                    location.setDouble(object, value, object.getShape() == oldShape);
                                }
                                catch (FinalLocationException | IncompatibleLocationException e) {
                                    throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                                }
                                c.maybeUpdateShape(object);
                                return true;
                            }
                            if (!newProperty.getLocation().canStore(value)) break block11;
                            newShape = c.newShape;
                            if (newShape == oldShape) break block15;
                            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                            break block16;
                        }
                        if (location.isFinal()) break block11;
                    }
                    try {
                        location.set(object, (Object)value, object.getShape() == oldShape);
                    }
                    catch (FinalLocationException | IncompatibleLocationException e) {
                        throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                    }
                    c.maybeUpdateShape(object);
                    return true;
                }
                c = (PutCacheData)c.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            KeyCacheNode impl = this.insertIntoPutCache(object, cachedShape, value, putFlags, oldProperty);
            return impl.putDouble(object, cachedShape, key, value, putFlags);
        }

        @ExplodeLoop
        protected boolean putBooleanImpl(DynamicObject object, Shape cachedShape, Object key, boolean value, long putFlags, Property oldProperty) {
            Shape oldShape = cachedShape;
            PutCacheData start = this.cache;
            if (start == PutCacheData.GENERIC) {
                return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
            }
            PutCacheData c = start;
            while (c != null) {
                block7: {
                    LocationImpl location;
                    block9: {
                        block8: {
                            if (c.putFlags != putFlags) break block7;
                            Property newProperty = c.property;
                            if (newProperty == null) {
                                assert (Flags.isSetExisting(putFlags));
                                return false;
                            }
                            location = DynamicObjectLibraryImpl.getLocation(newProperty);
                            if (!location.canStore(value)) break block7;
                            Shape newShape = c.newShape;
                            if (newShape == oldShape) break block8;
                            LayoutImpl.ACCESS.growAndSetShape(object, oldShape, newShape);
                            break block9;
                        }
                        if (location.isFinal()) break block7;
                    }
                    try {
                        location.set(object, (Object)value, object.getShape() == oldShape);
                    }
                    catch (FinalLocationException | IncompatibleLocationException e) {
                        throw DynamicObjectLibraryImpl.shouldNotHappen(e);
                    }
                    c.maybeUpdateShape(object);
                    return true;
                }
                c = (PutCacheData)c.next;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            KeyCacheNode impl = this.insertIntoPutCache(object, cachedShape, value, putFlags, oldProperty);
            return impl.putBoolean(object, cachedShape, key, value, putFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected KeyCacheNode insertIntoPutCache(DynamicObject object, Shape cachedShape, Object value, long putFlags, Property property) {
            CompilerAsserts.neverPartOfCompilation();
            if (!cachedShape.isValid()) {
                return Generic.instance();
            }
            Lock lock = this.getLock();
            lock.lock();
            try {
                Property newProperty;
                PutCacheData tail = DynamicObjectLibraryImpl.filterValid(this.cache);
                ShapeImpl oldShape = (ShapeImpl)cachedShape;
                ShapeImpl newShape = this.getNewShape(object, value, putFlags, property, oldShape);
                if (!oldShape.isValid()) {
                    Generic generic = Generic.instance();
                    return generic;
                }
                if (newShape == oldShape) {
                    newProperty = property;
                } else {
                    newProperty = newShape.getProperty(this.cachedKey);
                    assert (newProperty.getLocation().canSet(value));
                }
                Assumption newShapeValid = SpecificKey.getShapeValidAssumption(oldShape, newShape);
                this.cache = new PutCacheData(putFlags, newShape, newProperty, newShapeValid, tail);
                SpecificKey specificKey = this;
                return specificKey;
            }
            finally {
                lock.unlock();
            }
        }

        private ShapeImpl getNewShape(DynamicObject object, Object value, long putFlags, Property property, ShapeImpl oldShape) {
            if (property == null) {
                if (Flags.isSetExisting(putFlags)) {
                    return oldShape;
                }
                int propertyFlags = Flags.getPropertyFlags(putFlags);
                LayoutStrategy strategy = oldShape.getLayout().getStrategy();
                return oldShape.defineProperty(this.cachedKey, value, propertyFlags, DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags));
            }
            if (Flags.isUpdateFlags(putFlags) && Flags.getPropertyFlags(putFlags) != property.getFlags()) {
                int propertyFlags = Flags.getPropertyFlags(putFlags);
                LayoutStrategy strategy = oldShape.getLayout().getStrategy();
                return oldShape.defineProperty(this.cachedKey, value, propertyFlags, DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags));
            }
            Location location = property.getLocation();
            if (!location.isDeclared() && !location.canSet(value)) {
                assert (oldShape == LayoutImpl.ACCESS.getShape(object));
                LayoutStrategy strategy = oldShape.getLayout().getStrategy();
                ShapeImpl newShape = strategy.definePropertyGeneralize(oldShape, property, value, DynamicObjectLibraryImpl.getLocationFactory(strategy, putFlags), putFlags);
                assert (newShape != oldShape);
                return newShape;
            }
            if (location.isDeclared()) {
                return oldShape.defineProperty(this.cachedKey, value, property.getFlags());
            }
            assert (location.canSet(value));
            return oldShape;
        }

        private static Assumption getShapeValidAssumption(Shape oldShape, Shape newShape) {
            if (oldShape == newShape) {
                return AlwaysValidAssumption.INSTANCE;
            }
            return newShape.isValid() ? newShape.getValidAssumption() : NeverValidAssumption.INSTANCE;
        }

        static class MissingKey
        extends SpecificKey {
            MissingKey(Object key, KeyCacheEntry next) {
                super(key, next);
            }

            @Override
            public Object getOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return defaultValue;
            }

            @Override
            public boolean put(DynamicObject object, Shape cachedShape, Object key, Object value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putImpl(object, cachedShape, key, value, putFlags, null);
            }

            @Override
            public boolean putInt(DynamicObject object, Shape cachedShape, Object key, int value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putIntImpl(object, cachedShape, key, value, putFlags, null);
            }

            @Override
            public boolean putLong(DynamicObject object, Shape cachedShape, Object key, long value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putLongImpl(object, cachedShape, key, value, putFlags, null);
            }

            @Override
            public boolean putDouble(DynamicObject object, Shape cachedShape, Object key, double value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putDoubleImpl(object, cachedShape, key, value, putFlags, null);
            }

            @Override
            public boolean putBoolean(DynamicObject object, Shape cachedShape, Object key, boolean value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putBooleanImpl(object, cachedShape, key, value, putFlags, null);
            }

            @Override
            public boolean containsKey(DynamicObject object, Shape cachedShape, Object key) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return false;
            }

            @Override
            public Property getProperty(DynamicObject object, Shape cachedShape, Object key) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return null;
            }

            @Override
            public int getIntOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                return LocationImpl.expectInteger(defaultValue);
            }

            @Override
            public long getLongOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                return LocationImpl.expectLong(defaultValue);
            }

            @Override
            public double getDoubleOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                return LocationImpl.expectDouble(defaultValue);
            }

            @Override
            public boolean getBooleanOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                return LocationImpl.expectBoolean(defaultValue);
            }

            @Override
            public boolean setPropertyFlags(DynamicObject object, Shape cachedShape, Object key, int propertyFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return false;
            }
        }

        static class ExistingKey
        extends SpecificKey {
            final Property cachedProperty;

            ExistingKey(Object key, Property property, KeyCacheEntry next) {
                super(key, next);
                this.cachedProperty = property;
            }

            private static boolean guard(DynamicObject object, Shape cachedShape) {
                return object.getShape() == cachedShape;
            }

            @Override
            public Object getOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return DynamicObjectLibraryImpl.getLocation(this.cachedProperty).get(object, ExistingKey.guard(object, cachedShape));
            }

            @Override
            public int getIntOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return DynamicObjectLibraryImpl.getLocation(this.cachedProperty).getInt(object, ExistingKey.guard(object, cachedShape));
            }

            @Override
            public long getLongOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return DynamicObjectLibraryImpl.getLocation(this.cachedProperty).getLong(object, ExistingKey.guard(object, cachedShape));
            }

            @Override
            public double getDoubleOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return DynamicObjectLibraryImpl.getLocation(this.cachedProperty).getDouble(object, ExistingKey.guard(object, cachedShape));
            }

            @Override
            public boolean getBooleanOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return DynamicObjectLibraryImpl.getLocation(this.cachedProperty).getBoolean(object, ExistingKey.guard(object, cachedShape));
            }

            @Override
            public boolean put(DynamicObject object, Shape cachedShape, Object key, Object value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putImpl(object, cachedShape, key, value, putFlags, this.cachedProperty);
            }

            @Override
            public boolean putInt(DynamicObject object, Shape cachedShape, Object key, int value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putIntImpl(object, cachedShape, key, value, putFlags, this.cachedProperty);
            }

            @Override
            public boolean putLong(DynamicObject object, Shape cachedShape, Object key, long value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putLongImpl(object, cachedShape, key, value, putFlags, this.cachedProperty);
            }

            @Override
            public boolean putDouble(DynamicObject object, Shape cachedShape, Object key, double value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putDoubleImpl(object, cachedShape, key, value, putFlags, this.cachedProperty);
            }

            @Override
            public boolean putBoolean(DynamicObject object, Shape cachedShape, Object key, boolean value, long putFlags) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                return this.putBooleanImpl(object, cachedShape, key, value, putFlags, this.cachedProperty);
            }

            @Override
            public boolean containsKey(DynamicObject object, Shape cachedShape, Object key) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return true;
            }

            @Override
            public Property getProperty(DynamicObject object, Shape cachedShape, Object key) {
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForRead(object, cachedShape, key));
                return this.cachedProperty;
            }

            @Override
            public boolean setPropertyFlags(DynamicObject object, Shape cachedShape, Object key, int propertyFlags) {
                ShapeImpl oldShape;
                ShapeImpl newShape;
                CompilerAsserts.partialEvaluationConstant(cachedShape);
                assert (this.assertCachedKeyAndShapeForWrite(object, cachedShape, key));
                if (this.cachedProperty.getFlags() != propertyFlags && (newShape = ExistingKey.changePropertyFlags(oldShape = (ShapeImpl)cachedShape, (PropertyImpl)this.cachedProperty, propertyFlags)) != oldShape) {
                    LayoutImpl.ACCESS.setShape(object, newShape);
                }
                return true;
            }

            @CompilerDirectives.TruffleBoundary
            private static ShapeImpl changePropertyFlags(ShapeImpl shape, PropertyImpl cachedProperty, int propertyFlags) {
                return shape.replaceProperty(cachedProperty, cachedProperty.copyWithFlags(propertyFlags));
            }
        }
    }

    static class AnyKey
    extends KeyCacheNode {
        @Node.Child
        private KeyCacheEntry keyCache;

        AnyKey(KeyCacheEntry keyCache) {
            this.keyCache = keyCache;
        }

        public static KeyCacheNode create() {
            return new AnyKey(null);
        }

        public static KeyCacheNode create(Object key, Shape cachedShape) {
            return new AnyKey(SpecificKey.create(key, cachedShape, null));
        }

        @Override
        @ExplodeLoop
        public Object getOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getOrDefault(object, cachedShape, key, defaultValue);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getOrDefault(object, cachedShape, key, defaultValue);
                }
            }
            return Generic.instance().getOrDefault(object, cachedShape, key, defaultValue);
        }

        @Override
        @ExplodeLoop
        public int getIntOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getIntOrDefault(object, cachedShape, key, defaultValue);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getIntOrDefault(object, cachedShape, key, defaultValue);
                }
            }
            return Generic.instance().getIntOrDefault(object, cachedShape, key, defaultValue);
        }

        @Override
        @ExplodeLoop
        public long getLongOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getLongOrDefault(object, cachedShape, key, defaultValue);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getLongOrDefault(object, cachedShape, key, defaultValue);
                }
            }
            return Generic.instance().getLongOrDefault(object, cachedShape, key, defaultValue);
        }

        @Override
        @ExplodeLoop
        public double getDoubleOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getDoubleOrDefault(object, cachedShape, key, defaultValue);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getDoubleOrDefault(object, cachedShape, key, defaultValue);
                }
            }
            return Generic.instance().getDoubleOrDefault(object, cachedShape, key, defaultValue);
        }

        @Override
        @ExplodeLoop
        public boolean getBooleanOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getBooleanOrDefault(object, cachedShape, key, defaultValue);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getBooleanOrDefault(object, cachedShape, key, defaultValue);
                }
            }
            return Generic.instance().getBooleanOrDefault(object, cachedShape, key, defaultValue);
        }

        @Override
        @ExplodeLoop
        public boolean put(DynamicObject object, Shape cachedShape, Object key, Object value, long putFlags) {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.put(object, cachedShape, key, value, putFlags);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.put(object, cachedShape, key, value, putFlags);
                }
            }
            return Generic.instance().put(object, cachedShape, key, value, putFlags);
        }

        @Override
        @ExplodeLoop
        public boolean containsKey(DynamicObject object, Shape cachedShape, Object key) {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.containsKey(object, cachedShape, key);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.containsKey(object, cachedShape, key);
                }
            }
            return Generic.instance().containsKey(object, cachedShape, key);
        }

        @Override
        @ExplodeLoop
        public Property getProperty(DynamicObject object, Shape cachedShape, Object key) {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.getProperty(object, cachedShape, key);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.getProperty(object, cachedShape, key);
                }
            }
            return Generic.instance().getProperty(object, cachedShape, key);
        }

        @Override
        @ExplodeLoop
        public boolean setPropertyFlags(DynamicObject object, Shape cachedShape, Object key, int propertyFlags) {
            KeyCacheEntry start = this.keyCache;
            if (start != KeyCacheNode.getUncached()) {
                KeyCacheEntry c = start;
                while (c != null) {
                    if (c.acceptsKey(key)) {
                        return c.setPropertyFlags(object, cachedShape, key, propertyFlags);
                    }
                    c = c.next;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                KeyCacheNode impl = this.insertIntoKeyCache(key, cachedShape);
                if (impl != null) {
                    return impl.setPropertyFlags(object, cachedShape, key, propertyFlags);
                }
            }
            return Generic.instance().setPropertyFlags(object, cachedShape, key, propertyFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyCacheNode insertIntoKeyCache(Object key, Shape cachedShape) {
            CompilerAsserts.neverPartOfCompilation();
            Lock lock = this.getLock();
            lock.lock();
            try {
                KeyCacheEntry tail = this.keyCache;
                int cachedCount = 0;
                boolean generic = false;
                KeyCacheEntry c = tail;
                while (c != null) {
                    if (c == KeyCacheNode.getUncached()) {
                        generic = true;
                        break;
                    }
                    ++cachedCount;
                    if (c.acceptsKey(key)) {
                        KeyCacheEntry keyCacheEntry = c;
                        return keyCacheEntry;
                    }
                    c = c.next;
                }
                if (cachedCount >= 3) {
                    generic = true;
                    this.keyCache = KeyCacheNode.getUncached();
                }
                if (generic) {
                    c = null;
                    return c;
                }
                if (cachedCount == 1) {
                    this.reportPolymorphicSpecialize();
                }
                SpecificKey newEntry = SpecificKey.create(key, cachedShape, tail);
                this.insert(newEntry);
                this.keyCache = newEntry;
                AnyKey anyKey = this;
                return anyKey;
            }
            finally {
                lock.unlock();
            }
        }
    }

    static class Generic
    extends KeyCacheEntry {
        private static final Generic INSTANCE = new Generic();

        Generic() {
            super(null);
        }

        static Generic instance() {
            return INSTANCE;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object getOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) {
            Property existing = LayoutImpl.ACCESS.getShape(object).getProperty(key);
            if (existing != null) {
                return DynamicObjectLibraryImpl.getLocation(existing).get(object, false);
            }
            return defaultValue;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public int getIntOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            Property existing = LayoutImpl.ACCESS.getShape(object).getProperty(key);
            if (existing != null) {
                return DynamicObjectLibraryImpl.getLocation(existing).getInt(object, false);
            }
            return LocationImpl.expectInteger(defaultValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long getLongOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            Property existing = LayoutImpl.ACCESS.getShape(object).getProperty(key);
            if (existing != null) {
                return DynamicObjectLibraryImpl.getLocation(existing).getLong(object, false);
            }
            return LocationImpl.expectLong(defaultValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public double getDoubleOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            Property existing = LayoutImpl.ACCESS.getShape(object).getProperty(key);
            if (existing != null) {
                return DynamicObjectLibraryImpl.getLocation(existing).getDouble(object, false);
            }
            return LocationImpl.expectDouble(defaultValue);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean getBooleanOrDefault(DynamicObject object, Shape cachedShape, Object key, Object defaultValue) throws UnexpectedResultException {
            Property existing = LayoutImpl.ACCESS.getShape(object).getProperty(key);
            if (existing != null) {
                return DynamicObjectLibraryImpl.getLocation(existing).getBoolean(object, false);
            }
            return LocationImpl.expectBoolean(defaultValue);
        }

        @Override
        public boolean put(DynamicObject object, Shape cachedShape, Object key, Object value, long putFlags) {
            return DynamicObjectLibraryImpl.putUncached(object, key, value, putFlags);
        }

        @Override
        public boolean containsKey(DynamicObject object, Shape cachedShape, Object key) {
            Property existing = this.getProperty(object, cachedShape, key);
            return existing != null;
        }

        @Override
        public Property getProperty(DynamicObject object, Shape cachedShape, Object key) {
            return LayoutImpl.ACCESS.getShape(object).getProperty(key);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean setPropertyFlags(DynamicObject object, Shape cachedShape, Object key, int propertyFlags) {
            ShapeImpl newShape;
            ShapeImpl oldShape = (ShapeImpl)LayoutImpl.ACCESS.getShape(object);
            Property existingProperty = oldShape.getProperty(key);
            if (existingProperty == null) {
                return false;
            }
            if (existingProperty.getFlags() != propertyFlags && (newShape = oldShape.replaceProperty(existingProperty, ((PropertyImpl)existingProperty).copyWithFlags(propertyFlags))) != oldShape) {
                LayoutImpl.ACCESS.setShape(object, newShape);
            }
            return true;
        }
    }

    static abstract class KeyCacheEntry
    extends KeyCacheNode {
        @Node.Child
        KeyCacheEntry next;

        KeyCacheEntry(KeyCacheEntry next) {
            this.next = next;
        }

        public boolean acceptsKey(Object key) {
            return true;
        }
    }

    static abstract class KeyCacheNode
    extends Node {
        KeyCacheNode() {
        }

        public abstract Object getOrDefault(DynamicObject var1, Shape var2, Object var3, Object var4);

        public abstract int getIntOrDefault(DynamicObject var1, Shape var2, Object var3, Object var4) throws UnexpectedResultException;

        public abstract long getLongOrDefault(DynamicObject var1, Shape var2, Object var3, Object var4) throws UnexpectedResultException;

        public abstract double getDoubleOrDefault(DynamicObject var1, Shape var2, Object var3, Object var4) throws UnexpectedResultException;

        public abstract boolean getBooleanOrDefault(DynamicObject var1, Shape var2, Object var3, Object var4) throws UnexpectedResultException;

        public abstract boolean put(DynamicObject var1, Shape var2, Object var3, Object var4, long var5);

        public abstract boolean containsKey(DynamicObject var1, Shape var2, Object var3);

        public abstract Property getProperty(DynamicObject var1, Shape var2, Object var3);

        public abstract boolean setPropertyFlags(DynamicObject var1, Shape var2, Object var3, int var4);

        public boolean putInt(DynamicObject object, Shape cachedShape, Object key, int value, long putFlags) {
            return this.put(object, cachedShape, key, value, putFlags);
        }

        public boolean putLong(DynamicObject object, Shape cachedShape, Object key, long value, long putFlags) {
            return this.put(object, cachedShape, key, value, putFlags);
        }

        public boolean putDouble(DynamicObject object, Shape cachedShape, Object key, double value, long putFlags) {
            return this.put(object, cachedShape, key, value, putFlags);
        }

        public boolean putBoolean(DynamicObject object, Shape cachedShape, Object key, boolean value, long putFlags) {
            return this.put(object, cachedShape, key, value, putFlags);
        }

        static KeyCacheNode create(Shape cachedShape, Object key) {
            if (key == null) {
                return KeyCacheNode.getUncached();
            }
            return AnyKey.create(key, cachedShape);
        }

        static KeyCacheEntry getUncached() {
            return Generic.instance();
        }
    }

    private static class Move
    implements Comparable<Move> {
        private final LocationImpl fromLoc;
        private final LocationImpl toLoc;
        private final LayoutStrategy strategy;

        Move(LocationImpl fromLoc, LocationImpl toLoc, LayoutStrategy strategy) {
            this.fromLoc = fromLoc;
            this.toLoc = toLoc;
            this.strategy = strategy;
        }

        public void accept(DynamicObject obj, boolean last) {
            try {
                Object fromValue = this.fromLoc.get(obj, false);
                this.toLoc.setInternal(obj, fromValue, false);
                if (last && this.fromLoc instanceof CoreLocations.ObjectLocation && fromValue != null) {
                    this.fromLoc.setInternal(obj, null, false);
                }
            }
            catch (IncompatibleLocationException e) {
                throw DynamicObjectLibraryImpl.shouldNotHappen(e);
            }
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return this.fromLoc + " => " + this.toLoc;
        }

        @Override
        public int compareTo(Move other) {
            int order = Integer.compare(this.strategy.getLocationOrdinal(this.fromLoc), this.strategy.getLocationOrdinal(other.fromLoc));
            assert (order == Integer.compare(this.strategy.getLocationOrdinal(this.toLoc), this.strategy.getLocationOrdinal(other.toLoc)));
            return -order;
        }
    }
}

